/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.metric.process;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.GaugeData;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.python.metric.process.FlinkMetricContainer;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FlinkMetricContainerTest {
    private InterceptingOperatorMetricGroup metricGroup = new InterceptingOperatorMetricGroup();
    private FlinkMetricContainer container;
    private static final List<String> DEFAULT_SCOPE_COMPONENTS = Arrays.asList("key", "value", "MetricGroupType.key", "MetricGroupType.value");
    private static final String DEFAULT_NAMESPACE = "[\"key\", \"value\", \"MetricGroupType.key\", \"MetricGroupType.value\"]";

    FlinkMetricContainerTest() {
    }

    @BeforeEach
    void beforeTest() {
        this.metricGroup = new InterceptingOperatorMetricGroup(){

            public MetricGroup addGroup(int name) {
                return this;
            }

            public MetricGroup addGroup(String name) {
                return this;
            }

            public MetricGroup addGroup(String key, String value) {
                return this;
            }
        };
        this.container = new FlinkMetricContainer((MetricGroup)this.metricGroup);
    }

    @Test
    void testGetNameSpaceArray() {
        String json = DEFAULT_NAMESPACE;
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)json, (String)"name"));
        Assertions.assertThat((List)FlinkMetricContainer.getNameSpaceArray((MetricKey)key)).isEqualTo(DEFAULT_SCOPE_COMPONENTS);
    }

    @Test
    void testGetFlinkMetricIdentifierString() {
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)DEFAULT_NAMESPACE, (String)"name"));
        Assertions.assertThat((String)FlinkMetricContainer.getFlinkMetricIdentifierString((MetricKey)key)).isEqualTo("key.value.name");
    }

    @Test
    void testRegisterMetricGroup() {
        MetricKey key = MetricKey.create((String)"step", (MetricName)MetricName.named((String)DEFAULT_NAMESPACE, (String)"name"));
        MetricRegistry registry = NoOpMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup(registry), "root");
        MetricGroup metricGroup = FlinkMetricContainer.registerMetricGroup((MetricKey)key, (MetricGroup)root);
        Assertions.assertThat((Object[])metricGroup.getScopeComponents()).isEqualTo((Object)Arrays.asList("root", "key", "value").toArray());
    }

    @Test
    void testCounterMonitoringInfoUpdate() {
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myCounter").setLabel("PTRANSFORM", "anyPTransform").setInt64SumValue(111L).build();
        Assertions.assertThat((Object)this.metricGroup.get("myCounter")).isNull();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        Counter userCounter = (Counter)this.metricGroup.get("myCounter");
        Assertions.assertThat((long)userCounter.getCount()).isEqualTo(111L);
    }

    @Test
    void testMeterMonitoringInfoUpdate() {
        String namespace = "[\"key\", \"value\", \"MetricGroupType.key\", \"MetricGroupType.value\", \"60\"]";
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", namespace).setLabel("NAME", "myMeter").setLabel("PTRANSFORM", "anyPTransform").setInt64SumValue(111L).build();
        Assertions.assertThat((Object)this.metricGroup.get("myMeter")).isNull();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        MeterView userMeter = (MeterView)this.metricGroup.get("myMeter");
        userMeter.update();
        Assertions.assertThat((long)userMeter.getCount()).isEqualTo(111L);
        Assertions.assertThat((double)userMeter.getRate()).isEqualTo(1.85);
    }

    @Test
    void testGaugeMonitoringInfoUpdate() {
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myGauge").setLabel("PTRANSFORM", "anyPTransform").setInt64LatestValue(GaugeData.create((long)111L)).build();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        FlinkMetricContainer.FlinkGauge myGauge = (FlinkMetricContainer.FlinkGauge)this.metricGroup.get("myGauge");
        Assertions.assertThat((Long)myGauge.getValue()).isEqualTo(111L);
    }

    @Test
    void testDistributionMonitoringInfoUpdate() {
        MetricsApi.MonitoringInfo userMonitoringInfo = new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.USER_DISTRIBUTION_INT64).setLabel("NAMESPACE", DEFAULT_NAMESPACE).setLabel("NAME", "myDistribution").setLabel("PTRANSFORM", "anyPTransform").setInt64DistributionValue(DistributionData.create((long)30L, (long)10L, (long)1L, (long)5L)).build();
        this.container.updateMetrics("step", (List)ImmutableList.of((Object)userMonitoringInfo));
        FlinkMetricContainer.FlinkDistributionGauge myGauge = (FlinkMetricContainer.FlinkDistributionGauge)this.metricGroup.get("myDistribution");
        Assertions.assertThat((Object)myGauge.getValue()).isEqualTo((Object)DistributionResult.create((long)30L, (long)10L, (long)1L, (long)5L));
    }
}

