/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.util.List;
import org.apache.flink.client.python.PythonDriverOptions;
import org.apache.flink.client.python.PythonDriverOptionsParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonDriverOptionsParserFactoryTest {
    private static final CommandLineParser<PythonDriverOptions> commandLineParser = new CommandLineParser((ParserResultFactory)new PythonDriverOptionsParserFactory());

    PythonDriverOptionsParserFactoryTest() {
    }

    @Test
    void testPythonDriverOptionsParsing() throws FlinkParseException {
        String[] args = new String[]{"--python", "xxx.py", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test
    void testPymoduleOptionParsing() throws FlinkParseException {
        String[] args = new String[]{"--pyModule", "xxx", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test
    void testShortOptions() throws FlinkParseException {
        String[] args = new String[]{"-py", "xxx.py", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test
    void testMultipleEntrypointsSpecified() {
        String[] args = new String[]{"--python", "xxx.py", "--pyModule", "yyy", "--input", "in.txt"};
        Assertions.assertThatThrownBy(() -> commandLineParser.parse(args)).isInstanceOf(FlinkParseException.class);
    }

    @Test
    void testEntrypointNotSpecified() {
        String[] args = new String[]{"--input", "in.txt"};
        Assertions.assertThatThrownBy(() -> commandLineParser.parse(args)).isInstanceOf(FlinkParseException.class);
    }

    private void verifyPythonDriverOptionsParsing(String[] args) throws FlinkParseException {
        PythonDriverOptions pythonCommandOptions = (PythonDriverOptions)commandLineParser.parse(args);
        if (pythonCommandOptions.getEntryPointScript().isPresent()) {
            Assertions.assertThat((String)((String)pythonCommandOptions.getEntryPointScript().get())).isEqualTo("xxx.py");
        } else {
            Assertions.assertThat((String)pythonCommandOptions.getEntryPointModule()).isEqualTo("xxx");
        }
        List programArgs = pythonCommandOptions.getProgramArgs();
        Assertions.assertThat((List)programArgs).containsExactly((Object[])new String[]{"--input", "in.txt"});
    }
}

