/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.flink.client.cli.ProgramOptionsUtils;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonProgramOptionsITCase {
    PythonProgramOptionsITCase() {
    }

    @Test
    void testConfigurePythonExecution() throws Exception {
        String[] args = new String[]{"--python", "xxx.py", "--pyModule", "xxx", "--pyFiles", "/absolute/a.py,relative/b.py,relative/c.py", "--pyRequirements", "d.txt#e_dir", "--pyExecutable", "/usr/bin/python", "--pyArchives", "g.zip,h.zip#data,h.zip#data2", "userarg1", "userarg2"};
        final File[] dummyJobJar = new File[]{null};
        Files.walkFileTree(FileSystems.getDefault().getPath(System.getProperty("user.dir") + "/target/artifacts", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.visitFile(file, attrs);
                if (file.getFileName().toString().startsWith("dummy")) {
                    dummyJobJar[0] = file.toFile();
                }
                return result;
            }
        });
        PackagedProgram packagedProgram = PackagedProgram.newBuilder().setArguments(args).setJarFile(dummyJobJar[0]).build();
        Configuration configuration = new Configuration();
        ProgramOptionsUtils.configurePythonExecution((Configuration)configuration, (PackagedProgram)packagedProgram);
        Assertions.assertThat((String)((String)configuration.get(PythonOptions.PYTHON_FILES))).isEqualTo("/absolute/a.py,relative/b.py,relative/c.py");
        Assertions.assertThat((String)((String)configuration.get(PythonOptions.PYTHON_REQUIREMENTS))).isEqualTo("d.txt#e_dir");
        Assertions.assertThat((String)((String)configuration.get(PythonOptions.PYTHON_ARCHIVES))).isEqualTo("g.zip,h.zip#data,h.zip#data2");
        Assertions.assertThat((String)((String)configuration.get(PythonOptions.PYTHON_EXECUTABLE))).isEqualTo("/usr/bin/python");
        Assertions.assertThat((Object[])packagedProgram.getArguments()).containsExactly((Object[])new String[]{"--python", "xxx.py", "--pyModule", "xxx", "userarg1", "userarg2"});
    }
}

