/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha2;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesFilter;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesFilterBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha2.NamedResourcesFilterFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceFilter;

public class ResourceFilterFluent<A extends ResourceFilterFluent<A>>
extends BaseFluent<A> {
    private String driverName;
    private NamedResourcesFilterBuilder namedResources;
    private Map<String, Object> additionalProperties;

    public ResourceFilterFluent() {
    }

    public ResourceFilterFluent(ResourceFilter instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceFilter instance) {
        ResourceFilter resourceFilter = instance = instance != null ? instance : new ResourceFilter();
        if (instance != null) {
            this.withDriverName(instance.getDriverName());
            this.withNamedResources(instance.getNamedResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    public boolean hasDriverName() {
        return this.driverName != null;
    }

    public NamedResourcesFilter buildNamedResources() {
        return this.namedResources != null ? this.namedResources.build() : null;
    }

    public A withNamedResources(NamedResourcesFilter namedResources) {
        this._visitables.remove("namedResources");
        if (namedResources != null) {
            this.namedResources = new NamedResourcesFilterBuilder(namedResources);
            this._visitables.get("namedResources").add(this.namedResources);
        } else {
            this.namedResources = null;
            this._visitables.get("namedResources").remove(this.namedResources);
        }
        return (A)this;
    }

    public boolean hasNamedResources() {
        return this.namedResources != null;
    }

    public A withNewNamedResources(String selector) {
        return this.withNamedResources(new NamedResourcesFilter(selector));
    }

    public NamedResourcesNested<A> withNewNamedResources() {
        return new NamedResourcesNested(null);
    }

    public NamedResourcesNested<A> withNewNamedResourcesLike(NamedResourcesFilter item) {
        return new NamedResourcesNested(item);
    }

    public NamedResourcesNested<A> editNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(null));
    }

    public NamedResourcesNested<A> editOrNewNamedResources() {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(new NamedResourcesFilterBuilder().build()));
    }

    public NamedResourcesNested<A> editOrNewNamedResourcesLike(NamedResourcesFilter item) {
        return this.withNewNamedResourcesLike(Optional.ofNullable(this.buildNamedResources()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceFilterFluent that = (ResourceFilterFluent)o;
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.namedResources, that.namedResources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driverName, this.namedResources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.namedResources != null) {
            sb.append("namedResources:");
            sb.append(this.namedResources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamedResourcesNested<N>
    extends NamedResourcesFilterFluent<NamedResourcesNested<N>>
    implements Nested<N> {
        NamedResourcesFilterBuilder builder;

        NamedResourcesNested(NamedResourcesFilter item) {
            this.builder = new NamedResourcesFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceFilterFluent.this.withNamedResources(this.builder.build());
        }

        public N endNamedResources() {
            return this.and();
        }
    }
}

