/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames;

public class CustomResourceDefinitionNamesFluent<A extends CustomResourceDefinitionNamesFluent<A>>
extends BaseFluent<A> {
    private List<String> categories = new ArrayList<String>();
    private String kind;
    private String listKind;
    private String plural;
    private List<String> shortNames = new ArrayList<String>();
    private String singular;
    private Map<String, Object> additionalProperties;

    public CustomResourceDefinitionNamesFluent() {
    }

    public CustomResourceDefinitionNamesFluent(CustomResourceDefinitionNames instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CustomResourceDefinitionNames instance) {
        CustomResourceDefinitionNames customResourceDefinitionNames = instance = instance != null ? instance : new CustomResourceDefinitionNames();
        if (instance != null) {
            this.withCategories(instance.getCategories());
            this.withKind(instance.getKind());
            this.withListKind(instance.getListKind());
            this.withPlural(instance.getPlural());
            this.withShortNames(instance.getShortNames());
            this.withSingular(instance.getSingular());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToCategories(int index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    public A setToCategories(int index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.set(index, item);
        return (A)this;
    }

    public A addToCategories(String ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A addAllToCategories(Collection<String> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A removeFromCategories(String ... items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (String item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCategories(Collection<String> items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (String item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getCategory(int index) {
        return this.categories.get(index);
    }

    public String getFirstCategory() {
        return this.categories.get(0);
    }

    public String getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCategories(List<String> categories) {
        if (categories != null) {
            this.categories = new ArrayList<String>();
            for (String item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    public A withCategories(String ... categories) {
        if (this.categories != null) {
            this.categories.clear();
            this._visitables.remove("categories");
        }
        if (categories != null) {
            for (String item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getListKind() {
        return this.listKind;
    }

    public A withListKind(String listKind) {
        this.listKind = listKind;
        return (A)this;
    }

    public boolean hasListKind() {
        return this.listKind != null;
    }

    public String getPlural() {
        return this.plural;
    }

    public A withPlural(String plural) {
        this.plural = plural;
        return (A)this;
    }

    public boolean hasPlural() {
        return this.plural != null;
    }

    public A addToShortNames(int index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(index, item);
        return (A)this;
    }

    public A setToShortNames(int index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.set(index, item);
        return (A)this;
    }

    public A addToShortNames(String ... items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    public A addAllToShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    public A removeFromShortNames(String ... items) {
        if (this.shortNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getShortNames() {
        return this.shortNames;
    }

    public String getShortName(int index) {
        return this.shortNames.get(index);
    }

    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    public String getLastShortName() {
        return this.shortNames.get(this.shortNames.size() - 1);
    }

    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withShortNames(List<String> shortNames) {
        if (shortNames != null) {
            this.shortNames = new ArrayList<String>();
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        } else {
            this.shortNames = null;
        }
        return (A)this;
    }

    public A withShortNames(String ... shortNames) {
        if (this.shortNames != null) {
            this.shortNames.clear();
            this._visitables.remove("shortNames");
        }
        if (shortNames != null) {
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasShortNames() {
        return this.shortNames != null && !this.shortNames.isEmpty();
    }

    public String getSingular() {
        return this.singular;
    }

    public A withSingular(String singular) {
        this.singular = singular;
        return (A)this;
    }

    public boolean hasSingular() {
        return this.singular != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceDefinitionNamesFluent that = (CustomResourceDefinitionNamesFluent)o;
        if (!Objects.equals(this.categories, that.categories)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.listKind, that.listKind)) {
            return false;
        }
        if (!Objects.equals(this.plural, that.plural)) {
            return false;
        }
        if (!Objects.equals(this.shortNames, that.shortNames)) {
            return false;
        }
        if (!Objects.equals(this.singular, that.singular)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.categories, this.kind, this.listKind, this.plural, this.shortNames, this.singular, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(this.categories + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.listKind != null) {
            sb.append("listKind:");
            sb.append(this.listKind + ",");
        }
        if (this.plural != null) {
            sb.append("plural:");
            sb.append(this.plural + ",");
        }
        if (this.shortNames != null && !this.shortNames.isEmpty()) {
            sb.append("shortNames:");
            sb.append(this.shortNames + ",");
        }
        if (this.singular != null) {
            sb.append("singular:");
            sb.append(this.singular + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

