/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.io.IOException;
import java.text.ParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize
@JsonSerialize(using=Serializer.class)
public class Duration
implements KubernetesResource {
    private static final long serialVersionUID = -2326157920610452294L;
    private static final String DURATION_REGEX = "(\\d+)\\s*([A-Za-z\u00b5]+)";
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)\\s*([A-Za-z\u00b5]+)");
    private java.time.Duration javaDuration;

    public Duration() {
    }

    public Duration(java.time.Duration javaDuration) {
        this.javaDuration = javaDuration;
    }

    public java.time.Duration getDuration() {
        return this.javaDuration;
    }

    public void setDuration(java.time.Duration javaDuration) {
        this.javaDuration = javaDuration;
    }

    public Long getValue() {
        return Optional.ofNullable(this.javaDuration).map(java.time.Duration::toNanos).orElse(0L);
    }

    public static boolean isDuration(String durationToTest) {
        try {
            Duration.parse(durationToTest);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static Duration parse(String duration) throws ParseException {
        java.time.Duration accumulator = java.time.Duration.ZERO;
        boolean found = false;
        Matcher matcher = Optional.ofNullable(duration).map(String::trim).map(DURATION_PATTERN::matcher).orElse(null);
        while (matcher != null && matcher.find()) {
            found = true;
            java.time.Duration durationToken = Optional.ofNullable(TimeUnits.from(matcher.group(2))).map(tu -> java.time.Duration.of(Long.parseLong(matcher.group(1)), ((TimeUnits)tu).timeUnit)).orElseThrow(() -> new ParseException(String.format("Invalid duration token (%s)", matcher.group()), 0));
            accumulator = accumulator.plus(durationToken);
        }
        if (!found) {
            throw new ParseException(String.format("Provided duration string (%s) is invalid", duration), 0);
        }
        return new Duration(accumulator);
    }

    public String toString() {
        return "Duration(javaDuration=" + this.javaDuration + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        java.time.Duration this$javaDuration = this.javaDuration;
        java.time.Duration other$javaDuration = other.javaDuration;
        return !(this$javaDuration == null ? other$javaDuration != null : !((Object)this$javaDuration).equals(other$javaDuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        java.time.Duration $javaDuration = this.javaDuration;
        result = result * 59 + ($javaDuration == null ? 43 : ((Object)$javaDuration).hashCode());
        return result;
    }

    private static class SevenDayWeek
    implements TemporalUnit {
        private static final SevenDayWeek INSTANCE = new SevenDayWeek();
        private static final java.time.Duration SEVEN_DAYS = java.time.Duration.ofDays(7L);

        private SevenDayWeek() {
        }

        @Override
        public java.time.Duration getDuration() {
            return SEVEN_DAYS;
        }

        @Override
        public boolean isDurationEstimated() {
            return false;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long amount) {
            return (R)temporal.plus(amount, this);
        }

        @Override
        public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
            return temporal1Inclusive.until(temporal2Exclusive, this);
        }

        static /* synthetic */ SevenDayWeek access$000() {
            return INSTANCE;
        }
    }

    private static enum TimeUnits {
        NANOSECOND(ChronoUnit.NANOS, "ns", "nano", "nanos"),
        MICROSECOND(ChronoUnit.MICROS, "us", "\u00b5s", "micro", "micros"),
        MILLISECOND(ChronoUnit.MILLIS, "ms", "milli", "millis"),
        SECOND(ChronoUnit.SECONDS, "s", "sec", "secs"),
        MINUTE(ChronoUnit.MINUTES, "m", "min", "mins"),
        HOUR(ChronoUnit.HOURS, "h", "hr", "hour", "hours"),
        DAY(ChronoUnit.DAYS, "d", "day", "days"),
        WEEK(SevenDayWeek.access$000(), "w", "wk", "week", "weeks");

        private final Set<String> abbreviations;
        private final TemporalUnit timeUnit;

        private TimeUnits(TemporalUnit timeUnit, String ... abbreviations) {
            this.timeUnit = timeUnit;
            this.abbreviations = new HashSet<String>(Arrays.asList(abbreviations));
        }

        static TimeUnits from(String abbreviation) {
            return Stream.of(TimeUnits.values()).filter(tu -> tu.abbreviations.contains(abbreviation.toLowerCase())).findAny().orElse(null);
        }
    }

    public static class Serializer
    extends StdSerializer<Duration> {
        public Serializer() {
            super(Duration.class);
        }

        @Override
        public void serialize(Duration duration, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(String.format("%sns", duration.getValue()));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            visitor.expectStringFormat(typeHint);
        }
    }
}

