/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Visitor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitorListener;

public final class VisitorWiretap<T>
implements Visitor<T> {
    private final Collection<VisitorListener> listeners;
    private final Visitor<T> delegate;

    private VisitorWiretap(Visitor<T> delegate, Collection<VisitorListener> listeners) {
        this.delegate = delegate;
        this.listeners = listeners;
    }

    public static <T> VisitorWiretap<T> create(Visitor<T> visitor, Collection<VisitorListener> listeners) {
        if (visitor instanceof VisitorWiretap) {
            return (VisitorWiretap)visitor;
        }
        return new VisitorWiretap<T>(visitor, listeners);
    }

    @Override
    public Class<T> getType() {
        return this.delegate.getType();
    }

    @Override
    public void visit(T target) {
        for (VisitorListener l : this.listeners) {
            l.beforeVisit(this.delegate, Collections.emptyList(), target);
        }
        this.delegate.visit(target);
        for (VisitorListener l : this.listeners) {
            l.afterVisit(this.delegate, Collections.emptyList(), target);
        }
    }

    @Override
    public int order() {
        return this.delegate.order();
    }

    @Override
    public void visit(List<Map.Entry<String, Object>> path, T target) {
        for (VisitorListener l : this.listeners) {
            l.beforeVisit(this.delegate, path, target);
        }
        this.delegate.visit(path, target);
        for (VisitorListener l : this.listeners) {
            l.afterVisit(this.delegate, path, target);
        }
    }

    @Override
    public <F> Boolean canVisit(List<Map.Entry<String, Object>> path, F target) {
        boolean canVisit = this.delegate.canVisit(path, target);
        for (VisitorListener l : this.listeners) {
            l.onCheck(this.delegate, canVisit, target);
        }
        return canVisit;
    }
}

