/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.util.Preconditions;

public class ExternalServiceDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public ExternalServiceDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        Service service = this.kubernetesJobManagerParameters.getRestServiceExposedType().serviceType().buildUpExternalRestService(this.kubernetesJobManagerParameters);
        return Collections.singletonList(service);
    }

    public static String getExternalServiceName(String clusterId) {
        return clusterId + "-rest";
    }

    public static String getNamespacedExternalServiceName(String clusterId, String namespace) {
        return ExternalServiceDecorator.getExternalServiceName(clusterId) + "." + namespace;
    }
}

