/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.concurrent.Executor;
import org.apache.flink.kubernetes.configuration.KubernetesLeaderElectionConfiguration;
import org.apache.flink.kubernetes.highavailability.KubernetesLeaderElectionDriver;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.util.Preconditions;

public class KubernetesLeaderElectionDriverFactory
implements LeaderElectionDriverFactory {
    private final FlinkKubeClient kubeClient;
    private final KubernetesLeaderElectionConfiguration kubernetesLeaderElectionConfiguration;
    private final KubernetesConfigMapSharedWatcher configMapSharedWatcher;
    private final Executor watchExecutor;

    public KubernetesLeaderElectionDriverFactory(FlinkKubeClient kubeClient, KubernetesLeaderElectionConfiguration kubernetesLeaderElectionConfiguration, KubernetesConfigMapSharedWatcher configMapSharedWatcher, Executor watchExecutor) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.kubernetesLeaderElectionConfiguration = (KubernetesLeaderElectionConfiguration)Preconditions.checkNotNull((Object)kubernetesLeaderElectionConfiguration);
        this.configMapSharedWatcher = (KubernetesConfigMapSharedWatcher)Preconditions.checkNotNull((Object)configMapSharedWatcher);
        this.watchExecutor = (Executor)Preconditions.checkNotNull((Object)watchExecutor);
    }

    public KubernetesLeaderElectionDriver create(LeaderElectionDriver.Listener leaderElectionListener) throws Exception {
        return new KubernetesLeaderElectionDriver(this.kubernetesLeaderElectionConfiguration, this.kubeClient, leaderElectionListener, this.configMapSharedWatcher, this.watchExecutor);
    }
}

