/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import org.apache.flink.core.fs.FileSystemBehaviorTestSuite;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.util.VersionInfo;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.io.TempDir;

class HadoopLocalFileSystemBehaviorTest
extends FileSystemBehaviorTestSuite {
    @TempDir
    private java.nio.file.Path tmp;

    HadoopLocalFileSystemBehaviorTest() {
    }

    protected org.apache.flink.core.fs.FileSystem getFileSystem() throws Exception {
        RawLocalFileSystem fs = new RawLocalFileSystem();
        fs.initialize(LocalFileSystem.getLocalFsURI(), new Configuration());
        return new HadoopFileSystem((FileSystem)fs);
    }

    protected Path getBasePath() throws Exception {
        return new Path(this.tmp.toUri());
    }

    protected FileSystemKind getFileSystemKind() {
        return FileSystemKind.FILE_SYSTEM;
    }

    protected void testMkdirsFailsForExistingFile() throws Exception {
        String versionString = VersionInfo.getVersion();
        String prefix = versionString.substring(0, 3);
        float version = Float.parseFloat(prefix);
        ((AbstractFloatAssert)Assumptions.assumeThat((float)version).describedAs("Cannot execute this test on Hadoop prior to 2.8", new Object[0])).isGreaterThanOrEqualTo(2.8f);
        super.testMkdirsFailsForExistingFile();
    }
}

