/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.join.WindowJoin;
import org.apache.flink.streaming.examples.windowing.SessionWindowing;
import org.apache.flink.streaming.examples.windowing.WindowWordCount;
import org.apache.flink.streaming.examples.wordcount.WordCount;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StreamingExamplesITCase
extends AbstractTestBaseJUnit4 {
    @Parameterized.Parameter
    public boolean asyncState;

    @Parameterized.Parameters
    public static Collection<Boolean> setup() {
        return Arrays.asList(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWindowJoin() throws Exception {
        String resultPath = Files.createTempDirectory("result-path", new FileAttribute[0]).toUri().toString();
        try {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            final class Parser
            implements MapFunction<String, Tuple2<String, Integer>> {
                Parser() {
                }

                public Tuple2<String, Integer> map(String value) throws Exception {
                    String[] fields = value.split(",");
                    return new Tuple2((Object)fields[1], (Object)Integer.parseInt(fields[2]));
                }
            }
            SingleOutputStreamOperator grades = env.fromData((Object[])"0,john,5\n0,tom,3\n0,alice,1\n0,grace,5\n1,john,4\n1,bob,1\n1,alice,2\n1,alice,3\n1,bob,5\n1,alice,3\n1,tom,5\n2,john,2\n2,john,1\n2,grace,2\n2,jerry,2\n2,tom,4\n2,bob,4\n2,bob,2\n3, tom,2\n3,alice,5\n3,grace,5\n3,grace,1\n3,alice,1\n3,grace,3\n3,tom,1\n4,jerry,5\n4,john,3\n4,john,4\n4,john,1\n4,jerry,3\n4,grace,3\n4,bob,3\n5,john,3\n5,jerry,4\n5,tom,5\n5,tom,4\n5,john,2\n5,jerry,1\n5,bob,1\n6,john,5\n6,grace,4\n6,tom,5\n6,john,4\n6,tom,1\n6,grace,1\n6,john,2\n7,jerry,3\n7,jerry,5\n7,tom,2\n7,tom,2\n7,alice,4\n7,tom,4\n7,jerry,4\n8,john,3\n8,grace,4\n8,tom,3\n8,jerry,4\n8,john,5\n8,john,4\n8,jerry,1\n9,john,5\n9,alice,2\n9,tom,1\n9,alice,5\n9,grace,4\n9,bob,4\n9,jerry,1\n10,john,5\n10,tom,4\n10,tom,5\n10,jerry,5\n10,tom,1\n10,grace,3\n10,bob,5\n11,john,1\n11,alice,1\n11,grace,3\n11,grace,1\n11,jerry,1\n11,jerry,4\n12,bob,4\n12,alice,3\n12,tom,5\n12,alice,4\n12,alice,4\n12,grace,4\n12,john,5\n13,john,5\n13,grace,4\n13,tom,4\n13,john,4\n13,john,5\n13,alice,5\n13,jerry,5\n14,john,3\n14,tom,5\n14,jerry,4\n14,grace,4\n14,john,3\n14,bob,2".split("\n")).assignTimestampsAndWatermarks(IngestionTimeWatermarkStrategy.create()).map((MapFunction)new Parser());
            SingleOutputStreamOperator salaries = env.fromData((Object[])"0,john,6469\n0,jerry,6760\n0,jerry,8069\n1,tom,3662\n1,grace,8427\n1,john,9425\n1,bob,9018\n1,john,352\n1,tom,3770\n2,grace,7622\n2,jerry,7441\n2,alice,1468\n2,bob,5472\n2,grace,898\n3,tom,3849\n3,grace,1865\n3,alice,5582\n3,john,9511\n3,alice,1541\n4,john,2477\n4,grace,3561\n4,john,1670\n4,grace,7290\n4,grace,6565\n5,tom,6179\n5,tom,1601\n5,john,2940\n5,bob,4685\n5,bob,710\n5,bob,5936\n6,jerry,1412\n6,grace,6515\n6,grace,3321\n6,tom,8088\n6,john,2876\n7,bob,9896\n7,grace,7368\n7,grace,9749\n7,bob,2048\n7,alice,4782\n8,alice,3375\n8,tom,5841\n8,bob,958\n8,bob,5258\n8,tom,3935\n8,jerry,4394\n9,alice,102\n9,alice,4931\n9,alice,5240\n9,jerry,7951\n9,john,5675\n10,bob,609\n10,alice,5997\n10,jerry,9651\n10,alice,1328\n10,bob,1022\n11,grace,2578\n11,jerry,9704\n11,tom,4476\n11,grace,3784\n11,alice,6144\n12,bob,6213\n12,alice,7525\n12,jerry,2908\n12,grace,8464\n12,jerry,9920\n13,bob,3720\n13,bob,7612\n13,alice,7211\n13,jerry,6484\n13,alice,1711\n14,jerry,5994\n14,grace,928\n14,jerry,2492\n14,grace,9080\n14,tom,4330\n15,bob,8302\n15,john,4981\n15,tom,1781\n15,grace,1379\n15,jerry,3700\n16,jerry,3584\n16,jerry,2038\n16,jerry,3902\n16,tom,1336\n16,jerry,7500\n17,tom,3648\n17,alice,2533\n17,tom,8685\n17,bob,3968\n17,tom,3241\n17,bob,7461\n18,jerry,2138\n18,alice,7503\n18,alice,6424\n18,tom,140\n18,john,9802\n19,grace,2977\n19,grace,889\n19,john,1338".split("\n")).assignTimestampsAndWatermarks(IngestionTimeWatermarkStrategy.create()).map((MapFunction)new Parser());
            WindowJoin.runWindowJoin((DataStream)grades, (DataStream)salaries, (long)100L).sinkTo((Sink)FileSink.forRowFormat((Path)new Path(resultPath), (Encoder)new SimpleStringEncoder()).build());
            env.execute();
            TestBaseUtils.checkLinesAgainstRegexp((String)resultPath, (String)"^\\([a-z]+,(\\d),(\\d)+\\)");
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)new File(resultPath));
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void testSessionWindowing() throws Exception {
        String resultPath = this.getTempDirPath("result");
        SessionWindowing.main((String[])new String[]{"--output", resultPath});
    }

    @Test
    public void testWindowWordCount() throws Exception {
        String windowSize = "25";
        String slideSize = "15";
        String textPath = this.createTempFile("text.txt", "Goethe - Faust: Der Tragoedie erster Teil\nProlog im Himmel.\nDer Herr. Die himmlischen Heerscharen. Nachher Mephistopheles. Die drei\nErzengel treten vor.\nRAPHAEL: Die Sonne toent, nach alter Weise, In Brudersphaeren Wettgesang,\nUnd ihre vorgeschriebne Reise Vollendet sie mit Donnergang. Ihr Anblick\ngibt den Engeln Staerke, Wenn keiner Sie ergruenden mag; die unbegreiflich\nhohen Werke Sind herrlich wie am ersten Tag.\nGABRIEL: Und schnell und unbegreiflich schnelle Dreht sich umher der Erde\nPracht; Es wechselt Paradieseshelle Mit tiefer, schauervoller Nacht. Es\nschaeumt das Meer in breiten Fluessen Am tiefen Grund der Felsen auf, Und\nFels und Meer wird fortgerissen Im ewig schnellem Sphaerenlauf.\nMICHAEL: Und Stuerme brausen um die Wette Vom Meer aufs Land, vom Land\naufs Meer, und bilden wuetend eine Kette Der tiefsten Wirkung rings umher.\nDa flammt ein blitzendes Verheeren Dem Pfade vor des Donnerschlags. Doch\ndeine Boten, Herr, verehren Das sanfte Wandeln deines Tags.\nZU DREI: Der Anblick gibt den Engeln Staerke, Da keiner dich ergruenden\nmag, Und alle deine hohen Werke Sind herrlich wie am ersten Tag.\nMEPHISTOPHELES: Da du, o Herr, dich einmal wieder nahst Und fragst, wie\nalles sich bei uns befinde, Und du mich sonst gewoehnlich gerne sahst, So\nsiehst du mich auch unter dem Gesinde. Verzeih, ich kann nicht hohe Worte\nmachen, Und wenn mich auch der ganze Kreis verhoehnt; Mein Pathos braechte\ndich gewiss zum Lachen, Haettst du dir nicht das Lachen abgewoehnt. Von\nSonn' und Welten weiss ich nichts zu sagen, Ich sehe nur, wie sich die\nMenschen plagen. Der kleine Gott der Welt bleibt stets von gleichem\nSchlag, Und ist so wunderlich als wie am ersten Tag. Ein wenig besser\nwuerd er leben, Haettst du ihm nicht den Schein des Himmelslichts gegeben;\nEr nennt's Vernunft und braucht's allein, Nur tierischer als jedes Tier\nzu sein. Er scheint mir, mit Verlaub von euer Gnaden, Wie eine der\nlangbeinigen Zikaden, Die immer fliegt und fliegend springt Und gleich im\nGras ihr altes Liedchen singt; Und laeg er nur noch immer in dem Grase! In\njeden Quark begraebt er seine Nase.\nDER HERR: Hast du mir weiter nichts zu sagen? Kommst du nur immer\nanzuklagen? Ist auf der Erde ewig dir nichts recht?\nMEPHISTOPHELES: Nein Herr! ich find es dort, wie immer, herzlich\nschlecht. Die Menschen dauern mich in ihren Jammertagen, Ich mag sogar\ndie armen selbst nicht plagen.\nDER HERR: Kennst du den Faust?\nMEPHISTOPHELES: Den Doktor?\nDER HERR: Meinen Knecht!\nMEPHISTOPHELES: Fuerwahr! er dient Euch auf besondre Weise. Nicht irdisch\nist des Toren Trank noch Speise. Ihn treibt die Gaerung in die Ferne, Er\nist sich seiner Tollheit halb bewusst; Vom Himmel fordert er die schoensten\nSterne Und von der Erde jede hoechste Lust, Und alle Naeh und alle Ferne\nBefriedigt nicht die tiefbewegte Brust.\nDER HERR: Wenn er mir auch nur verworren dient, So werd ich ihn bald in\ndie Klarheit fuehren. Weiss doch der Gaertner, wenn das Baeumchen gruent, Das\nBluet und Frucht die kuenft'gen Jahre zieren.\nMEPHISTOPHELES: Was wettet Ihr? den sollt Ihr noch verlieren! Wenn Ihr\nmir die Erlaubnis gebt, Ihn meine Strasse sacht zu fuehren.\nDER HERR: Solang er auf der Erde lebt, So lange sei dir's nicht verboten,\nEs irrt der Mensch so lang er strebt.\nMEPHISTOPHELES: Da dank ich Euch; denn mit den Toten Hab ich mich niemals\ngern befangen. Am meisten lieb ich mir die vollen, frischen Wangen. Fuer\neinem Leichnam bin ich nicht zu Haus; Mir geht es wie der Katze mit der Maus.\nDER HERR: Nun gut, es sei dir ueberlassen! Zieh diesen Geist von seinem\nUrquell ab, Und fuehr ihn, kannst du ihn erfassen, Auf deinem Wege mit\nherab, Und steh beschaemt, wenn du bekennen musst: Ein guter Mensch, in\nseinem dunklen Drange, Ist sich des rechten Weges wohl bewusst.\nMEPHISTOPHELES: Schon gut! nur dauert es nicht lange. Mir ist fuer meine\nWette gar nicht bange. Wenn ich zu meinem Zweck gelange, Erlaubt Ihr mir\nTriumph aus voller Brust. Staub soll er fressen, und mit Lust, Wie meine\nMuhme, die beruehmte Schlange.\nDER HERR: Du darfst auch da nur frei erscheinen; Ich habe deinesgleichen\nnie gehasst. Von allen Geistern, die verneinen, ist mir der Schalk am\nwenigsten zur Last. Des Menschen Taetigkeit kann allzu leicht erschlaffen,\ner liebt sich bald die unbedingte Ruh; Drum geb ich gern ihm den Gesellen\nzu, Der reizt und wirkt und muss als Teufel schaffen. Doch ihr, die echten\nGoettersoehne, Erfreut euch der lebendig reichen Schoene! Das Werdende, das\newig wirkt und lebt, Umfass euch mit der Liebe holden Schranken, Und was\nin schwankender Erscheinung schwebt, Befestigt mit dauernden Gedanken!\n(Der Himmel schliesst, die Erzengel verteilen sich.)\nMEPHISTOPHELES (allein): Von Zeit zu Zeit seh ich den Alten gern, Und\nhuete mich, mit ihm zu brechen. Es ist gar huebsch von einem grossen Herrn,\nSo menschlich mit dem Teufel selbst zu sprechen.");
        String resultPath = this.getTempDirPath("result");
        if (this.asyncState) {
            WindowWordCount.main((String[])new String[]{"--input", textPath, "--output", resultPath, "--window", "25", "--slide", "15", "--async-state"});
        } else {
            WindowWordCount.main((String[])new String[]{"--input", textPath, "--output", resultPath, "--window", "25", "--slide", "15"});
        }
        TestBaseUtils.checkLinesAgainstRegexp((String)resultPath, (String)"^\\([a-z]+,(\\d)+\\)");
    }

    @Test
    public void testWordCount() throws Exception {
        String textPath = this.createTempFile("text.txt", "Goethe - Faust: Der Tragoedie erster Teil\nProlog im Himmel.\nDer Herr. Die himmlischen Heerscharen. Nachher Mephistopheles. Die drei\nErzengel treten vor.\nRAPHAEL: Die Sonne toent, nach alter Weise, In Brudersphaeren Wettgesang,\nUnd ihre vorgeschriebne Reise Vollendet sie mit Donnergang. Ihr Anblick\ngibt den Engeln Staerke, Wenn keiner Sie ergruenden mag; die unbegreiflich\nhohen Werke Sind herrlich wie am ersten Tag.\nGABRIEL: Und schnell und unbegreiflich schnelle Dreht sich umher der Erde\nPracht; Es wechselt Paradieseshelle Mit tiefer, schauervoller Nacht. Es\nschaeumt das Meer in breiten Fluessen Am tiefen Grund der Felsen auf, Und\nFels und Meer wird fortgerissen Im ewig schnellem Sphaerenlauf.\nMICHAEL: Und Stuerme brausen um die Wette Vom Meer aufs Land, vom Land\naufs Meer, und bilden wuetend eine Kette Der tiefsten Wirkung rings umher.\nDa flammt ein blitzendes Verheeren Dem Pfade vor des Donnerschlags. Doch\ndeine Boten, Herr, verehren Das sanfte Wandeln deines Tags.\nZU DREI: Der Anblick gibt den Engeln Staerke, Da keiner dich ergruenden\nmag, Und alle deine hohen Werke Sind herrlich wie am ersten Tag.\nMEPHISTOPHELES: Da du, o Herr, dich einmal wieder nahst Und fragst, wie\nalles sich bei uns befinde, Und du mich sonst gewoehnlich gerne sahst, So\nsiehst du mich auch unter dem Gesinde. Verzeih, ich kann nicht hohe Worte\nmachen, Und wenn mich auch der ganze Kreis verhoehnt; Mein Pathos braechte\ndich gewiss zum Lachen, Haettst du dir nicht das Lachen abgewoehnt. Von\nSonn' und Welten weiss ich nichts zu sagen, Ich sehe nur, wie sich die\nMenschen plagen. Der kleine Gott der Welt bleibt stets von gleichem\nSchlag, Und ist so wunderlich als wie am ersten Tag. Ein wenig besser\nwuerd er leben, Haettst du ihm nicht den Schein des Himmelslichts gegeben;\nEr nennt's Vernunft und braucht's allein, Nur tierischer als jedes Tier\nzu sein. Er scheint mir, mit Verlaub von euer Gnaden, Wie eine der\nlangbeinigen Zikaden, Die immer fliegt und fliegend springt Und gleich im\nGras ihr altes Liedchen singt; Und laeg er nur noch immer in dem Grase! In\njeden Quark begraebt er seine Nase.\nDER HERR: Hast du mir weiter nichts zu sagen? Kommst du nur immer\nanzuklagen? Ist auf der Erde ewig dir nichts recht?\nMEPHISTOPHELES: Nein Herr! ich find es dort, wie immer, herzlich\nschlecht. Die Menschen dauern mich in ihren Jammertagen, Ich mag sogar\ndie armen selbst nicht plagen.\nDER HERR: Kennst du den Faust?\nMEPHISTOPHELES: Den Doktor?\nDER HERR: Meinen Knecht!\nMEPHISTOPHELES: Fuerwahr! er dient Euch auf besondre Weise. Nicht irdisch\nist des Toren Trank noch Speise. Ihn treibt die Gaerung in die Ferne, Er\nist sich seiner Tollheit halb bewusst; Vom Himmel fordert er die schoensten\nSterne Und von der Erde jede hoechste Lust, Und alle Naeh und alle Ferne\nBefriedigt nicht die tiefbewegte Brust.\nDER HERR: Wenn er mir auch nur verworren dient, So werd ich ihn bald in\ndie Klarheit fuehren. Weiss doch der Gaertner, wenn das Baeumchen gruent, Das\nBluet und Frucht die kuenft'gen Jahre zieren.\nMEPHISTOPHELES: Was wettet Ihr? den sollt Ihr noch verlieren! Wenn Ihr\nmir die Erlaubnis gebt, Ihn meine Strasse sacht zu fuehren.\nDER HERR: Solang er auf der Erde lebt, So lange sei dir's nicht verboten,\nEs irrt der Mensch so lang er strebt.\nMEPHISTOPHELES: Da dank ich Euch; denn mit den Toten Hab ich mich niemals\ngern befangen. Am meisten lieb ich mir die vollen, frischen Wangen. Fuer\neinem Leichnam bin ich nicht zu Haus; Mir geht es wie der Katze mit der Maus.\nDER HERR: Nun gut, es sei dir ueberlassen! Zieh diesen Geist von seinem\nUrquell ab, Und fuehr ihn, kannst du ihn erfassen, Auf deinem Wege mit\nherab, Und steh beschaemt, wenn du bekennen musst: Ein guter Mensch, in\nseinem dunklen Drange, Ist sich des rechten Weges wohl bewusst.\nMEPHISTOPHELES: Schon gut! nur dauert es nicht lange. Mir ist fuer meine\nWette gar nicht bange. Wenn ich zu meinem Zweck gelange, Erlaubt Ihr mir\nTriumph aus voller Brust. Staub soll er fressen, und mit Lust, Wie meine\nMuhme, die beruehmte Schlange.\nDER HERR: Du darfst auch da nur frei erscheinen; Ich habe deinesgleichen\nnie gehasst. Von allen Geistern, die verneinen, ist mir der Schalk am\nwenigsten zur Last. Des Menschen Taetigkeit kann allzu leicht erschlaffen,\ner liebt sich bald die unbedingte Ruh; Drum geb ich gern ihm den Gesellen\nzu, Der reizt und wirkt und muss als Teufel schaffen. Doch ihr, die echten\nGoettersoehne, Erfreut euch der lebendig reichen Schoene! Das Werdende, das\newig wirkt und lebt, Umfass euch mit der Liebe holden Schranken, Und was\nin schwankender Erscheinung schwebt, Befestigt mit dauernden Gedanken!\n(Der Himmel schliesst, die Erzengel verteilen sich.)\nMEPHISTOPHELES (allein): Von Zeit zu Zeit seh ich den Alten gern, Und\nhuete mich, mit ihm zu brechen. Es ist gar huebsch von einem grossen Herrn,\nSo menschlich mit dem Teufel selbst zu sprechen.");
        String resultPath = this.getTempDirPath("result");
        if (this.asyncState) {
            WordCount.main((String[])new String[]{"--input", textPath, "--output", resultPath, "--execution-mode", "automatic", "--async-state"});
        } else {
            WordCount.main((String[])new String[]{"--input", textPath, "--output", resultPath, "--execution-mode", "automatic"});
        }
        TestBaseUtils.compareResultsByLinesInMemory((String)"(machen,1)\n(zeit,2)\n(heerscharen,1)\n(keiner,2)\n(meine,3)\n(fuehr,1)\n(triumph,1)\n(kommst,1)\n(frei,1)\n(schaffen,1)\n(gesinde,1)\n(langbeinigen,1)\n(schalk,1)\n(besser,1)\n(solang,1)\n(meer,4)\n(fragst,1)\n(gabriel,1)\n(selbst,2)\n(bin,1)\n(sich,7)\n(du,11)\n(sogar,1)\n(geht,1)\n(immer,4)\n(mensch,2)\n(befestigt,1)\n(lebt,2)\n(mag,3)\n(engeln,2)\n(breiten,1)\n(blitzendes,1)\n(tags,1)\n(sie,2)\n(plagen,2)\n(allzu,1)\n(meisten,1)\n(o,1)\n(pfade,1)\n(kennst,1)\n(nichts,3)\n(gedanken,1)\n(befriedigt,1)\n(mich,6)\n(s,3)\n(es,8)\n(verneinen,1)\n(er,13)\n(gleich,1)\n(baeumchen,1)\n(donnergang,1)\n(wunderlich,1)\n(reise,1)\n(urquell,1)\n(doch,3)\n(aufs,2)\n(toten,1)\n(niemals,1)\n(eine,2)\n(hab,1)\n(darfst,1)\n(da,5)\n(gen,1)\n(einem,2)\n(teil,1)\n(das,7)\n(speise,1)\n(wenig,1)\n(sterne,1)\n(geb,1)\n(welten,1)\n(alle,3)\n(toent,1)\n(gras,1)\n(felsen,1)\n(kette,1)\n(ich,14)\n(fuer,2)\n(als,3)\n(mein,1)\n(schoene,1)\n(verzeih,1)\n(schwankender,1)\n(wie,9)\n(menschlich,1)\n(gaertner,1)\n(taetigkeit,1)\n(bange,1)\n(liebe,1)\n(sei,2)\n(seh,1)\n(tollheit,1)\n(am,6)\n(michael,1)\n(geist,1)\n(ab,1)\n(nahst,1)\n(vollendet,1)\n(liebt,1)\n(brausen,1)\n(nase,1)\n(erlaubt,1)\n(weiss,2)\n(schnellem,1)\n(deinem,1)\n(gleichem,1)\n(gaerung,1)\n(dauernden,1)\n(deines,1)\n(vorgeschriebne,1)\n(irdisch,1)\n(worte,1)\n(verehren,1)\n(hohen,2)\n(weise,2)\n(kuenft,1)\n(werdende,1)\n(wette,2)\n(wuetend,1)\n(erscheinung,1)\n(gar,2)\n(verlieren,1)\n(braucht,1)\n(weiter,1)\n(trank,1)\n(tierischer,1)\n(wohl,1)\n(verteilen,1)\n(verhoehnt,1)\n(schaeumt,1)\n(himmelslichts,1)\n(unbedingte,1)\n(herzlich,1)\n(anblick,2)\n(nennt,1)\n(gruent,1)\n(bluet,1)\n(leichnam,1)\n(erschlaffen,1)\n(jammertagen,1)\n(zieh,1)\n(ihm,3)\n(besondre,1)\n(ihn,5)\n(grossen,1)\n(vollen,1)\n(ihr,7)\n(boten,1)\n(voller,1)\n(singt,1)\n(muhme,1)\n(schon,1)\n(last,1)\n(kleine,1)\n(paradieseshelle,1)\n(nein,1)\n(echten,1)\n(unter,1)\n(bei,1)\n(herr,11)\n(gern,3)\n(sphaerenlauf,1)\n(stets,1)\n(ganze,1)\n(braechte,1)\n(fordert,1)\n(schoensten,1)\n(herrlich,2)\n(gegeben,1)\n(allein,2)\n(reichen,1)\n(schauervoller,1)\n(musst,1)\n(recht,1)\n(bleibt,1)\n(pracht,1)\n(treibt,1)\n(befangen,1)\n(was,2)\n(menschen,3)\n(jede,1)\n(hohe,1)\n(tiefsten,1)\n(bilden,1)\n(drum,1)\n(gibt,2)\n(guter,1)\n(fuerwahr,1)\n(im,3)\n(grund,1)\n(in,9)\n(hoechste,1)\n(schliesst,1)\n(fels,1)\n(steh,1)\n(euer,1)\n(erster,1)\n(ersten,3)\n(goettersoehne,1)\n(brechen,1)\n(tiefen,1)\n(frucht,1)\n(kreis,1)\n(siehst,1)\n(wege,1)\n(ist,8)\n(zikaden,1)\n(frischen,1)\n(ruh,1)\n(deine,2)\n(maus,1)\n(brudersphaeren,1)\n(nachher,1)\n(euch,4)\n(gnaden,1)\n(anzuklagen,1)\n(schlange,1)\n(staerke,2)\n(erde,4)\n(verlaub,1)\n(sanfte,1)\n(holden,1)\n(sonst,1)\n(treten,1)\n(sahst,1)\n(alten,1)\n(um,1)\n(wieder,1)\n(alter,1)\n(altes,1)\n(nun,1)\n(lieb,1)\n(gesellen,1)\n(erscheinen,1)\n(wirkt,2)\n(haettst,2)\n(nur,7)\n(tiefbewegte,1)\n(lachen,2)\n(drange,1)\n(schlag,1)\n(schein,1)\n(muss,1)\n(verworren,1)\n(weges,1)\n(allen,1)\n(gewoehnlich,1)\n(alles,1)\n(halb,1)\n(stuerme,1)\n(springt,1)\n(sollt,1)\n(klarheit,1)\n(so,6)\n(erfassen,1)\n(liedchen,1)\n(prolog,1)\n(zur,1)\n(fressen,1)\n(zum,1)\n(faust,2)\n(erzengel,2)\n(jahre,1)\n(sonn,1)\n(raphael,1)\n(land,2)\n(lang,1)\n(gelange,1)\n(lust,2)\n(welt,1)\n(sehe,1)\n(ihre,1)\n(jedes,1)\n(erfreut,1)\n(seiner,1)\n(denn,1)\n(wandeln,1)\n(wechselt,1)\n(jeden,1)\n(dort,1)\n(schlecht,1)\n(wenigsten,1)\n(wuerd,1)\n(schranken,1)\n(bewusst,2)\n(seinem,2)\n(gehasst,1)\n(sein,1)\n(meinem,1)\n(meinen,1)\n(pathos,1)\n(herrn,1)\n(lange,2)\n(herab,1)\n(diesen,1)\n(ihren,1)\n(beruehmte,1)\n(goethe,1)\n(tag,3)\n(tier,1)\n(quark,1)\n(dank,1)\n(seine,1)\n(teufel,2)\n(zweck,1)\n(wenn,7)\n(soll,1)\n(wirkung,1)\n(erlaubnis,1)\n(lebendig,1)\n(uns,1)\n(leicht,1)\n(gewiss,1)\n(schnell,1)\n(und,29)\n(gerne,1)\n(rechten,1)\n(umher,2)\n(vernunft,1)\n(grase,1)\n(nach,1)\n(leben,1)\n(gott,1)\n(der,29)\n(des,5)\n(doktor,1)\n(beschaemt,1)\n(dreht,1)\n(habe,1)\n(sagen,2)\n(bekennen,1)\n(dunklen,1)\n(wettet,1)\n(den,9)\n(mephistopheles,9)\n(dem,4)\n(auch,4)\n(kann,2)\n(armen,1)\n(mir,9)\n(strebt,1)\n(gut,2)\n(mit,11)\n(bald,2)\n(himmlischen,1)\n(himmel,3)\n(noch,3)\n(kannst,1)\n(deinesgleichen,1)\n(flammt,1)\n(ergruenden,2)\n(nacht,1)\n(scheint,1)\n(ferne,2)\n(tragoedie,1)\n(abgewoehnt,1)\n(reizt,1)\n(geistern,1)\n(nicht,10)\n(sacht,1)\n(unbegreiflich,2)\n(schnelle,1)\n(einmal,1)\n(werd,1)\n(werke,2)\n(begraebt,1)\n(knecht,1)\n(rings,1)\n(wird,1)\n(katze,1)\n(huete,1)\n(fortgerissen,1)\n(gebt,1)\n(huebsch,1)\n(hast,1)\n(irrt,1)\n(befinde,1)\n(sind,2)\n(fuehren,2)\n(fliegt,1)\n(ewig,3)\n(brust,2)\n(sonne,1)\n(sprechen,1)\n(ein,3)\n(strasse,1)\n(von,8)\n(ueberlassen,1)\n(dir,4)\n(vom,3)\n(zu,11)\n(schwebt,1)\n(die,22)\n(vor,2)\n(wangen,1)\n(wettgesang,1)\n(donnerschlags,1)\n(find,1)\n(dich,3)\n(umfass,1)\n(verboten,1)\n(laeg,1)\n(nie,1)\n(drei,2)\n(dauern,1)\n(toren,1)\n(dauert,1)\n(verheeren,1)\n(fliegend,1)\n(aus,1)\n(staub,1)\n(fluessen,1)\n(haus,1)\n(auf,5)\n(dient,2)\n(tiefer,1)\n(naeh,1)\n(zieren,1)\n", (String)resultPath);
    }

    private static class IngestionTimeWatermarkStrategy<T>
    implements WatermarkStrategy<T> {
        private IngestionTimeWatermarkStrategy() {
        }

        public static <T> IngestionTimeWatermarkStrategy<T> create() {
            return new IngestionTimeWatermarkStrategy<T>();
        }

        public WatermarkGenerator<T> createWatermarkGenerator(WatermarkGeneratorSupplier.Context context) {
            return new AscendingTimestampsWatermarks();
        }

        public TimestampAssigner<T> createTimestampAssigner(TimestampAssignerSupplier.Context context) {
            return (event, timestamp) -> System.currentTimeMillis();
        }
    }
}

