/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.common.KeyCheckedOutputCollector;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultTwoOutputNonPartitionedContext;
import org.apache.flink.datastream.impl.operators.TwoOutputProcessOperator;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class BaseKeyedTwoOutputProcessOperator<KEY, IN, OUT_MAIN, OUT_SIDE>
extends TwoOutputProcessOperator<IN, OUT_MAIN, OUT_SIDE> {
    protected transient Set<Object> keySet;
    @Nullable
    protected final KeySelector<OUT_MAIN, KEY> mainOutKeySelector;
    @Nullable
    protected final KeySelector<OUT_SIDE, KEY> sideOutKeySelector;

    public BaseKeyedTwoOutputProcessOperator(TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE> userFunction, OutputTag<OUT_SIDE> outputTag, @Nullable KeySelector<OUT_MAIN, KEY> mainOutKeySelector, @Nullable KeySelector<OUT_SIDE, KEY> sideOutKeySelector) {
        super(userFunction, outputTag);
        Preconditions.checkArgument((mainOutKeySelector == null && sideOutKeySelector == null || mainOutKeySelector != null && sideOutKeySelector != null ? 1 : 0) != 0, (Object)"Both mainOutKeySelector and sideOutKeySelector must be null or not null.");
        this.mainOutKeySelector = mainOutKeySelector;
        this.sideOutKeySelector = sideOutKeySelector;
    }

    @Override
    public void open() throws Exception {
        this.keySet = new HashSet<Object>();
        super.open();
    }

    @Override
    protected TimestampCollector<OUT_MAIN> getMainCollector() {
        return this.mainOutKeySelector != null && this.sideOutKeySelector != null ? new KeyCheckedOutputCollector(new OutputCollector(this.output), this.mainOutKeySelector, () -> this.getCurrentKey()) : new OutputCollector(this.output);
    }

    @Override
    public TimestampCollector<OUT_SIDE> getSideCollector() {
        return this.mainOutKeySelector != null && this.sideOutKeySelector != null ? new KeyCheckedOutputCollector<Object, OUT_SIDE>(new TwoOutputProcessOperator.SideOutputCollector(this, this.output), this.sideOutKeySelector, () -> this.getCurrentKey()) : new TwoOutputProcessOperator.SideOutputCollector(this, this.output);
    }

    @Override
    protected Object currentKey() {
        return this.getCurrentKey();
    }

    @Override
    protected TwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE> getNonPartitionedContext() {
        return new DefaultTwoOutputNonPartitionedContext(this.context, this.partitionedContext, this.mainCollector, this.sideCollector, true, this.keySet, this.output, this.watermarkDeclarationMap);
    }

    public void newKeySelected(Object newKey) {
        this.keySet.add(newKey);
    }

    @Override
    public boolean isAsyncStateProcessingEnabled() {
        return true;
    }
}

