/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink.internal;

import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.sink.internal.FlinkKafkaInternalProducer;
import org.apache.flink.connector.kafka.sink.internal.TransactionOwnership;
import org.apache.flink.util.Preconditions;

@Internal
public enum TransactionNamingStrategyImpl {
    INCREMENTING(TransactionOwnership.IMPLICIT_BY_SUBTASK_ID, false){

        @Override
        public FlinkKafkaInternalProducer<byte[], byte[]> getTransactionalProducer(Context context) {
            long lastCheckpointId;
            long expectedCheckpointId = context.getNextCheckpointId();
            Preconditions.checkState((expectedCheckpointId > (lastCheckpointId = context.getLastCheckpointId()) ? 1 : 0) != 0, (String)"Expected %s > %s", (Object[])new Object[]{expectedCheckpointId, lastCheckpointId});
            for (long checkpointId = lastCheckpointId + 1L; checkpointId < expectedCheckpointId; ++checkpointId) {
                context.recycle(context.getProducer(context.buildTransactionalId(checkpointId)));
            }
            return context.getProducer(context.buildTransactionalId(expectedCheckpointId));
        }
    }
    ,
    POOLING(TransactionOwnership.EXPLICIT_BY_WRITER_STATE, true){

        @Override
        public FlinkKafkaInternalProducer<byte[], byte[]> getTransactionalProducer(Context context) {
            Set<String> usedTransactionalIds = context.getOngoingTransactions();
            int offset = 0;
            String transactionalIdCandidate;
            while (usedTransactionalIds.contains(transactionalIdCandidate = context.buildTransactionalId(offset))) {
                ++offset;
            }
            return context.getProducer(transactionalIdCandidate);
        }
    };

    private final TransactionOwnership ownership;
    private final boolean requiresKnownTopics;

    private TransactionNamingStrategyImpl(TransactionOwnership ownership, boolean requiresKnownTopics) {
        this.ownership = ownership;
        this.requiresKnownTopics = requiresKnownTopics;
    }

    public boolean requiresKnownTopics() {
        return this.requiresKnownTopics;
    }

    public TransactionOwnership getOwnership() {
        return this.ownership;
    }

    public abstract FlinkKafkaInternalProducer<byte[], byte[]> getTransactionalProducer(Context var1);

    public static interface Context {
        public String buildTransactionalId(long var1);

        public long getNextCheckpointId();

        public Set<String> getOngoingTransactions();

        public long getLastCheckpointId();

        public FlinkKafkaInternalProducer<byte[], byte[]> getProducer(String var1);

        public void recycle(FlinkKafkaInternalProducer<byte[], byte[]> var1);
    }
}

