/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.connector.kafka.sink.KafkaWriterState;
import org.apache.flink.connector.kafka.sink.internal.CheckpointTransaction;
import org.apache.flink.connector.kafka.sink.internal.TransactionOwnership;
import org.apache.flink.core.io.SimpleVersionedSerializer;

class KafkaWriterStateSerializer
implements SimpleVersionedSerializer<KafkaWriterState> {
    KafkaWriterStateSerializer() {
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(KafkaWriterState state) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeUTF(state.getTransactionalIdPrefix());
                out.writeInt(state.getOwnedSubtaskId());
                out.writeInt(state.getTotalNumberOfOwnedSubtasks());
                out.writeInt(state.getTransactionOwnership().ordinal());
                out.writeInt(state.getPrecommittedTransactionalIds().size());
                for (CheckpointTransaction transaction : state.getPrecommittedTransactionalIds()) {
                    out.writeUTF(transaction.getTransactionalId());
                    out.writeLong(transaction.getCheckpointId());
                }
                out.flush();
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public KafkaWriterState deserialize(int version, byte[] serialized) throws IOException {
        if (version > 2) {
            throw new IOException("Unknown version: " + version);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            KafkaWriterState kafkaWriterState;
            try (DataInputStream in = new DataInputStream(bais);){
                String transactionalIdPrefix = in.readUTF();
                int ownedSubtaskId = -1;
                int totalNumberOfOwnedSubtasks = -1;
                TransactionOwnership transactionOwnership = TransactionOwnership.IMPLICIT_BY_SUBTASK_ID;
                ArrayList<CheckpointTransaction> precommitted = new ArrayList<CheckpointTransaction>();
                if (version == 2) {
                    ownedSubtaskId = in.readInt();
                    totalNumberOfOwnedSubtasks = in.readInt();
                    transactionOwnership = TransactionOwnership.values()[in.readInt()];
                    int usedTransactionIdsSize = in.readInt();
                    for (int i = 0; i < usedTransactionIdsSize; ++i) {
                        precommitted.add(new CheckpointTransaction(in.readUTF(), in.readLong()));
                    }
                }
                kafkaWriterState = new KafkaWriterState(transactionalIdPrefix, ownedSubtaskId, totalNumberOfOwnedSubtasks, transactionOwnership, precommitted);
            }
            return kafkaWriterState;
        }
    }
}

