/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.util.Collection;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.kafka.sink.internal.CheckpointTransaction;
import org.apache.flink.connector.kafka.sink.internal.TransactionOwnership;
import org.apache.flink.util.Preconditions;

@Internal
public class KafkaWriterState {
    public static final int UNKNOWN = -1;
    private final String transactionalIdPrefix;
    private final int ownedSubtaskId;
    private final int totalNumberOfOwnedSubtasks;
    private final TransactionOwnership transactionOwnership;
    private final Collection<CheckpointTransaction> precommittedTransactionalIds;

    @VisibleForTesting
    public KafkaWriterState(String transactionalIdPrefix, int ownedSubtaskId, int totalNumberOfOwnedSubtasks, TransactionOwnership transactionOwnership, Collection<CheckpointTransaction> precommittedTransactionalIds) {
        this.transactionalIdPrefix = (String)Preconditions.checkNotNull((Object)transactionalIdPrefix, (String)"transactionalIdPrefix");
        this.ownedSubtaskId = ownedSubtaskId;
        this.totalNumberOfOwnedSubtasks = totalNumberOfOwnedSubtasks;
        this.transactionOwnership = transactionOwnership;
        this.precommittedTransactionalIds = precommittedTransactionalIds;
    }

    public String getTransactionalIdPrefix() {
        return this.transactionalIdPrefix;
    }

    public int getOwnedSubtaskId() {
        return this.ownedSubtaskId;
    }

    public int getTotalNumberOfOwnedSubtasks() {
        return this.totalNumberOfOwnedSubtasks;
    }

    public Collection<CheckpointTransaction> getPrecommittedTransactionalIds() {
        return this.precommittedTransactionalIds;
    }

    public TransactionOwnership getTransactionOwnership() {
        return this.transactionOwnership;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KafkaWriterState that = (KafkaWriterState)object;
        return this.ownedSubtaskId == that.ownedSubtaskId && this.totalNumberOfOwnedSubtasks == that.totalNumberOfOwnedSubtasks && Objects.equals(this.transactionalIdPrefix, that.transactionalIdPrefix) && this.transactionOwnership == that.transactionOwnership && Objects.equals(this.precommittedTransactionalIds, that.precommittedTransactionalIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionalIdPrefix, this.ownedSubtaskId, this.totalNumberOfOwnedSubtasks, this.transactionOwnership, this.precommittedTransactionalIds});
    }

    public String toString() {
        return "KafkaWriterState{transactionalIdPrefix='" + this.transactionalIdPrefix + '\'' + ", ownedSubtaskId=" + this.ownedSubtaskId + ", totalNumberOfOwnedSubtasks=" + this.totalNumberOfOwnedSubtasks + ", transactionOwnership=" + (Object)((Object)this.transactionOwnership) + ", precommittedTransactionalIds=" + this.precommittedTransactionalIds + '}';
    }
}

