/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.testutils;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaMetadataService;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;

public class MockKafkaMetadataService
implements KafkaMetadataService {
    private Set<KafkaStream> kafkaStreams;
    private Set<String> kafkaClusterIds;
    private boolean throwException = false;

    public MockKafkaMetadataService(boolean throwException) {
        this.throwException = throwException;
    }

    public MockKafkaMetadataService(Set<KafkaStream> kafkaStreams) {
        this.setKafkaStreams(kafkaStreams);
    }

    public void setKafkaStreams(Set<KafkaStream> kafkaStreams) {
        this.kafkaStreams = kafkaStreams;
        this.kafkaClusterIds = kafkaStreams.stream().flatMap(kafkaStream -> kafkaStream.getClusterMetadataMap().keySet().stream()).collect(Collectors.toSet());
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    private void checkAndThrowException() {
        if (this.throwException) {
            throw new RuntimeException("Mock exception");
        }
    }

    public Set<KafkaStream> getAllStreams() {
        this.checkAndThrowException();
        return this.kafkaStreams;
    }

    public Map<String, KafkaStream> describeStreams(Collection<String> streamIds) {
        this.checkAndThrowException();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (KafkaStream stream : this.getAllStreams()) {
            if (!streamIds.contains(stream.getStreamId())) continue;
            builder.put((Object)stream.getStreamId(), (Object)stream);
        }
        return builder.build();
    }

    public boolean isClusterActive(String kafkaClusterId) {
        this.checkAndThrowException();
        return this.kafkaClusterIds.contains(kafkaClusterId);
    }

    public void close() throws Exception {
    }
}

