/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;

public class NFATestUtilities {
    @Deprecated
    public static List<List<Event>> feedNFA(List<StreamRecord<Event>> inputEvents, NFA<Event> nfa) throws Exception {
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).build();
        return nfaTestHarness.feedRecords(inputEvents);
    }

    public static void comparePatterns(List<List<Event>> actual, List<List<Event>> expected) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (List<Event> p : actual) {
            Collections.sort(p, new EventComparator());
        }
        for (List<Event> p : expected) {
            Collections.sort(p, new EventComparator());
        }
        Collections.sort(actual, new ListEventComparator());
        Collections.sort(expected, new ListEventComparator());
        Assert.assertArrayEquals((Object[])expected.toArray(), (Object[])actual.toArray());
    }

    private NFATestUtilities() {
    }

    private static class EventComparator
    implements Comparator<Event> {
        private EventComparator() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            int nameComp = o1.getName().compareTo(o2.getName());
            int priceComp = Double.compare(o1.getPrice(), o2.getPrice());
            int idComp = Integer.compare(o1.getId(), o2.getId());
            if (nameComp == 0) {
                if (priceComp == 0) {
                    return idComp;
                }
                return priceComp;
            }
            return nameComp;
        }
    }

    private static class ListEventComparator
    implements Comparator<List<Event>> {
        private ListEventComparator() {
        }

        @Override
        public int compare(List<Event> o1, List<Event> o2) {
            int sizeComp = Integer.compare(o1.size(), o2.size());
            if (sizeComp == 0) {
                EventComparator comp = new EventComparator();
                for (int i = 0; i < o1.size(); ++i) {
                    int eventComp = comp.compare(o1.get(i), o2.get(i));
                    if (eventComp == 0) continue;
                    return eventComp;
                }
                return 0;
            }
            return sizeComp;
        }
    }
}

