/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.pattern;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.SubEvent;
import org.apache.flink.cep.pattern.MalformedPatternException;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.Quantifier;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.RichAndCondition;
import org.apache.flink.cep.pattern.conditions.RichOrCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.pattern.conditions.SubtypeCondition;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PatternTest
extends TestLogger {
    @Test
    public void testStrictContiguity() {
        Pattern pattern = Pattern.begin((String)"start").next("next").next("end");
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"next");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testNonStrictContiguity() {
        Pattern pattern = Pattern.begin((String)"start").followedBy("next").followedBy("end");
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertEquals((Object)Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, (Object)pattern.getQuantifier().getConsumingStrategy());
        Assert.assertEquals((Object)Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, (Object)previous.getQuantifier().getConsumingStrategy());
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"next");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testStrictContiguityWithCondition() {
        Pattern pattern = Pattern.begin((String)"start").next("next").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("foobar"))).next("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getId() == 42));
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertNotNull((Object)pattern.getCondition());
        Assert.assertNotNull((Object)previous.getCondition());
        Assert.assertNotNull((Object)previous2.getCondition());
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"next");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testPatternWithSubtyping() {
        Pattern pattern = Pattern.begin((String)"start").next("subevent").subtype(SubEvent.class).followedBy("end");
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertNotNull((Object)previous.getCondition());
        Assert.assertTrue((boolean)(previous.getCondition() instanceof SubtypeCondition));
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"subevent");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testPatternWithSubtypingAndFilter() {
        Pattern pattern = Pattern.begin((String)"start").next("subevent").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> false)).followedBy("end");
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertEquals((Object)Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, (Object)pattern.getQuantifier().getConsumingStrategy());
        Assert.assertNotNull((Object)previous.getCondition());
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"subevent");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testPatternWithOrFilter() {
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> false)).or((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> false)).next("or").or((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> false)).followedBy("end");
        Pattern previous = pattern.getPrevious();
        Assert.assertNotNull((Object)previous);
        Pattern previous2 = previous.getPrevious();
        Assert.assertNotNull((Object)previous2);
        Assert.assertNull((Object)previous2.getPrevious());
        Assert.assertEquals((Object)Quantifier.ConsumingStrategy.SKIP_TILL_NEXT, (Object)pattern.getQuantifier().getConsumingStrategy());
        Assert.assertFalse((boolean)(previous.getCondition() instanceof RichOrCondition));
        Assert.assertTrue((boolean)(previous2.getCondition() instanceof RichOrCondition));
        Assert.assertEquals((Object)pattern.getName(), (Object)"end");
        Assert.assertEquals((Object)previous.getName(), (Object)"or");
        Assert.assertEquals((Object)previous2.getName(), (Object)"start");
    }

    @Test
    public void testRichCondition() {
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)Mockito.mock(IterativeCondition.class)).where((IterativeCondition)Mockito.mock(IterativeCondition.class)).followedBy("end").where((IterativeCondition)Mockito.mock(IterativeCondition.class)).or((IterativeCondition)Mockito.mock(IterativeCondition.class));
        Assert.assertTrue((boolean)(pattern.getCondition() instanceof RichOrCondition));
        Assert.assertTrue((boolean)(pattern.getPrevious().getCondition() instanceof RichAndCondition));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPatternTimesNegativeTimes() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).times(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPatternTimesNegativeFrom() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).times(-1, 2);
    }

    @Test(expected=MalformedPatternException.class)
    public void testPatternCanHaveQuantifierSpecifiedOnce1() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).oneOrMore().oneOrMore().optional();
    }

    @Test(expected=MalformedPatternException.class)
    public void testPatternCanHaveQuantifierSpecifiedOnce2() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).oneOrMore().optional().times(1);
    }

    @Test(expected=MalformedPatternException.class)
    public void testPatternCanHaveQuantifierSpecifiedOnce3() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).times(1).oneOrMore();
    }

    @Test(expected=MalformedPatternException.class)
    public void testPatternCanHaveQuantifierSpecifiedOnce4() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).oneOrMore().oneOrMore();
    }

    @Test(expected=MalformedPatternException.class)
    public void testPatternCanHaveQuantifierSpecifiedOnce5() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).oneOrMore().oneOrMore().optional();
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotNextCannotBeOneOrMore() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notNext("not").where(this.dummyCondition()).oneOrMore();
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotNextCannotBeTimes() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notNext("not").where(this.dummyCondition()).times(3);
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotNextCannotBeOptional() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notNext("not").where(this.dummyCondition()).optional();
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotFollowedCannotBeOneOrMore() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notFollowedBy("not").where(this.dummyCondition()).oneOrMore();
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotFollowedCannotBeTimes() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notFollowedBy("not").where(this.dummyCondition()).times(3);
    }

    @Test(expected=MalformedPatternException.class)
    public void testNotFollowedCannotBeOptional() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).notFollowedBy("not").where(this.dummyCondition()).optional();
    }

    @Test(expected=MalformedPatternException.class)
    public void testUntilCannotBeAppliedToTimes() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).times(1).until(this.dummyCondition());
    }

    @Test(expected=MalformedPatternException.class)
    public void testUntilCannotBeAppliedToSingleton() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).until(this.dummyCondition());
    }

    @Test(expected=MalformedPatternException.class)
    public void testUntilCannotBeAppliedTwice() throws Exception {
        Pattern.begin((String)"start").where(this.dummyCondition()).until(this.dummyCondition()).until(this.dummyCondition());
    }

    private SimpleCondition<Object> dummyCondition() {
        return SimpleCondition.of((FilterFunction & Serializable)value -> true);
    }
}

