/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.test.util.MigrationTest;
import org.assertj.core.api.Condition;

class LockableTypeSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Lockable<String>, Lockable<String>> {
    private static final String SPEC_NAME = "lockable-type-serializer";

    LockableTypeSerializerUpgradeTest() {
    }

    public Collection<FlinkVersion> getMigrationVersions() {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_20, (FlinkVersion)MigrationTest.getMostRecentlyPublishedVersion());
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, LockableTypeSerializerSetup.class, LockableTypeSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class LockableTypeSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Lockable<String>> {
        public TypeSerializer<Lockable<String>> createPriorSerializer() {
            return new Lockable.LockableTypeSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Lockable<String> createTestData() {
            return new Lockable((Object)"flink", 10);
        }
    }

    public static final class LockableTypeSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Lockable<String>> {
        public TypeSerializer<Lockable<String>> createUpgradedSerializer() {
            return new Lockable.LockableTypeSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<Lockable<String>> testDataCondition() {
            return new Condition(value -> new Lockable((Object)"flink", 10).equals(value), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<Lockable<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }
}

