/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.SubEvent;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.TestSharedBuffer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class NFAStateAccessTest {
    @Test
    public void testComplexBranchingAfterZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event end1 = new Event(44, "b", 5.0);
        Event end2 = new Event(45, "d", 6.0);
        Event end3 = new Event(46, "d", 7.0);
        Event end4 = new Event(47, "e", 8.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)end1, 6L));
        inputEvents.add(new StreamRecord((Object)end2, 7L));
        inputEvents.add(new StreamRecord((Object)end3, 8L));
        inputEvents.add(new StreamRecord((Object)end4, 9L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().optional().followedByAny("end1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedByAny("end2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedByAny("end3").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer());
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withSharedBuffer(sharedBuffer).build();
        nfaTestHarness.consumeRecords(inputEvents);
        Assert.assertEquals((long)58L, (long)sharedBuffer.getStateReads());
        Assert.assertEquals((long)41L, (long)sharedBuffer.getStateWrites());
        Assert.assertEquals((long)99L, (long)sharedBuffer.getStateAccesses());
    }

    @Test
    public void testIterativeWithABACPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent1 = new Event(40, "start", 1.0);
        Event startEvent2 = new Event(40, "start", 2.0);
        Event startEvent3 = new Event(40, "start", 3.0);
        Event startEvent4 = new Event(40, "start", 4.0);
        SubEvent middleEvent1 = new SubEvent(41, "foo1", 1.0, 10.0);
        SubEvent middleEvent2 = new SubEvent(42, "foo2", 2.0, 10.0);
        SubEvent middleEvent3 = new SubEvent(43, "foo3", 3.0, 10.0);
        SubEvent middleEvent4 = new SubEvent(43, "foo4", 1.0, 10.0);
        Event endEvent = new Event(46, "end", 1.0);
        inputEvents.add(new StreamRecord((Object)startEvent1, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 2L));
        inputEvents.add(new StreamRecord((Object)startEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)startEvent3, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 2L));
        inputEvents.add(new StreamRecord((Object)startEvent4, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 2L));
        inputEvents.add(new StreamRecord((Object)middleEvent4, 2L));
        inputEvents.add(new StreamRecord((Object)endEvent, 4L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("start"))).followedByAny("middle1").subtype(SubEvent.class).where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().startsWith("foo"))).followedBy("middle2").where((IterativeCondition)new IterativeCondition<Event>(){
            private static final long serialVersionUID = -1223388426808292695L;

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                if (!value.getName().equals("start")) {
                    return false;
                }
                double sum = 0.0;
                for (Event e : ctx.getEventsForPattern("middle2")) {
                    sum += e.getPrice();
                }
                return Double.compare(sum += value.getPrice(), 5.0) <= 0;
            }
        }).oneOrMore().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("end")));
        TestSharedBuffer<Event> sharedBuffer = TestSharedBuffer.createTestBuffer(Event.createTypeSerializer());
        NFATestHarness nfaTestHarness = NFATestHarness.forPattern(pattern).withSharedBuffer(sharedBuffer).build();
        nfaTestHarness.consumeRecords(inputEvents);
        Assert.assertEquals((long)90L, (long)sharedBuffer.getStateReads());
        Assert.assertEquals((long)34L, (long)sharedBuffer.getStateWrites());
        Assert.assertEquals((long)124L, (long)sharedBuffer.getStateAccesses());
    }
}

