/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class GroupITCase
extends TestLogger {
    @Test
    public void testGroupFollowedByTimes() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d = new Event(45, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).times(2).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d})}));
    }

    @Test
    public void testGroupFollowedByOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event a2 = new Event(42, "a", 2.0);
        Event b = new Event(43, "b", 3.0);
        Event d = new Event(44, "d", 4.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)b, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b, d})}));
    }

    @Test
    public void testFollowedByGroupTimesOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a = new Event(41, "a", 2.0);
        Event d = new Event(45, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a, 2L));
        inputEvents.add(new StreamRecord((Object)d, 3L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).times(2).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d})}));
    }

    @Test
    public void testGroupFollowedByOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d = new Event(45, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).oneOrMore().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, b1, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d})}));
    }

    @Test
    public void testGroupFollowedByZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d = new Event(45, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).oneOrMore().optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d})}));
    }

    @Test
    public void testGroupFollowedByAnyTimesCombinations() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event a3 = new Event(45, "a", 4.0);
        Event b3 = new Event(46, "b", 5.0);
        Event d = new Event(47, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)a3, 6L));
        inputEvents.add(new StreamRecord((Object)b3, 7L));
        inputEvents.add(new StreamRecord((Object)d, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).times(2).allowCombinations().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a3, b3, d}), Lists.newArrayList((Object[])new Event[]{c, a2, b2, a3, b3, d})}));
    }

    @Test
    public void testGroupFollowedByAnyTimesOptional() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event a3 = new Event(45, "a", 4.0);
        Event b3 = new Event(46, "b", 5.0);
        Event d = new Event(47, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)a3, 6L));
        inputEvents.add(new StreamRecord((Object)b3, 7L));
        inputEvents.add(new StreamRecord((Object)d, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).times(2).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d}), Lists.newArrayList((Object[])new Event[]{c, a2, b2, a3, b3, d})}));
    }

    @Test
    public void testGroupFollowedByAnyOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event a3 = new Event(45, "a", 4.0);
        Event b3 = new Event(46, "b", 5.0);
        Event d = new Event(47, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)a3, 6L));
        inputEvents.add(new StreamRecord((Object)b3, 7L));
        inputEvents.add(new StreamRecord((Object)d, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).oneOrMore().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, b1, d}), Lists.newArrayList((Object[])new Event[]{c, a2, b2, d}), Lists.newArrayList((Object[])new Event[]{c, a3, b3, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d}), Lists.newArrayList((Object[])new Event[]{c, a2, b2, a3, b3, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, a3, b3, d})}));
    }

    @Test
    public void testGroupNextZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 3.0);
        Event b2 = new Event(44, "b", 3.0);
        Event a3 = new Event(45, "a", 4.0);
        Event b3 = new Event(46, "b", 3.0);
        Event d = new Event(47, "d", 1.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 3L));
        inputEvents.add(new StreamRecord((Object)b1, 4L));
        inputEvents.add(new StreamRecord((Object)a2, 5L));
        inputEvents.add(new StreamRecord((Object)b2, 6L));
        inputEvents.add(new StreamRecord((Object)a3, 7L));
        inputEvents.add(new StreamRecord((Object)b3, 8L));
        inputEvents.add(new StreamRecord((Object)d, 9L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).next(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).oneOrMore().optional().consecutive().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, a3, b3, d})}));
    }

    @Test
    public void testGroupNotFollowedBy() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event d = new Event(43, "d", 3.0);
        Event a2 = new Event(44, "a", 4.0);
        Event b2 = new Event(45, "b", 5.0);
        Event e = new Event(46, "e", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)a2, 5L));
        inputEvents.add(new StreamRecord((Object)b2, 6L));
        inputEvents.add(new StreamRecord((Object)e, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).notFollowedBy("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a2, b2, e})}));
    }

    @Test
    public void testGroupNotNext() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event d = new Event(43, "d", 3.0);
        Event a2 = new Event(44, "a", 4.0);
        Event b2 = new Event(45, "b", 5.0);
        Event e = new Event(46, "e", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)d, 4L));
        inputEvents.add(new StreamRecord((Object)a2, 5L));
        inputEvents.add(new StreamRecord((Object)b2, 6L));
        inputEvents.add(new StreamRecord((Object)e, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).notNext("notPattern").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a2, b2, e})}));
    }

    @Test
    public void testGroupNest() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event d = new Event(40, "d", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c1 = new Event(43, "c", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event c2 = new Event(45, "c", 4.0);
        Event e = new Event(46, "e", 6.0);
        inputEvents.add(new StreamRecord((Object)d, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)c2, 6L));
        inputEvents.add(new StreamRecord((Object)e, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy(Pattern.begin((String)"middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("middle3").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")))).oneOrMore().optional()).optional().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{d, e}), Lists.newArrayList((Object[])new Event[]{d, a1, e}), Lists.newArrayList((Object[])new Event[]{d, a1, b1, c1, e}), Lists.newArrayList((Object[])new Event[]{d, a1, b1, c1, b2, c2, e})}));
    }

    @Test
    public void testGroupNestTimes() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event d = new Event(40, "d", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c1 = new Event(43, "c", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event c2 = new Event(45, "c", 4.0);
        Event b3 = new Event(46, "b", 5.0);
        Event c3 = new Event(47, "c", 4.0);
        Event a2 = new Event(48, "a", 2.0);
        Event b4 = new Event(49, "b", 3.0);
        Event c4 = new Event(50, "c", 4.0);
        Event b5 = new Event(51, "b", 5.0);
        Event c5 = new Event(52, "c", 4.0);
        Event b6 = new Event(53, "b", 5.0);
        Event c6 = new Event(54, "c", 4.0);
        Event e = new Event(55, "e", 6.0);
        inputEvents.add(new StreamRecord((Object)d, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)c2, 6L));
        inputEvents.add(new StreamRecord((Object)b3, 7L));
        inputEvents.add(new StreamRecord((Object)c3, 8L));
        inputEvents.add(new StreamRecord((Object)a2, 9L));
        inputEvents.add(new StreamRecord((Object)b4, 10L));
        inputEvents.add(new StreamRecord((Object)c4, 11L));
        inputEvents.add(new StreamRecord((Object)b5, 12L));
        inputEvents.add(new StreamRecord((Object)c5, 13L));
        inputEvents.add(new StreamRecord((Object)b6, 14L));
        inputEvents.add(new StreamRecord((Object)c6, 15L));
        inputEvents.add(new StreamRecord((Object)e, 16L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy(Pattern.begin((String)"middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("middle3").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")))).times(3)).times(0, 2).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{d, e}), Lists.newArrayList((Object[])new Event[]{d, a1, b1, c1, b2, c2, b3, c3, e}), Lists.newArrayList((Object[])new Event[]{d, a2, b4, c4, b5, c5, b6, c6, e}), Lists.newArrayList((Object[])new Event[]{d, a1, b1, c1, b2, c2, b3, c3, a2, b4, c4, b5, c5, b6, c6, e})}));
    }

    @Test
    public void testGroupNestTimesConsecutive() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event d = new Event(40, "d", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event c1 = new Event(43, "c", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event c2 = new Event(45, "c", 4.0);
        Event b3 = new Event(46, "b", 5.0);
        Event c3 = new Event(47, "c", 4.0);
        Event a2 = new Event(48, "a", 2.0);
        Event b4 = new Event(49, "b", 3.0);
        Event c4 = new Event(50, "c", 4.0);
        Event b5 = new Event(51, "b", 5.0);
        Event c5 = new Event(52, "c", 4.0);
        Event b6 = new Event(53, "b", 5.0);
        Event c6 = new Event(54, "c", 4.0);
        Event e = new Event(55, "e", 6.0);
        inputEvents.add(new StreamRecord((Object)d, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)c1, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)c2, 6L));
        inputEvents.add(new StreamRecord((Object)b3, 7L));
        inputEvents.add(new StreamRecord((Object)c3, 8L));
        inputEvents.add(new StreamRecord((Object)a2, 9L));
        inputEvents.add(new StreamRecord((Object)b4, 10L));
        inputEvents.add(new StreamRecord((Object)c4, 11L));
        inputEvents.add(new StreamRecord((Object)new Event(0, "breaking", 99.0), 12L));
        inputEvents.add(new StreamRecord((Object)b5, 13L));
        inputEvents.add(new StreamRecord((Object)c5, 14L));
        inputEvents.add(new StreamRecord((Object)b6, 15L));
        inputEvents.add(new StreamRecord((Object)c6, 16L));
        inputEvents.add(new StreamRecord((Object)e, 17L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedByAny(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy(Pattern.begin((String)"middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).followedBy("middle3").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")))).times(3).consecutive()).times(0, 2).consecutive().followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("e")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{d, e}), Lists.newArrayList((Object[])new Event[]{d, a1, b1, c1, b2, c2, b3, c3, e})}));
    }

    @Test
    public void testGroupBegin() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d = new Event(45, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)a1, 1L));
        inputEvents.add(new StreamRecord((Object)b1, 2L));
        inputEvents.add(new StreamRecord((Object)a2, 3L));
        inputEvents.add(new StreamRecord((Object)b2, 4L));
        inputEvents.add(new StreamRecord((Object)d, 5L));
        Pattern pattern = Pattern.begin((Pattern)Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).times(1, 2).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a1, b1, d}), Lists.newArrayList((Object[])new Event[]{a2, b2, d}), Lists.newArrayList((Object[])new Event[]{a1, b1, a2, b2, d})}));
    }

    @Test
    public void testGroupFollowedByOneOrMoreWithUntilCondition() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event c = new Event(40, "c", 1.0);
        Event a1 = new Event(41, "a", 2.0);
        Event b1 = new Event(42, "b", 3.0);
        Event a2 = new Event(43, "a", 4.0);
        Event b2 = new Event(44, "b", 5.0);
        Event d = new Event(45, "d", 6.0);
        inputEvents.add(new StreamRecord((Object)c, 1L));
        inputEvents.add(new StreamRecord((Object)a1, 2L));
        inputEvents.add(new StreamRecord((Object)b1, 3L));
        inputEvents.add(new StreamRecord((Object)a2, 4L));
        inputEvents.add(new StreamRecord((Object)b2, 5L));
        inputEvents.add(new StreamRecord((Object)d, 6L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b")))).oneOrMore().until((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d"))).followedBy("end").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{c, a1, b1, d}), Lists.newArrayList((Object[])new Event[]{c, a1, b1, a2, b2, d})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testGroupStartsWithOptionalPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(40, "a", 1.0);
        Event c = new Event(41, "c", 2.0);
        Event d = new Event(42, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)a, 1L));
        inputEvents.add(new StreamRecord((Object)c, 2L));
        inputEvents.add(new StreamRecord((Object)d, 3L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).next(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).optional().next("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")))).next("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, c, d})}));
    }

    @Test
    public void testFollowedByOptionalGroupPattern() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event a = new Event(40, "a", 1.0);
        Event d1 = new Event(41, "d", 2.0);
        Event d2 = new Event(42, "d", 3.0);
        inputEvents.add(new StreamRecord((Object)a, 1L));
        inputEvents.add(new StreamRecord((Object)d1, 2L));
        inputEvents.add(new StreamRecord((Object)d2, 3L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).followedBy(Pattern.begin((String)"middle1").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("b"))).next("middle2").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c")))).optional().next("d").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("d")));
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{a, d1})}));
    }
}

