/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.NFAStateSerializer;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNodeSerializer;
import org.apache.flink.test.util.MigrationTest;
import org.assertj.core.api.Condition;

class NFASerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    NFASerializerUpgradeTest() {
    }

    public Collection<FlinkVersion> getMigrationVersions() {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_20, (FlinkVersion)MigrationTest.getMostRecentlyPublishedVersion());
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("event-id-serializer", flinkVersion, EventIdSerializerSetup.class, EventIdSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("node-id-serializer", flinkVersion, NodeIdSerializerSetup.class, NodeIdSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("dewey-number-serializer", flinkVersion, DeweyNumberSerializerSetup.class, DeweyNumberSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("shared-buffer-edge-serializer", flinkVersion, SharedBufferEdgeSerializerSetup.class, SharedBufferEdgeSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("nfa-state-serializer", flinkVersion, NFAStateSerializerSetup.class, NFAStateSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class EventIdSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<EventId> {
        public TypeSerializer<EventId> createPriorSerializer() {
            return EventId.EventIdSerializer.INSTANCE;
        }

        public EventId createTestData() {
            return new EventId(42, 42L);
        }
    }

    public static final class EventIdSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<EventId> {
        public TypeSerializer<EventId> createUpgradedSerializer() {
            return EventId.EventIdSerializer.INSTANCE;
        }

        public Condition<EventId> testDataCondition() {
            return new Condition(value -> value.equals((Object)new EventId(42, 42L)), "is 42", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<EventId>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class NodeIdSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NodeId> {
        public TypeSerializer<NodeId> createPriorSerializer() {
            return new NodeId.NodeIdSerializer();
        }

        public NodeId createTestData() {
            return new NodeId(new EventId(42, 42L), "ciao");
        }
    }

    public static final class NodeIdSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NodeId> {
        public TypeSerializer<NodeId> createUpgradedSerializer() {
            return new NodeId.NodeIdSerializer();
        }

        public Condition<NodeId> testDataCondition() {
            return new Condition(value -> value.equals((Object)new NodeId(new EventId(42, 42L), "ciao")), "is 42", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<NodeId>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class DeweyNumberSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<DeweyNumber> {
        public TypeSerializer<DeweyNumber> createPriorSerializer() {
            return DeweyNumber.DeweyNumberSerializer.INSTANCE;
        }

        public DeweyNumber createTestData() {
            return new DeweyNumber(42);
        }
    }

    public static final class DeweyNumberSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<DeweyNumber> {
        public TypeSerializer<DeweyNumber> createUpgradedSerializer() {
            return DeweyNumber.DeweyNumberSerializer.INSTANCE;
        }

        public Condition<DeweyNumber> testDataCondition() {
            return new Condition(value -> value.equals((Object)new DeweyNumber(42)), "is 42", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<DeweyNumber>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class SharedBufferEdgeSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<SharedBufferEdge> {
        public TypeSerializer<SharedBufferEdge> createPriorSerializer() {
            return new SharedBufferEdge.SharedBufferEdgeSerializer();
        }

        public SharedBufferEdge createTestData() {
            return new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42));
        }
    }

    public static final class SharedBufferEdgeSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<SharedBufferEdge> {
        public TypeSerializer<SharedBufferEdge> createUpgradedSerializer() {
            return new SharedBufferEdge.SharedBufferEdgeSerializer();
        }

        public Condition<SharedBufferEdge> testDataCondition() {
            return new Condition(value -> value.equals((Object)new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42))), "is 42", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<SharedBufferEdge>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class NFAStateSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<NFAState> {
        public TypeSerializer<NFAState> createPriorSerializer() {
            return new NFAStateSerializer();
        }

        public NFAState createTestData() {
            return new NFAState(Collections.emptyList());
        }
    }

    public static final class NFAStateSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<NFAState> {
        public TypeSerializer<NFAState> createUpgradedSerializer() {
            return new NFAStateSerializer();
        }

        public Condition<NFAState> testDataCondition() {
            return new Condition(value -> new NFAState(Collections.emptyList()).equals(value), "is empty", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<NFAState>> schemaCompatibilityCondition(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_15)) {
                return TypeSerializerConditions.isCompatibleAsIs();
            }
            return TypeSerializerConditions.isCompatibleAfterMigration();
        }
    }

    public static final class SharedBufferNodeSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<SharedBufferNode> {
        public TypeSerializer<SharedBufferNode> createUpgradedSerializer() {
            return new SharedBufferNodeSerializer();
        }

        public Condition<SharedBufferNode> testDataCondition() {
            SharedBufferNode result = new SharedBufferNode();
            result.addEdge(new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42)));
            return new Condition(value -> value.equals((Object)result), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<SharedBufferNode>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class SharedBufferNodeSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<SharedBufferNode> {
        public TypeSerializer<SharedBufferNode> createPriorSerializer() {
            return new SharedBufferNodeSerializer();
        }

        public SharedBufferNode createTestData() {
            SharedBufferNode result = new SharedBufferNode();
            result.addEdge(new SharedBufferEdge(new NodeId(new EventId(42, 42L), "page"), new DeweyNumber(42)));
            return result;
        }
    }
}

