/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.jdbc.impl.BasicList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillColumnMetaDataList
extends BasicList<ColumnMetaData> {
    static final Logger logger = LoggerFactory.getLogger(DrillColumnMetaDataList.class);
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public ColumnMetaData get(int index) {
        return this.columns.get(index);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(String sqlTypeName) {
        int jdbcTypeId = Types.getJdbcTypeCode((String)sqlTypeName);
        return ColumnMetaData.scalar((int)jdbcTypeId, (String)sqlTypeName, (ColumnMetaData.Rep)ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(List<UserProtos.ResultColumnMetadata> metadata) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(metadata.size());
        int offset = 0;
        for (UserProtos.ResultColumnMetadata m : metadata) {
            ColumnMetaData.AvaticaType bundledSqlDataType = DrillColumnMetaDataList.getAvaticaType(m.getDataType());
            newColumns.add(new ColumnMetaData(offset, m.getAutoIncrement(), m.getCaseSensitivity(), m.getSearchability() != UserProtos.ColumnSearchability.NONE, m.getIsCurrency(), m.getIsNullable() ? 1 : 0, m.getSigned(), m.getDisplaySize(), m.getLabel(), m.getColumnName(), m.getSchemaName(), m.getPrecision(), m.getScale(), m.getTableName(), m.getCatalogName(), bundledSqlDataType, m.getUpdatability() == UserProtos.ColumnUpdatability.READ_ONLY, m.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m.getUpdatability() == UserProtos.ColumnUpdatability.WRITABLE, m.getClassName()));
            ++offset;
        }
        this.columns = ImmutableList.copyOf(newColumns);
    }

    private static ColumnMetaData.AvaticaType getAvaticaType(TypeProtos.MajorType rpcDateType) {
        String sqlTypeName = Types.getSqlTypeName((TypeProtos.MajorType)rpcDateType);
        int jdbcTypeId = Types.getJdbcTypeCode((String)sqlTypeName);
        return ColumnMetaData.scalar((int)jdbcTypeId, (String)sqlTypeName, (ColumnMetaData.Rep)ColumnMetaData.Rep.BOOLEAN);
    }

    public void updateColumnMetaData(String catalogName, String schemaName, String tableName, BatchSchema schema, List<Class<?>> getObjectClasses) {
        ArrayList<ColumnMetaData> newColumns = new ArrayList<ColumnMetaData>(schema.getFieldCount());
        for (int colOffset = 0; colOffset < schema.getFieldCount(); ++colOffset) {
            int nullability;
            MaterializedField field = schema.getColumn(colOffset);
            Class<?> objectClass = getObjectClasses.get(colOffset);
            String columnName = field.getName();
            TypeProtos.MajorType rpcDataType = field.getType();
            ColumnMetaData.AvaticaType bundledSqlDataType = DrillColumnMetaDataList.getAvaticaType(rpcDataType);
            String columnClassName = objectClass.getName();
            switch (field.getDataMode()) {
                case OPTIONAL: {
                    nullability = 1;
                    break;
                }
                case REQUIRED: {
                    nullability = 0;
                    break;
                }
                case REPEATED: {
                    nullability = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected new DataMode value '" + field.getDataMode().name() + "'"));
                }
            }
            boolean isSigned = Types.isJdbcSignedType((TypeProtos.MajorType)rpcDataType);
            int precision = Types.getPrecision((TypeProtos.MajorType)rpcDataType);
            int scale = Types.getScale((TypeProtos.MajorType)rpcDataType);
            int displaySize = Types.getJdbcDisplaySize((TypeProtos.MajorType)rpcDataType);
            ColumnMetaData col = new ColumnMetaData(colOffset, false, false, true, false, nullability, isSigned, displaySize, columnName, columnName, schemaName, precision, scale, tableName, catalogName, bundledSqlDataType, true, false, false, columnClassName);
            newColumns.add(col);
        }
        this.columns = newColumns;
    }

    @Override
    public boolean contains(Object o) {
        return this.columns.contains(o);
    }

    @Override
    public Iterator<ColumnMetaData> iterator() {
        return this.columns.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.columns.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.columns.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.columns.containsAll(c);
    }

    @Override
    public int indexOf(Object o) {
        return this.columns.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.columns.lastIndexOf(o);
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator() {
        return this.columns.listIterator();
    }

    @Override
    public ListIterator<ColumnMetaData> listIterator(int index) {
        return this.columns.listIterator(index);
    }

    @Override
    public List<ColumnMetaData> subList(int fromIndex, int toIndex) {
        return this.columns.subList(fromIndex, toIndex);
    }
}

