/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.proxy;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class TracingProxyDriverTest
extends DrillTest {
    private static Driver proxyDriver;
    private static Connection proxyConnection;

    @BeforeClass
    public static void setUpTestCase() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.drill.jdbc.proxy.TracingProxyDriver");
        proxyDriver = DriverManager.getDriver("jdbc:proxy:org.apache.drill.jdbc.Driver:jdbc:drill:zk=local");
        proxyConnection = DriverManager.getConnection("jdbc:proxy::jdbc:drill:zk=local");
    }

    @Test
    public void testBasicProxying() throws SQLException {
        try (Statement stmt = proxyConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.CATALOGS");
            Assert.assertTrue((boolean)rs.next());
            MatcherAssert.assertThat((Object)rs.getString(1), (Matcher)CoreMatchers.equalTo((Object)"DRILL"));
            MatcherAssert.assertThat((Object)rs.getObject(1), (Matcher)CoreMatchers.equalTo((Object)"DRILL"));
        }
    }

    @Test
    public void testBasicReturnTrace() throws SQLException {
        StdErrCapturer nameThis = new StdErrCapturer();
        try {
            nameThis.redirect();
            proxyConnection.isClosed();
        }
        finally {
            nameThis.unredirect();
        }
        String output = nameThis.getOutput();
        String[] lines = output.split("\n");
        MatcherAssert.assertThat((String)("Not 2 lines: \"\"\"" + output + "\"\"\""), (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)2));
        String callLine = lines[0];
        String returnLine = lines[1];
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)" CALL:"));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)" RETURN:"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)"(Connection)"));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"(Connection)"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)"isClosed()"));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"isClosed()"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)" (boolean) ")));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)" (boolean) "));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"false")));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicThrowTrace() throws SQLException {
        StdErrCapturer stdErrCapturer = new StdErrCapturer();
        Statement statement = proxyConnection.createStatement();
        statement.close();
        try {
            stdErrCapturer.redirect();
            statement.execute("");
        }
        catch (SQLException sQLException) {
        }
        finally {
            stdErrCapturer.unredirect();
        }
        String output = stdErrCapturer.getOutput();
        String[] lines = output.split("\n");
        MatcherAssert.assertThat((String)("Not 2 lines: \"\"\"" + output + "\"\"\""), (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)2));
        String callLine = lines[0];
        String returnLine = lines[1];
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)" CALL:"));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)" THROW:"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)"(Statement)"));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"(Statement)"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.containsString((String)"execute("));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"execute("));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"threw:")));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.containsString((String)"threw:"));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"exception"), (Matcher)CoreMatchers.containsString((String)"Exception"))));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"exception"), (Matcher)CoreMatchers.containsString((String)"Exception")));
        MatcherAssert.assertThat((Object)callLine, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"closed"), (Matcher)CoreMatchers.containsString((String)"Closed"))));
        MatcherAssert.assertThat((Object)returnLine, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"closed"), (Matcher)CoreMatchers.containsString((String)"Closed")));
    }

    @Test
    public void testUnsortedMethods() throws SQLException {
        proxyDriver.getMajorVersion();
        proxyDriver.getMinorVersion();
        proxyDriver.jdbcCompliant();
        proxyDriver.getParentLogger();
        proxyDriver.getPropertyInfo("jdbc:proxy::jdbc:drill:zk=local", new Properties());
        DatabaseMetaData dbMetaData = proxyConnection.getMetaData();
        MatcherAssert.assertThat((Object)dbMetaData, (Matcher)CoreMatchers.instanceOf(DatabaseMetaData.class));
        MatcherAssert.assertThat((Object)dbMetaData, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)dbMetaData.getConnection(), (Matcher)CoreMatchers.sameInstance((Object)proxyConnection));
        dbMetaData.allTablesAreSelectable();
        try {
            dbMetaData.ownUpdatesAreVisible(1003);
            Assert.fail();
        }
        catch (RuntimeException | SQLException exception) {
            // empty catch block
        }
        ResultSet catalogsResultSet = dbMetaData.getCatalogs();
        MatcherAssert.assertThat((Object)catalogsResultSet, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)catalogsResultSet, (Matcher)CoreMatchers.instanceOf(ResultSet.class));
        catalogsResultSet.next();
        catalogsResultSet.getString(1);
        catalogsResultSet.getObject(1);
        ResultSetMetaData rsMetaData = catalogsResultSet.getMetaData();
        MatcherAssert.assertThat((Object)rsMetaData, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rsMetaData, (Matcher)CoreMatchers.instanceOf(ResultSetMetaData.class));
        int colCount = rsMetaData.getColumnCount();
        for (int cx = 1; cx <= colCount; ++cx) {
            catalogsResultSet.getObject(cx);
            catalogsResultSet.getString(cx);
            try {
                catalogsResultSet.getInt(cx);
                Assert.fail((String)"Expected some kind of string-to-int exception.");
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        MatcherAssert.assertThat((Object)proxyConnection.getMetaData(), (Matcher)CoreMatchers.sameInstance((Object)dbMetaData));
        MatcherAssert.assertThat((Object)catalogsResultSet.getMetaData(), (Matcher)CoreMatchers.sameInstance((Object)rsMetaData));
    }

    private static class StdErrCapturer {
        private final PrintStream savedStdErr;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final PrintStream capturingStream = new PrintStream(this.buffer);
        private boolean redirected;

        StdErrCapturer() {
            this.savedStdErr = System.err;
        }

        void redirect() {
            Assert.assertFalse((boolean)this.redirected);
            this.redirected = true;
            System.setErr(this.capturingStream);
        }

        void unredirect() {
            Assert.assertTrue((boolean)this.redirected);
            this.redirected = false;
            System.setErr(this.savedStdErr);
        }

        String getOutput() {
            Assert.assertFalse((boolean)this.redirected);
            return new String(this.buffer.toByteArray(), StandardCharsets.UTF_8);
        }
    }
}

