/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class LegacyPreparedStatementTest
extends JdbcTestBase {
    private static final Matcher<String> PARAMETERS_NOT_SUPPORTED_MSG_MATCHER = CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"arameter"), (Matcher)CoreMatchers.containsString((String)"not"), (Matcher)CoreMatchers.containsString((String)"support"));
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        Driver.load();
        Properties properties = new Properties();
        properties.setProperty("server.preparedstatement.disabled", "true");
        connection = DriverManager.getConnection("jdbc:drill:zk=local", properties);
        Assert.assertTrue((boolean)((DrillConnection)connection).getConfig().isServerPreparedStatementDisabled());
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        if (connection != null) {
            try (Statement stmt = connection.createStatement();){
                stmt.execute(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
            }
        }
        connection.close();
    }

    @Test
    public void testExecuteQueryBasicCaseWorks() throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement("VALUES 11");
             ResultSet rs = stmt.executeQuery();){
            MatcherAssert.assertThat((String)"Unexpected column count", (Object)rs.getMetaData().getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)1));
            Assert.assertTrue((String)"No expected first row", (boolean)rs.next());
            MatcherAssert.assertThat((Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)11));
            Assert.assertFalse((String)"Unexpected second row", (boolean)rs.next());
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWhenNoParametersIndexSaysUnsupported() throws SQLException {
        try (PreparedStatement prepStmt = connection.prepareStatement("VALUES 1");){
            try {
                prepStmt.setBytes(4, null);
            }
            catch (SQLFeatureNotSupportedException e) {
                MatcherAssert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
                throw e;
            }
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testParamSettingWhenUnsupportedTypeSaysUnsupported() throws SQLException {
        try (PreparedStatement prepStmt = connection.prepareStatement("VALUES 1");){
            try {
                prepStmt.setClob(2, (Clob)null);
            }
            catch (SQLFeatureNotSupportedException e) {
                MatcherAssert.assertThat((String)"Check whether params.-unsupported wording changed or checks changed.", (Object)e.toString(), PARAMETERS_NOT_SUPPORTED_MSG_MATCHER);
                throw e;
            }
        }
    }
}

