/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Queues;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.jdbc.DrillStatement;
import org.apache.drill.jdbc.SchemaChangeListener;
import org.apache.drill.jdbc.SqlTimeoutException;
import org.apache.drill.jdbc.impl.AvaticaDrillSqlAccessor;
import org.apache.drill.jdbc.impl.DrillAccessorList;
import org.apache.drill.jdbc.impl.DrillColumnMetaDataList;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillPreparedStatementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillCursor
implements Cursor {
    private static final Logger logger = LoggerFactory.getLogger(DrillCursor.class);
    private static final String UNKNOWN_NAME_STRING = "";
    private final DrillConnectionImpl connection;
    private final AvaticaStatement statement;
    private final Meta.Signature signature;
    private final RecordBatchLoader currentBatchHolder;
    private final ResultsListener resultsListener;
    private SchemaChangeListener changeListener;
    private final DrillAccessorList accessors = new DrillAccessorList();
    private BatchSchema schema;
    private DrillColumnMetaDataList columnMetaDataList;
    private boolean initialSchemaLoaded;
    private boolean afterFirstBatch;
    private boolean returnTrueForNextCallToNext;
    private boolean afterLastRow;
    private int currentRowNumber = -1;
    private int currentRecordNumber = -1;
    private long timeoutInMilliseconds;
    private Stopwatch elapsedTimer;

    DrillCursor(DrillConnectionImpl connection, AvaticaStatement statement, Meta.Signature signature) throws SQLException {
        this.connection = connection;
        this.statement = statement;
        this.signature = signature;
        DrillClient client = connection.getClient();
        int batchQueueThrottlingThreshold = client.getConfig().getInt("drill.jdbc.batch_queue_throttling_threshold");
        this.resultsListener = new ResultsListener(this, batchQueueThrottlingThreshold);
        this.currentBatchHolder = new RecordBatchLoader(client.getAllocator());
        logger.debug("Setting timeout as {}", (Object)this.statement.getQueryTimeout());
        this.setTimeout(this.statement.getQueryTimeout());
    }

    protected int getCurrentRecordNumber() {
        return this.currentRecordNumber;
    }

    public String getQueryId() {
        if (this.resultsListener.getQueryId() != null) {
            return QueryIdHelper.getQueryId((UserBitShared.QueryId)this.resultsListener.getQueryId());
        }
        return null;
    }

    public boolean isBeforeFirst() {
        return this.currentRowNumber < 0;
    }

    public boolean isAfterLast() {
        return this.afterLastRow;
    }

    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        this.columnMetaDataList = (DrillColumnMetaDataList)types;
        return this.accessors;
    }

    synchronized void cleanup() {
        if (this.resultsListener.getQueryId() != null && !this.resultsListener.completed) {
            this.connection.getClient().cancelQuery(this.resultsListener.getQueryId());
        }
        this.resultsListener.close();
        this.currentBatchHolder.clear();
    }

    long getTimeoutInMilliseconds() {
        return this.timeoutInMilliseconds;
    }

    void setTimeout(int timeoutDurationInSeconds) {
        this.timeoutInMilliseconds = TimeUnit.SECONDS.toMillis(timeoutDurationInSeconds);
        if (this.timeoutInMilliseconds > 0L) {
            this.elapsedTimer = Stopwatch.createStarted();
        }
    }

    private void updateColumns() {
        this.accessors.generateAccessors(this, this.currentBatchHolder);
        ArrayList getObjectClasses = new ArrayList();
        for (int ax = 0; ax < this.accessors.size(); ++ax) {
            AvaticaDrillSqlAccessor accessor = this.accessors.get(ax);
            getObjectClasses.add(accessor.getObjectClass());
        }
        this.columnMetaDataList.updateColumnMetaData("DRILL", UNKNOWN_NAME_STRING, UNKNOWN_NAME_STRING, this.schema, getObjectClasses);
        if (this.changeListener != null) {
            this.changeListener.schemaChanged(this.schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextRowInternally() throws SQLException {
        if (this.currentRecordNumber + 1 < this.currentBatchHolder.getRecordCount()) {
            ++this.currentRecordNumber;
            return true;
        }
        try {
            boolean schemaChanged;
            QueryDataBatch qrb = this.resultsListener.getNext();
            if (this.afterFirstBatch) {
                while (qrb != null && qrb.getHeader().getRowCount() == 0 && qrb.getData() == null) {
                    logger.warn("Spurious batch read: {}", (Object)qrb);
                    qrb.release();
                    qrb = this.resultsListener.getNext();
                }
            }
            this.afterFirstBatch = true;
            if (qrb == null) {
                this.currentBatchHolder.clear();
                this.afterLastRow = true;
                return false;
            }
            this.currentRecordNumber = 0;
            if (qrb.getHeader().hasAffectedRowsCount()) {
                int updateCount = qrb.getHeader().getAffectedRowsCount();
                int currentUpdateCount = this.statement.getUpdateCount() == -1 ? 0 : this.statement.getUpdateCount();
                ((DrillStatement)this.statement).setUpdateCount(updateCount + currentUpdateCount);
                ((DrillStatement)this.statement).setResultSet(null);
            }
            try {
                schemaChanged = this.currentBatchHolder.load(qrb.getHeader().getDef(), qrb.getData());
            }
            finally {
                qrb.release();
            }
            this.schema = this.currentBatchHolder.getSchema();
            if (schemaChanged) {
                this.updateColumns();
            }
            if (this.returnTrueForNextCallToNext && this.currentBatchHolder.getRecordCount() == 0) {
                this.returnTrueForNextCallToNext = false;
            }
            return true;
        }
        catch (UserException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted.", e);
        }
        catch (RuntimeException e) {
            throw new SQLException("Unexpected RuntimeException: " + e.toString(), e);
        }
    }

    void loadInitialSchema() throws SQLException {
        UserProtos.PreparedStatement preparedStatement;
        if (this.initialSchemaLoaded) {
            throw new IllegalStateException("loadInitialSchema() called a second time");
        }
        assert (!this.afterLastRow) : "afterLastRow already true in loadInitialSchema()";
        assert (!this.afterFirstBatch) : "afterLastRow already true in loadInitialSchema()";
        assert (-1 == this.currentRecordNumber) : "currentRecordNumber not -1 (is " + this.currentRecordNumber + ") in loadInitialSchema()";
        assert (0 == this.currentBatchHolder.getRecordCount()) : "currentBatchHolder.getRecordCount() not 0 (is " + this.currentBatchHolder.getRecordCount() + " in loadInitialSchema()";
        if (this.statement instanceof DrillPreparedStatementImpl) {
            DrillPreparedStatementImpl drillPreparedStatement = (DrillPreparedStatementImpl)this.statement;
            preparedStatement = drillPreparedStatement.getPreparedStatementHandle();
        } else {
            preparedStatement = null;
        }
        if (preparedStatement != null) {
            this.connection.getClient().executePreparedStatement(preparedStatement.getServerHandle(), (UserResultsListener)this.resultsListener);
        } else {
            this.connection.getClient().runQuery(UserBitShared.QueryType.SQL, this.signature.sql, (UserResultsListener)this.resultsListener);
        }
        try {
            this.resultsListener.awaitFirstMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted", e);
        }
        this.returnTrueForNextCallToNext = true;
        this.nextRowInternally();
        this.initialSchemaLoaded = true;
    }

    public boolean next() throws SQLException {
        if (!this.initialSchemaLoaded) {
            throw new IllegalStateException("next() called but loadInitialSchema() was not called");
        }
        assert (this.afterFirstBatch) : "afterFirstBatch still false in next()";
        if (this.afterLastRow) {
            return false;
        }
        if (this.returnTrueForNextCallToNext) {
            ++this.currentRowNumber;
            this.returnTrueForNextCallToNext = false;
            return true;
        }
        this.accessors.clearLastColumnIndexedInRow();
        boolean res = this.nextRowInternally();
        if (res) {
            ++this.currentRowNumber;
        }
        return res;
    }

    public void cancel() {
        this.close();
    }

    public void close() {
        this.cleanup();
    }

    public boolean wasNull() throws SQLException {
        return this.accessors.wasNull();
    }

    public Stopwatch getElapsedTimer() {
        return this.elapsedTimer;
    }

    static class ResultsListener
    implements UserResultsListener {
        private static final Logger logger = LoggerFactory.getLogger(ResultsListener.class);
        private static volatile int nextInstanceId = 1;
        private final int instanceId;
        private final int batchQueueThrottlingThreshold;
        private volatile UserBitShared.QueryId queryId;
        private int lastReceivedBatchNumber;
        private int lastDequeuedBatchNumber;
        private volatile UserException executionFailureException;
        volatile boolean completed;
        private final AtomicBoolean throttled = new AtomicBoolean(false);
        private volatile ConnectionThrottle throttle;
        private volatile boolean closed;
        private final CountDownLatch firstMessageReceived = new CountDownLatch(1);
        final LinkedBlockingDeque<QueryDataBatch> batchQueue = Queues.newLinkedBlockingDeque();
        private final DrillCursor parent;
        Stopwatch elapsedTimer;

        ResultsListener(DrillCursor parent, int batchQueueThrottlingThreshold) {
            this.parent = parent;
            this.instanceId = nextInstanceId++;
            this.batchQueueThrottlingThreshold = batchQueueThrottlingThreshold;
            logger.debug("[#{}] Query listener created.", (Object)this.instanceId);
        }

        private boolean startThrottlingIfNot(ConnectionThrottle throttle) {
            boolean started = this.throttled.compareAndSet(false, true);
            if (started) {
                this.throttle = throttle;
                throttle.setAutoRead(false);
            }
            return started;
        }

        private boolean stopThrottlingIfSo() {
            boolean stopped = this.throttled.compareAndSet(true, false);
            if (stopped) {
                this.throttle.setAutoRead(true);
                this.throttle = null;
            }
            return stopped;
        }

        public void awaitFirstMessage() throws InterruptedException, SQLTimeoutException {
            if (this.parent.timeoutInMilliseconds > 0L) {
                long timeToTimeout = this.parent.timeoutInMilliseconds - this.parent.elapsedTimer.elapsed(TimeUnit.MILLISECONDS);
                if (timeToTimeout <= 0L || !this.firstMessageReceived.await(timeToTimeout, TimeUnit.MILLISECONDS)) {
                    throw new SqlTimeoutException(TimeUnit.MILLISECONDS.toSeconds(this.parent.timeoutInMilliseconds));
                }
            } else {
                this.firstMessageReceived.await();
            }
        }

        private void releaseIfFirst() {
            this.firstMessageReceived.countDown();
        }

        public void queryIdArrived(UserBitShared.QueryId queryId) {
            logger.debug("[#{}] Received query ID: {}.", (Object)this.instanceId, (Object)QueryIdHelper.getQueryId((UserBitShared.QueryId)queryId));
            this.queryId = queryId;
        }

        public void submissionFailed(UserException ex) {
            logger.debug("Received query failure: {} {}", (Object)this.instanceId, (Object)ex);
            this.executionFailureException = ex;
            this.completed = true;
            this.close();
            logger.info("[#{}] Query failed: ", (Object)this.instanceId, (Object)ex);
        }

        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            ++this.lastReceivedBatchNumber;
            logger.debug("[#{}] Received query data batch #{}: {}.", new Object[]{this.instanceId, this.lastReceivedBatchNumber, result});
            if (this.closed) {
                result.release();
                this.completed = true;
                return;
            }
            this.batchQueue.add(result);
            if (this.batchQueue.size() > this.batchQueueThrottlingThreshold && this.startThrottlingIfNot(throttle)) {
                logger.debug("[#{}] Throttling started at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            this.releaseIfFirst();
        }

        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            logger.debug("[#{}] Received query completion: {}.", (Object)this.instanceId, (Object)state);
            this.releaseIfFirst();
            this.completed = true;
        }

        UserBitShared.QueryId getQueryId() {
            return this.queryId;
        }

        QueryDataBatch getNext() throws UserException, InterruptedException, SQLTimeoutException {
            do {
                if (this.executionFailureException != null) {
                    logger.debug("[#{}] Dequeued query failure exception: {}.", (Object)this.instanceId, (Object)this.executionFailureException);
                    throw this.executionFailureException;
                }
                if (this.completed && this.batchQueue.isEmpty()) {
                    return null;
                }
                QueryDataBatch qdb = this.batchQueue.poll(50L, TimeUnit.MILLISECONDS);
                if (qdb == null) continue;
                ++this.lastDequeuedBatchNumber;
                logger.debug("[#{}] Dequeued query data batch #{}: {}.", new Object[]{this.instanceId, this.lastDequeuedBatchNumber, qdb});
                if ((this.batchQueue.size() < this.batchQueueThrottlingThreshold / 2 || this.batchQueue.size() == 0) && this.stopThrottlingIfSo()) {
                    logger.debug("[#{}] Throttling stopped at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
                }
                return qdb;
            } while (this.parent.timeoutInMilliseconds <= 0L || this.parent.elapsedTimer.elapsed(TimeUnit.MILLISECONDS) < this.parent.timeoutInMilliseconds);
            throw new SqlTimeoutException(TimeUnit.MILLISECONDS.toSeconds(this.parent.timeoutInMilliseconds));
        }

        void close() {
            logger.debug("[#{}] Query listener closing.", (Object)this.instanceId);
            this.closed = true;
            if (this.stopThrottlingIfSo()) {
                logger.debug("[#{}] Throttling stopped at close() (at queue size {}).", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            while (!this.batchQueue.isEmpty()) {
                QueryDataBatch qdb = this.batchQueue.poll();
                if (qdb == null || qdb.getData() == null) continue;
                qdb.getData().release();
            }
            this.firstMessageReceived.countDown();
            this.completed = true;
        }
    }
}

