/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class Drill2489CallsAfterCloseThrowExceptionsTest
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(Drill2489CallsAfterCloseThrowExceptionsTest.class);
    private static Connection closedConn;
    private static Connection openConn;
    private static Statement closedPlainStmtOfOpenConn;
    private static PreparedStatement closedPreparedStmtOfOpenConn;
    private static ResultSet closedResultSetOfClosedStmt;
    private static ResultSet closedResultSetOfOpenStmt;
    private static ResultSetMetaData resultSetMetaDataOfClosedResultSet;
    private static ResultSetMetaData resultSetMetaDataOfClosedStmt;
    private static DatabaseMetaData databaseMetaDataOfClosedConn;

    @BeforeClass
    public static void setUpClosedObjects() throws Exception {
        Connection connToClose = new Driver().connect("jdbc:drill:zk=local", Drill2489CallsAfterCloseThrowExceptionsTest.getDefaultProperties());
        Connection connToKeep = new Driver().connect("jdbc:drill:zk=local", Drill2489CallsAfterCloseThrowExceptionsTest.getDefaultProperties());
        Statement plainStmtToClose = connToKeep.createStatement();
        Statement plainStmtToKeep = connToKeep.createStatement();
        PreparedStatement preparedStmtToClose = connToKeep.prepareStatement("VALUES 'PreparedStatement query'");
        try {
            connToKeep.prepareCall("VALUES 'CallableStatement query'");
            Assert.fail((String)"Test seems to be out of date.  Was prepareCall(...) implemented?");
        }
        catch (UnsupportedOperationException | SQLException exception) {
            // empty catch block
        }
        ResultSet resultSetToCloseOnStmtToClose = plainStmtToClose.executeQuery("VALUES 'plain Statement query'");
        resultSetToCloseOnStmtToClose.next();
        ResultSet resultSetToCloseOnStmtToKeep = plainStmtToKeep.executeQuery("VALUES 'plain Statement query'");
        resultSetToCloseOnStmtToKeep.next();
        ResultSetMetaData rsmdForClosedStmt = resultSetToCloseOnStmtToKeep.getMetaData();
        ResultSetMetaData rsmdForOpenStmt = resultSetToCloseOnStmtToClose.getMetaData();
        DatabaseMetaData dbmd = connToClose.getMetaData();
        connToClose.close();
        plainStmtToClose.close();
        preparedStmtToClose.close();
        resultSetToCloseOnStmtToClose.close();
        resultSetToCloseOnStmtToKeep.close();
        closedConn = connToClose;
        openConn = connToKeep;
        closedPlainStmtOfOpenConn = plainStmtToClose;
        closedPreparedStmtOfOpenConn = preparedStmtToClose;
        closedResultSetOfClosedStmt = resultSetToCloseOnStmtToClose;
        closedResultSetOfOpenStmt = resultSetToCloseOnStmtToKeep;
        resultSetMetaDataOfClosedResultSet = rsmdForOpenStmt;
        resultSetMetaDataOfClosedStmt = rsmdForClosedStmt;
        databaseMetaDataOfClosedConn = dbmd;
        Assert.assertTrue((String)"Test setup error", (boolean)closedConn.isClosed());
        Assert.assertFalse((String)"Test setup error", (boolean)openConn.isClosed());
        Assert.assertTrue((String)"Test setup error", (boolean)closedPlainStmtOfOpenConn.isClosed());
        Assert.assertTrue((String)"Test setup error", (boolean)closedPreparedStmtOfOpenConn.isClosed());
        Assert.assertTrue((String)"Test setup error", (boolean)closedResultSetOfClosedStmt.isClosed());
        Assert.assertTrue((String)"Test setup error", (boolean)closedResultSetOfOpenStmt.isClosed());
        Assert.assertNotNull((String)"Test setup error", (Object)resultSetMetaDataOfClosedResultSet);
        Assert.assertNotNull((String)"Test setup error", (Object)resultSetMetaDataOfClosedStmt);
        Assert.assertNotNull((String)"Test setup error", (Object)databaseMetaDataOfClosedConn);
    }

    @AfterClass
    public static void tearDownConnection() throws Exception {
        openConn.close();
    }

    @Test
    public void testClosedConnection_close_doesNotThrow() throws SQLException {
        closedConn.close();
    }

    @Test
    public void testClosedConnection_isClosed_returnsTrue() throws SQLException {
        MatcherAssert.assertThat((Object)closedConn.isClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testClosedPlainStatement_close_doesNotThrow() throws SQLException {
        closedPlainStmtOfOpenConn.close();
    }

    @Test
    public void testClosedPlainStatement_isClosed_returnsTrue() throws SQLException {
        MatcherAssert.assertThat((Object)closedPlainStmtOfOpenConn.isClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testClosedPreparedStatement_close_doesNotThrow() throws SQLException {
        closedPreparedStmtOfOpenConn.close();
    }

    @Test
    public void testClosedPreparedStatement_isClosed_returnsTrue() throws SQLException {
        MatcherAssert.assertThat((Object)closedPreparedStmtOfOpenConn.isClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testClosedResultSet_close_doesNotThrow() throws SQLException {
        closedResultSetOfOpenStmt.close();
    }

    @Test
    public void testClosedResultSet_isClosed_returnsTrue() throws SQLException {
        MatcherAssert.assertThat((Object)closedResultSetOfOpenStmt.isClosed(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testClosedConnectionMethodsThrowRight() {
        ClosedConnectionChecker checker = new ClosedConnectionChecker(Connection.class, closedConn);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            System.err.println(checker.getReport());
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedPlainStatementMethodsThrowRight() {
        ClosedPlainStatementChecker checker = new ClosedPlainStatementChecker(Statement.class, closedPlainStmtOfOpenConn);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testclosedPreparedStmtOfOpenConnMethodsThrowRight() {
        ClosedPreparedStatementChecker checker = new ClosedPreparedStatementChecker(PreparedStatement.class, closedPreparedStmtOfOpenConn);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedResultSetMethodsThrowRight1() {
        ClosedResultSetChecker checker = new ClosedResultSetChecker(ResultSet.class, closedResultSetOfClosedStmt);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedResultSetMethodsThrowRight2() {
        ClosedResultSetChecker checker = new ClosedResultSetChecker(ResultSet.class, closedResultSetOfOpenStmt);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedResultSetMetaDataMethodsThrowRight1() {
        ClosedResultSetMetaDataChecker checker = new ClosedResultSetMetaDataChecker(ResultSetMetaData.class, resultSetMetaDataOfClosedResultSet);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedResultSetMetaDataMethodsThrowRight2() {
        ClosedResultSetMetaDataChecker checker = new ClosedResultSetMetaDataChecker(ResultSetMetaData.class, resultSetMetaDataOfClosedStmt);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testClosedDatabaseMetaDataMethodsThrowRight() {
        ClosedDatabaseMetaDataChecker checker = new ClosedDatabaseMetaDataChecker(DatabaseMetaData.class, databaseMetaDataOfClosedConn);
        checker.testAllMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Already-closed exception error(s): \n" + checker.getReport()));
        }
    }

    private static class ClosedDatabaseMetaDataChecker
    extends ThrowsClosedBulkChecker<DatabaseMetaData> {
        private static final String DATABASEMETADATA_CLOSED_MESSAGE = "DatabaseMetaData's Connection is already closed.";

        ClosedDatabaseMetaDataChecker(Class<DatabaseMetaData> intf, DatabaseMetaData jdbcObject) {
            super(intf, jdbcObject, DATABASEMETADATA_CLOSED_MESSAGE);
        }

        @Override
        protected boolean isOkayNonthrowingMethod(Method method) {
            return super.isOkayNonthrowingMethod(method) || method.getName().equals("getDriverMajorVersion") || method.getName().equals("getDriverMinorVersion") || method.getName().equals("getConnection") || method.getName().equals("getMaxLogicalLobSize") || method.getName().equals("supportsRefCursors") || method.getName().equals("supportsSharding");
        }

        @Override
        protected boolean isOkaySpecialCaseException(Method method, Throwable cause) {
            boolean result = super.isOkaySpecialCaseException(method, cause) ? true : RuntimeException.class == cause.getClass() && this.normalClosedExceptionText.equals(cause.getMessage()) && method.getName().equals("getResultSetHoldability");
            return result;
        }
    }

    private static class ClosedResultSetMetaDataChecker
    extends ThrowsClosedBulkChecker<ResultSetMetaData> {
        private static final String RESULTSETMETADATA_CLOSED_MESSAGE = "ResultSetMetaData's ResultSet is already closed.";

        ClosedResultSetMetaDataChecker(Class<ResultSetMetaData> intf, ResultSetMetaData jdbcObject) {
            super(intf, jdbcObject, RESULTSETMETADATA_CLOSED_MESSAGE);
        }
    }

    private static class ClosedResultSetChecker
    extends ThrowsClosedBulkChecker<ResultSet> {
        private static final String RESULTSET_CLOSED_MESSAGE = "ResultSet is already closed.";

        ClosedResultSetChecker(Class<ResultSet> intf, ResultSet jdbcObject) {
            super(intf, jdbcObject, RESULTSET_CLOSED_MESSAGE);
        }
    }

    private static class ClosedPreparedStatementChecker
    extends ThrowsClosedBulkChecker<PreparedStatement> {
        private static final String PREPAREDSTATEMENT_CLOSED_MESSAGE = "PreparedStatement is already closed.";

        ClosedPreparedStatementChecker(Class<PreparedStatement> intf, PreparedStatement jdbcObject) {
            super(intf, jdbcObject, PREPAREDSTATEMENT_CLOSED_MESSAGE);
        }

        @Override
        protected boolean isOkaySpecialCaseException(Method method, Throwable cause) {
            boolean result = super.isOkaySpecialCaseException(method, cause) ? true : NullPointerException.class == cause.getClass() && (method.getName().equals("enquoteIdentifier") || method.getName().equals("enquoteLiteral") || method.getName().equals("enquoteNCharLiteral") || method.getName().equals("isSimpleIdentifier"));
            return result;
        }
    }

    private static class ClosedPlainStatementChecker
    extends ThrowsClosedBulkChecker<Statement> {
        private static final String PLAIN_STATEMENT_CLOSED_MESSAGE = "Statement is already closed.";

        ClosedPlainStatementChecker(Class<Statement> intf, Statement jdbcObject) {
            super(intf, jdbcObject, PLAIN_STATEMENT_CLOSED_MESSAGE);
        }

        @Override
        protected boolean isOkaySpecialCaseException(Method method, Throwable cause) {
            boolean result = super.isOkaySpecialCaseException(method, cause) ? true : NullPointerException.class == cause.getClass() && (method.getName().equals("enquoteIdentifier") || method.getName().equals("enquoteLiteral") || method.getName().equals("enquoteNCharLiteral") || method.getName().equals("isSimpleIdentifier"));
            return result;
        }
    }

    private static class ClosedConnectionChecker
    extends ThrowsClosedBulkChecker<Connection> {
        private static final String STATEMENT_CLOSED_MESSAGE = "Connection is already closed.";

        ClosedConnectionChecker(Class<Connection> intf, Connection jdbcObject) {
            super(intf, jdbcObject, STATEMENT_CLOSED_MESSAGE);
        }

        @Override
        protected boolean isOkayNonthrowingMethod(Method method) {
            return super.isOkayNonthrowingMethod(method) || method.getName().equals("beginRequest") || method.getName().equals("endRequest");
        }

        @Override
        protected boolean isOkaySpecialCaseException(Method method, Throwable cause) {
            boolean result = super.isOkaySpecialCaseException(method, cause) ? true : (SQLClientInfoException.class == cause.getClass() && this.normalClosedExceptionText.equals(cause.getMessage()) && (method.getName().equals("setClientInfo") || method.getName().equals("getClientInfo")) ? true : SQLFeatureNotSupportedException.class == cause.getClass() && (method.getName().equals("setShardingKeyIfValid") || method.getName().equals("setShardingKey")));
            return result;
        }
    }

    private static abstract class ThrowsClosedBulkChecker<INTF> {
        private final Class<INTF> jdbcIntf;
        private final INTF jdbcObject;
        protected final String normalClosedExceptionText;
        private String methodLabel;
        private Object[] argsArray;
        private final StringBuilder failureLinesBuf = new StringBuilder();
        private final StringBuilder successLinesBuf = new StringBuilder();

        ThrowsClosedBulkChecker(Class<INTF> jdbcIntf, INTF jdbcObject, String normalClosedExceptionText) {
            this.jdbcIntf = jdbcIntf;
            this.jdbcObject = jdbcObject;
            this.normalClosedExceptionText = normalClosedExceptionText;
        }

        private static Object getDummyValueForType(Class<?> type) {
            Comparable<Boolean> result;
            if (!type.isPrimitive()) {
                result = null;
            } else if (type == Boolean.TYPE) {
                result = false;
            } else if (type == Byte.TYPE) {
                result = (byte)0;
            } else if (type == Short.TYPE) {
                result = (short)0;
            } else if (type == Character.TYPE) {
                result = Character.valueOf('\u0000');
            } else if (type == Integer.TYPE) {
                result = 0;
            } else if (type == Long.TYPE) {
                result = 0L;
            } else if (type == Float.TYPE) {
                result = Float.valueOf(0.0f);
            } else if (type == Double.TYPE) {
                result = 0.0;
            } else {
                Assert.fail((String)("Test needs to be updated to handle type " + type));
                result = null;
            }
            return result;
        }

        private void makeArgsAndLabel(Method method) {
            ArrayList<Object> argsList = new ArrayList<Object>();
            this.methodLabel = this.jdbcIntf.getSimpleName() + "." + method.getName() + "(";
            boolean first = true;
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!first) {
                    this.methodLabel = this.methodLabel + ", ";
                }
                first = false;
                this.methodLabel = this.methodLabel + paramType.getSimpleName();
                argsList.add(ThrowsClosedBulkChecker.getDummyValueForType(paramType));
            }
            this.methodLabel = this.methodLabel + ")";
            this.argsArray = argsList.toArray();
        }

        protected boolean isOkayNonthrowingMethod(Method method) {
            switch (method.getName()) {
                case "isClosed": 
                case "close": 
                case "isValid": {
                    return true;
                }
            }
            return false;
        }

        protected boolean isOkaySpecialCaseException(Method method, Throwable cause) {
            return false;
        }

        private void testOneMethod(Method method) {
            this.makeArgsAndLabel(method);
            logger.debug("Testing method " + this.methodLabel);
            try {
                method.invoke(this.jdbcObject, this.argsArray);
                String resultLine = "- " + this.methodLabel + " didn't throw\n";
                if (this.isOkayNonthrowingMethod(method)) {
                    this.successLinesBuf.append(resultLine);
                } else {
                    logger.trace("Failure: " + resultLine);
                    this.failureLinesBuf.append(resultLine);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String resultLine = "- " + this.methodLabel + " threw <" + cause + ">\n";
                if (AlreadyClosedSqlException.class == cause.getClass() && this.normalClosedExceptionText.equals(cause.getMessage())) {
                    this.successLinesBuf.append(resultLine);
                } else if (NullPointerException.class == cause.getClass() && (method.getName().equals("isWrapperFor") || method.getName().equals("unwrap"))) {
                    this.successLinesBuf.append(resultLine);
                } else if (this.isOkaySpecialCaseException(method, cause)) {
                    this.successLinesBuf.append(resultLine);
                } else {
                    String badResultLine = "- " + this.methodLabel + " threw <" + cause + "> instead of " + AlreadyClosedSqlException.class.getSimpleName() + " with \"" + this.normalClosedExceptionText.replaceAll("\"", "\"\"") + "\"\n";
                    logger.trace("Failure: " + resultLine);
                    this.failureLinesBuf.append(badResultLine);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Assert.fail((String)("Unexpected exception: " + e + ", cause = " + e.getCause() + "  from " + method));
            }
        }

        public void testAllMethods() {
            for (Method method : this.jdbcIntf.getMethods()) {
                this.testOneMethod(method);
            }
        }

        public boolean hadAnyFailures() {
            return 0 != this.failureLinesBuf.length();
        }

        public String getFailureLines() {
            return this.failureLinesBuf.toString();
        }

        public String getSuccessLines() {
            return this.successLinesBuf.toString();
        }

        public String getReport() {
            String report = "Failures:\n" + this.getFailureLines() + "(Successes:\n" + this.getSuccessLines() + ")";
            return report;
        }
    }
}

