/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.drill.jdbc.CachingConnectionFactory;
import org.apache.drill.jdbc.ConnectionFactory;
import org.apache.drill.jdbc.ConnectionInfo;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.NonClosableConnection;

public class SingleConnectionCachingFactory
implements CachingConnectionFactory {
    private final ConnectionFactory delegate;
    private Connection connection;

    public SingleConnectionCachingFactory(ConnectionFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Connection getConnection(ConnectionInfo info) throws SQLException {
        if (this.connection == null) {
            this.connection = this.delegate.getConnection(info);
        } else {
            JdbcTestBase.changeSchemaIfSupplied(this.connection, info.getParamsAsProperties());
        }
        return new NonClosableConnection(this.connection);
    }

    @Override
    public void closeConnections() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }
}

