/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.test.TestTools;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTestActionBase
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTestActionBase.class);
    static Connection connection;
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)40000);

    @BeforeClass
    public static void openClient() throws Exception {
        connection = JdbcTestActionBase.connect();
    }

    @AfterClass
    public static void closeClient() throws IOException, SQLException {
        connection.close();
    }

    protected void testAction(JdbcAction action) throws Exception {
        this.testAction(action, -1L);
    }

    protected void testAction(JdbcAction action, long rowcount) throws Exception {
        StringBuilder sb = new StringBuilder();
        int rows = 0;
        Stopwatch watch = Stopwatch.createStarted();
        ResultSet r = action.getResult(connection);
        boolean first = true;
        while (r.next()) {
            int i;
            ++rows;
            ResultSetMetaData md = r.getMetaData();
            if (first) {
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    sb.append(md.getColumnName(i));
                    sb.append('\t');
                }
                sb.append('\n');
                first = false;
            }
            for (i = 1; i <= md.getColumnCount(); ++i) {
                sb.append(r.getObject(i));
                sb.append('\t');
            }
            sb.append('\n');
        }
        sb.append(String.format("Query completed in %d millis.\n", watch.elapsed(TimeUnit.MILLISECONDS)));
        if (rowcount != -1L) {
            Assert.assertEquals((long)rowcount, (long)rows);
        }
        sb.append("\n\n\n");
        logger.info(sb.toString());
    }

    static {
        Driver.load();
    }

    public static interface JdbcAction {
        public ResultSet getResult(Connection var1) throws SQLException;
    }
}

