/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.test.JdbcTestActionBase;
import org.apache.drill.test.TestTools;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={JdbcTest.class})
public class TestJdbcMetadata
extends JdbcTestActionBase {
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)120000);

    @Test
    public void catalogs() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getCatalogs();
            }
        }, 1L);
    }

    @Test
    public void allSchemas() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getSchemas();
            }
        });
    }

    @Test
    public void schemasWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getSchemas("DRILL", "%fs%");
            }
        }, 3L);
    }

    @Test
    public void allTables() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getTables(null, null, null, null);
            }
        });
    }

    @Test
    public void tablesWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getTables("DRILL", "sys", "opt%", new String[]{"SYSTEM_TABLE", "SYSTEM_VIEW"});
            }
        }, 2L);
    }

    @Test
    public void allColumns() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getColumns(null, null, null, null);
            }
        });
    }

    @Test
    public void columnsWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getColumns("DRILL", "sys", "opt%", "%ame");
            }
        }, 2L);
    }
}

