/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.server.SessionTracker;
import oadd.org.apache.zookeeper.server.SessionTrackerImpl;
import oadd.org.apache.zookeeper.server.ZooKeeperServerListener;
import oadd.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSessionTracker
extends UpgradeableSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSessionTracker.class);
    private final SessionTracker.SessionExpirer expirer;
    private final AtomicReference<Map<Long, Integer>> touchTable = new AtomicReference();
    private final long serverId;
    private final AtomicLong nextSessionId = new AtomicLong();
    private final ConcurrentMap<Long, Integer> globalSessionsWithTimeouts;

    public LearnerSessionTracker(SessionTracker.SessionExpirer expirer, ConcurrentMap<Long, Integer> sessionsWithTimeouts, int tickTime, long id, boolean localSessionsEnabled, ZooKeeperServerListener listener) {
        this.expirer = expirer;
        this.touchTable.set(new ConcurrentHashMap());
        this.globalSessionsWithTimeouts = sessionsWithTimeouts;
        this.serverId = id;
        this.nextSessionId.set(SessionTrackerImpl.initializeNextSessionId(this.serverId));
        this.localSessionsEnabled = localSessionsEnabled;
        if (this.localSessionsEnabled) {
            this.createLocalSessionTracker(expirer, tickTime, id, listener);
        }
    }

    @Override
    public void removeSession(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.removeSession(sessionId);
        }
        this.globalSessionsWithTimeouts.remove(sessionId);
        this.touchTable.get().remove(sessionId);
    }

    @Override
    public void start() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.shutdown();
        }
    }

    @Override
    public boolean isGlobalSession(long sessionId) {
        return this.globalSessionsWithTimeouts.containsKey(sessionId);
    }

    @Override
    public boolean trackSession(long sessionId, int sessionTimeout) {
        return false;
    }

    @Override
    public synchronized boolean commitSession(long sessionId, int sessionTimeout) {
        boolean added;
        boolean bl = added = this.globalSessionsWithTimeouts.put(sessionId, sessionTimeout) == null;
        if (added) {
            LOG.info("Committing global session 0x{}", (Object)Long.toHexString(sessionId));
        }
        if (this.localSessionsEnabled) {
            this.removeLocalSession(sessionId);
            this.finishedUpgrading(sessionId);
        }
        this.touchTable.get().put(sessionId, sessionTimeout);
        return added;
    }

    @Override
    public boolean touchSession(long sessionId, int sessionTimeout) {
        if (this.localSessionsEnabled) {
            if (this.localSessionTracker.touchSession(sessionId, sessionTimeout)) {
                return true;
            }
            if (!this.isGlobalSession(sessionId) && !this.isUpgradingSession(sessionId)) {
                return false;
            }
        }
        this.touchTable.get().put(sessionId, sessionTimeout);
        return true;
    }

    public Map<Long, Integer> snapshot() {
        return this.touchTable.getAndSet(new ConcurrentHashMap());
    }

    @Override
    public long createSession(int sessionTimeout) {
        if (this.localSessionsEnabled) {
            return this.localSessionTracker.createSession(sessionTimeout);
        }
        return this.nextSessionId.getAndIncrement();
    }

    @Override
    public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.checkSession(sessionId, owner);
                    return;
                }
                catch (KeeperException.UnknownSessionException e) {
                    if (this.isGlobalSession(sessionId)) break block3;
                    throw new KeeperException.SessionExpiredException();
                }
            }
        }
    }

    @Override
    public void setOwner(long sessionId, Object owner) throws KeeperException.SessionExpiredException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.setOwner(sessionId, owner);
                    return;
                }
                catch (KeeperException.SessionExpiredException e) {
                    if (this.isGlobalSession(sessionId)) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public void dumpSessions(PrintWriter pwriter) {
        if (this.localSessionTracker != null) {
            pwriter.print("Local ");
            this.localSessionTracker.dumpSessions(pwriter);
        }
        pwriter.print("Global Sessions(");
        pwriter.print(this.globalSessionsWithTimeouts.size());
        pwriter.println("):");
        TreeSet sessionIds = new TreeSet(this.globalSessionsWithTimeouts.keySet());
        Iterator iterator = sessionIds.iterator();
        while (iterator.hasNext()) {
            long sessionId = (Long)iterator.next();
            pwriter.print("0x");
            pwriter.print(Long.toHexString(sessionId));
            pwriter.print("\t");
            pwriter.print(this.globalSessionsWithTimeouts.get(sessionId));
            pwriter.println("ms");
        }
    }

    @Override
    public void setSessionClosing(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.setSessionClosing(sessionId);
        }
    }

    @Override
    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return new HashMap<Long, Set<Long>>();
    }

    @Override
    public Set<Long> globalSessions() {
        return this.globalSessionsWithTimeouts.keySet();
    }
}

