/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server;

import java.net.InetSocketAddress;
import oadd.org.apache.zookeeper.server.ZooKeeperServer;
import oadd.org.apache.zookeeper.server.ZooKeeperServerBean;
import oadd.org.apache.zookeeper.server.quorum.Observer;
import oadd.org.apache.zookeeper.server.quorum.ObserverMXBean;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeer;

public class ObserverBean
extends ZooKeeperServerBean
implements ObserverMXBean {
    private Observer observer;

    public ObserverBean(Observer observer, ZooKeeperServer zks) {
        super(zks);
        this.observer = observer;
    }

    @Override
    public String getName() {
        return "Observer";
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.observer.getPendingRevalidationsCount();
    }

    @Override
    public String getQuorumAddress() {
        return this.observer.getSocket().toString();
    }

    @Override
    public String getLearnerMaster() {
        QuorumPeer.QuorumServer learnerMaster = this.observer.getCurrentLearnerMaster();
        if (learnerMaster == null || learnerMaster.addr.isEmpty()) {
            return "Unknown";
        }
        InetSocketAddress address = learnerMaster.addr.getReachableOrOne();
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    @Override
    public void setLearnerMaster(String learnerMaster) {
        if (!this.observer.setLearnerMaster(learnerMaster)) {
            throw new IllegalArgumentException("Not a valid learner master");
        }
    }
}

