/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.cli;

import oadd.org.apache.commons.cli.CommandLine;
import oadd.org.apache.commons.cli.DefaultParser;
import oadd.org.apache.commons.cli.Options;
import oadd.org.apache.commons.cli.ParseException;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.cli.CliCommand;
import oadd.org.apache.zookeeper.cli.CliException;
import oadd.org.apache.zookeeper.cli.CliParseException;
import oadd.org.apache.zookeeper.cli.CliWrapperException;
import oadd.org.apache.zookeeper.cli.MalformedCommandException;
import oadd.org.apache.zookeeper.cli.MalformedPathException;

public class GetAllChildrenNumberCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetAllChildrenNumberCommand() {
        super("getAllChildrenNumber", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        try {
            String path = this.args[1];
            int allChildrenNumber = this.zk.getAllChildrenNumber(path);
            this.out.println(allChildrenNumber);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

