/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.zookeeper.ClientWatchManager;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.server.watch.PathParentIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKWatchManager
implements ClientWatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZKWatchManager.class);
    private final Map<String, Set<Watcher>> dataWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> existWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> childWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> persistentWatches = new HashMap<String, Set<Watcher>>();
    private final Map<String, Set<Watcher>> persistentRecursiveWatches = new HashMap<String, Set<Watcher>>();
    private final boolean disableAutoWatchReset;
    private volatile Watcher defaultWatcher;

    ZKWatchManager(boolean disableAutoWatchReset, Watcher defaultWatcher) {
        this.disableAutoWatchReset = disableAutoWatchReset;
        this.defaultWatcher = defaultWatcher;
    }

    void setDefaultWatcher(Watcher defaultWatcher) {
        this.defaultWatcher = defaultWatcher;
    }

    Watcher getDefaultWatcher() {
        return this.defaultWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getDataWatchList() {
        Map<String, Set<Watcher>> map = this.dataWatches;
        synchronized (map) {
            return new ArrayList<String>(this.dataWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getChildWatchList() {
        Map<String, Set<Watcher>> map = this.childWatches;
        synchronized (map) {
            return new ArrayList<String>(this.childWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getExistWatchList() {
        Map<String, Set<Watcher>> map = this.existWatches;
        synchronized (map) {
            return new ArrayList<String>(this.existWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPersistentWatchList() {
        Map<String, Set<Watcher>> map = this.persistentWatches;
        synchronized (map) {
            return new ArrayList<String>(this.persistentWatches.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPersistentRecursiveWatchList() {
        Map<String, Set<Watcher>> map = this.persistentRecursiveWatches;
        synchronized (map) {
            return new ArrayList<String>(this.persistentRecursiveWatches.keySet());
        }
    }

    Map<String, Set<Watcher>> getDataWatches() {
        return this.dataWatches;
    }

    Map<String, Set<Watcher>> getExistWatches() {
        return this.existWatches;
    }

    Map<String, Set<Watcher>> getChildWatches() {
        return this.childWatches;
    }

    Map<String, Set<Watcher>> getPersistentWatches() {
        return this.persistentWatches;
    }

    Map<String, Set<Watcher>> getPersistentRecursiveWatches() {
        return this.persistentRecursiveWatches;
    }

    private void addTo(Set<Watcher> from, Set<Watcher> to) {
        if (from != null) {
            to.addAll(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Watcher.Event.EventType, Set<Watcher>> removeWatcher(String clientPath, Watcher watcher, Watcher.WatcherType watcherType, boolean local, int rc) throws KeeperException {
        this.containsWatcher(clientPath, watcher, watcherType);
        HashMap<Watcher.Event.EventType, Set<Watcher>> removedWatchers = new HashMap<Watcher.Event.EventType, Set<Watcher>>();
        HashSet<Watcher> childWatchersToRem = new HashSet<Watcher>();
        removedWatchers.put(Watcher.Event.EventType.ChildWatchRemoved, childWatchersToRem);
        HashSet<Watcher> dataWatchersToRem = new HashSet<Watcher>();
        removedWatchers.put(Watcher.Event.EventType.DataWatchRemoved, dataWatchersToRem);
        HashSet<Watcher> persistentWatchersToRem = new HashSet<Watcher>();
        removedWatchers.put(Watcher.Event.EventType.PersistentWatchRemoved, persistentWatchersToRem);
        boolean removedWatcher = false;
        switch (watcherType) {
            case Children: {
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    removedWatcher = this.removeWatches(this.childWatches, watcher, clientPath, local, rc, childWatchersToRem);
                    break;
                }
            }
            case Data: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    removedWatcher = this.removeWatches(this.dataWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                }
                map = this.existWatches;
                synchronized (map) {
                    boolean removedDataWatcher = this.removeWatches(this.existWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                    removedWatcher |= removedDataWatcher;
                    break;
                }
            }
            case Any: {
                boolean removedDataWatcher;
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    removedWatcher = this.removeWatches(this.childWatches, watcher, clientPath, local, rc, childWatchersToRem);
                }
                map = this.dataWatches;
                synchronized (map) {
                    removedDataWatcher = this.removeWatches(this.dataWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                    removedWatcher |= removedDataWatcher;
                }
                map = this.existWatches;
                synchronized (map) {
                    removedDataWatcher = this.removeWatches(this.existWatches, watcher, clientPath, local, rc, dataWatchersToRem);
                    removedWatcher |= removedDataWatcher;
                }
                map = this.persistentWatches;
                synchronized (map) {
                    boolean removedPersistentWatcher = this.removeWatches(this.persistentWatches, watcher, clientPath, local, rc, persistentWatchersToRem);
                    removedWatcher |= removedPersistentWatcher;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    boolean removedPersistentRecursiveWatcher = this.removeWatches(this.persistentRecursiveWatches, watcher, clientPath, local, rc, persistentWatchersToRem);
                    removedWatcher |= removedPersistentRecursiveWatcher;
                    break;
                }
            }
        }
        if (!removedWatcher) {
            throw new KeeperException.NoWatcherException(clientPath);
        }
        return removedWatchers;
    }

    private boolean contains(String path, Watcher watcherObj, Map<String, Set<Watcher>> pathVsWatchers) {
        Set<Watcher> watchers;
        boolean watcherExists = true;
        watcherExists = pathVsWatchers == null || pathVsWatchers.size() == 0 ? false : ((watchers = pathVsWatchers.get(path)) == null ? false : (watcherObj == null ? watchers.size() > 0 : watchers.contains(watcherObj)));
        return watcherExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containsWatcher(String path, Watcher watcher, Watcher.WatcherType watcherType) throws KeeperException.NoWatcherException {
        boolean containsWatcher = false;
        switch (watcherType) {
            case Children: {
                boolean contains_temp;
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    containsWatcher = this.contains(path, watcher, this.childWatches);
                }
                map = this.persistentWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentRecursiveWatches);
                    containsWatcher |= contains_temp;
                    break;
                }
            }
            case Data: {
                boolean contains_temp;
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    containsWatcher = this.contains(path, watcher, this.dataWatches);
                }
                map = this.existWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.existWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.persistentWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentRecursiveWatches);
                    containsWatcher |= contains_temp;
                    break;
                }
            }
            case Any: {
                boolean contains_temp;
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    containsWatcher = this.contains(path, watcher, this.childWatches);
                }
                map = this.dataWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.dataWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.existWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.existWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.persistentWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentWatches);
                    containsWatcher |= contains_temp;
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    contains_temp = this.contains(path, watcher, this.persistentRecursiveWatches);
                    containsWatcher |= contains_temp;
                    break;
                }
            }
        }
        if (!containsWatcher) {
            throw new KeeperException.NoWatcherException(path);
        }
    }

    protected boolean removeWatches(Map<String, Set<Watcher>> pathVsWatcher, Watcher watcher, String path, boolean local, int rc, Set<Watcher> removedWatchers) throws KeeperException {
        if (!local && rc != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create(KeeperException.Code.get(rc), path);
        }
        boolean success = false;
        if (rc == KeeperException.Code.OK.intValue() || local && rc != KeeperException.Code.OK.intValue()) {
            if (watcher == null) {
                Set<Watcher> pathWatchers = pathVsWatcher.remove(path);
                if (pathWatchers != null) {
                    removedWatchers.addAll(pathWatchers);
                    success = true;
                }
            } else {
                Set<Watcher> watchers = pathVsWatcher.get(path);
                if (watchers != null && watchers.remove(watcher)) {
                    removedWatchers.add(watcher);
                    if (watchers.size() <= 0) {
                        pathVsWatcher.remove(path);
                    }
                    success = true;
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Watcher> materialize(Watcher.Event.KeeperState state, Watcher.Event.EventType type, String clientPath) {
        HashSet<Watcher> result = new HashSet<Watcher>();
        switch (type) {
            case None: {
                if (this.defaultWatcher != null) {
                    result.add(this.defaultWatcher);
                }
                boolean clear = this.disableAutoWatchReset && state != Watcher.Event.KeeperState.SyncConnected;
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    for (Set<Watcher> ws : this.dataWatches.values()) {
                        result.addAll(ws);
                    }
                    if (clear) {
                        this.dataWatches.clear();
                    }
                }
                map = this.existWatches;
                synchronized (map) {
                    for (Set<Watcher> ws : this.existWatches.values()) {
                        result.addAll(ws);
                    }
                    if (clear) {
                        this.existWatches.clear();
                    }
                }
                map = this.childWatches;
                synchronized (map) {
                    for (Set<Watcher> ws : this.childWatches.values()) {
                        result.addAll(ws);
                    }
                    if (clear) {
                        this.childWatches.clear();
                    }
                }
                map = this.persistentWatches;
                synchronized (map) {
                    for (Set<Watcher> ws : this.persistentWatches.values()) {
                        result.addAll(ws);
                    }
                }
                map = this.persistentRecursiveWatches;
                synchronized (map) {
                    for (Set<Watcher> ws : this.persistentRecursiveWatches.values()) {
                        result.addAll(ws);
                    }
                }
                return result;
            }
            case NodeDataChanged: 
            case NodeCreated: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    this.addTo(this.dataWatches.remove(clientPath), result);
                }
                map = this.existWatches;
                synchronized (map) {
                    this.addTo(this.existWatches.remove(clientPath), result);
                }
                this.addPersistentWatches(clientPath, result);
                break;
            }
            case NodeChildrenChanged: {
                Map<String, Set<Watcher>> map = this.childWatches;
                synchronized (map) {
                    this.addTo(this.childWatches.remove(clientPath), result);
                }
                this.addPersistentWatches(clientPath, result);
                break;
            }
            case NodeDeleted: {
                Map<String, Set<Watcher>> map = this.dataWatches;
                synchronized (map) {
                    this.addTo(this.dataWatches.remove(clientPath), result);
                }
                map = this.existWatches;
                synchronized (map) {
                    Set<Watcher> list = this.existWatches.remove(clientPath);
                    if (list != null) {
                        this.addTo(list, result);
                        LOG.warn("We are triggering an exists watch for delete! Shouldn't happen!");
                    }
                }
                map = this.childWatches;
                synchronized (map) {
                    this.addTo(this.childWatches.remove(clientPath), result);
                }
                this.addPersistentWatches(clientPath, result);
                break;
            }
            default: {
                String errorMsg = String.format("Unhandled watch event type %s with state %s on path %s", new Object[]{type, state, clientPath});
                LOG.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistentWatches(String clientPath, Set<Watcher> result) {
        Map<String, Set<Watcher>> map = this.persistentWatches;
        synchronized (map) {
            this.addTo(this.persistentWatches.get(clientPath), result);
        }
        map = this.persistentRecursiveWatches;
        synchronized (map) {
            for (String path : PathParentIterator.forAll(clientPath).asIterable()) {
                this.addTo(this.persistentRecursiveWatches.get(path), result);
            }
        }
    }
}

