/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.log4j.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oadd.org.apache.log4j.helpers.PatternConverter;
import oadd.org.apache.log4j.helpers.PatternParser;
import oadd.org.apache.log4j.spi.LoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcPatternParser {
    private static final String QUESTION_MARK = "?";
    private static final char PERCENT_CHAR = '%';
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("'((?>[^']|'')+)'");
    private String parameterizedSql;
    private final List<String> patternStringRepresentationList = new ArrayList<String>();
    private final List<PatternConverter> args = new ArrayList<PatternConverter>();

    JdbcPatternParser(String insertString) {
        this.init(insertString);
    }

    public String getParameterizedSql() {
        return this.parameterizedSql;
    }

    public List<String> getUnmodifiablePatternStringRepresentationList() {
        return Collections.unmodifiableList(this.patternStringRepresentationList);
    }

    public String toString() {
        return "JdbcPatternParser{sql=" + this.parameterizedSql + ",args=" + this.patternStringRepresentationList + "}";
    }

    private void init(String insertString) {
        if (insertString == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        Matcher m3 = STRING_LITERAL_PATTERN.matcher(insertString);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            String matchedStr = m3.group(1);
            if (matchedStr.indexOf(37) == -1) {
                this.replaceWithMatchedStr(m3, sb);
                continue;
            }
            this.replaceWithBind(m3, sb, matchedStr);
        }
        m3.appendTail(sb);
        this.parameterizedSql = sb.toString();
    }

    private void replaceWithMatchedStr(Matcher m3, StringBuffer sb) {
        m3.appendReplacement(sb, "'$1'");
    }

    private void replaceWithBind(Matcher m3, StringBuffer sb, String matchedStr) {
        m3.appendReplacement(sb, QUESTION_MARK);
        matchedStr = matchedStr.replaceAll("''", "'");
        this.patternStringRepresentationList.add(matchedStr);
        this.args.add(new PatternParser(matchedStr).parse());
    }

    public void setParameters(PreparedStatement ps, LoggingEvent logEvent) throws SQLException {
        for (int i = 0; i < this.args.size(); ++i) {
            PatternConverter head = this.args.get(i);
            String value = this.buildValueStr(logEvent, head);
            ps.setString(i + 1, value);
        }
    }

    private String buildValueStr(LoggingEvent logEvent, PatternConverter head) {
        StringBuffer buffer = new StringBuffer();
        PatternConverter c = head;
        while (c != null) {
            c.format(buffer, logEvent);
            c = c.next;
        }
        return buffer.toString();
    }
}

