/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.resolver;

import java.util.ArrayList;
import java.util.List;
import oadd.com.google.common.collect.Lists;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.fn.DrillFuncHolder;
import oadd.org.apache.drill.exec.resolver.FunctionResolver;
import oadd.org.apache.drill.exec.resolver.TypeCastRules;

public class ExactFunctionResolver
implements FunctionResolver {
    @Override
    public DrillFuncHolder getBestMatch(List<DrillFuncHolder> methods, FunctionCall call) {
        ArrayList<TypeProtos.MajorType> argumentTypes = Lists.newArrayList();
        for (LogicalExpression expression : call.args()) {
            argumentTypes.add(expression.getMajorType());
        }
        for (DrillFuncHolder h2 : methods) {
            float currCost = TypeCastRules.getCost(argumentTypes, h2);
            if (currCost != 0.0f) continue;
            return h2;
        }
        return null;
    }
}

