/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.List;
import oadd.com.google.common.base.Preconditions;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.RecordBatchSizer;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.vector.ValueVector;

public class RecordBatchMemoryManager {
    protected static final int MAX_NUM_ROWS = 65535;
    protected static final int MIN_NUM_ROWS = 1;
    protected static final int DEFAULT_INPUT_INDEX = 0;
    private int outputRowCount = 65535;
    private int currentOutgoingMaxRowCount = 65535;
    private int outgoingRowWidth;
    private final int outputBatchSize;
    private final RecordBatchSizer[] sizer;
    private final BatchStats[] inputBatchStats;
    private final BatchStats outputBatchStats;
    private int numInputs = 1;

    public long getNumOutgoingBatches() {
        return this.outputBatchStats.getNumBatches();
    }

    public long getTotalOutputRecords() {
        return this.outputBatchStats.getTotalRecords();
    }

    public long getAvgOutputBatchSize() {
        return this.outputBatchStats.getAvgBatchSize();
    }

    public long getAvgOutputRowWidth() {
        return this.outputBatchStats.getAvgRowWidth();
    }

    public long getNumIncomingBatches() {
        return this.inputBatchStats[0] == null ? 0L : this.inputBatchStats[0].getNumBatches();
    }

    public long getAvgInputBatchSize() {
        return this.inputBatchStats[0] == null ? 0L : this.inputBatchStats[0].getAvgBatchSize();
    }

    public long getAvgInputRowWidth() {
        return this.inputBatchStats[0] == null ? 0L : this.inputBatchStats[0].getAvgRowWidth();
    }

    public long getTotalInputRecords() {
        return this.inputBatchStats[0] == null ? 0L : this.inputBatchStats[0].getTotalRecords();
    }

    public long getNumIncomingBatches(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.inputBatchStats[index] == null ? 0L : this.inputBatchStats[index].getNumBatches();
    }

    public long getAvgInputBatchSize(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.inputBatchStats[index] == null ? 0L : this.inputBatchStats[index].getAvgBatchSize();
    }

    public long getAvgInputRowWidth(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.inputBatchStats[index] == null ? 0L : this.inputBatchStats[index].getAvgRowWidth();
    }

    public long getTotalInputRecords(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.inputBatchStats[index] == null ? 0L : this.inputBatchStats[index].getTotalRecords();
    }

    public RecordBatchMemoryManager(int numInputs, int configuredOutputSize) {
        this.numInputs = numInputs;
        this.outputBatchSize = configuredOutputSize;
        this.sizer = new RecordBatchSizer[numInputs];
        this.inputBatchStats = new BatchStats[numInputs];
        this.outputBatchStats = new BatchStats();
    }

    public RecordBatchMemoryManager(int configuredOutputSize) {
        this.outputBatchSize = configuredOutputSize;
        this.sizer = new RecordBatchSizer[this.numInputs];
        this.inputBatchStats = new BatchStats[this.numInputs];
        this.outputBatchStats = new BatchStats();
    }

    public void update(int inputIndex) {
    }

    public void update() {
    }

    public void update(RecordBatch recordBatch) {
    }

    public void update(RecordBatch recordBatch, int index) {
        this.setRecordBatchSizer(index, new RecordBatchSizer(recordBatch));
        this.setOutgoingRowWidth(this.getRecordBatchSizer(index).getNetRowWidth());
        this.setOutputRowCount(this.getOutputBatchSize(), this.getRecordBatchSizer(index).getNetRowWidth());
        this.updateIncomingStats(index);
    }

    public void update(int inputIndex, int outputPosition, boolean useAggregate) {
        throw new IllegalStateException("Should only be called on JoinBatchMemoryManager");
    }

    public void update(int inputIndex, int outputPosition) {
        throw new IllegalStateException("Should only be called on JoinBatchMemoryManager");
    }

    public void update(RecordBatch batch, int inputIndex, int outputPosition) {
        throw new IllegalStateException("Should only be called on JoinBatchMemoryManager");
    }

    public void update(RecordBatch batch, int inputIndex, int outputPosition, boolean useAggregate) {
        throw new IllegalStateException("Should only be called on JoinBatchMemoryManager");
    }

    public boolean updateIfNeeded(int newOutgoingRowWidth) {
        if (newOutgoingRowWidth == this.outgoingRowWidth || RecordBatchMemoryManager.computeOutputRowCount(this.outputBatchSize, newOutgoingRowWidth) == RecordBatchMemoryManager.computeOutputRowCount(this.outputBatchSize, this.outgoingRowWidth)) {
            return false;
        }
        this.setOutputRowCount(this.outputBatchSize, newOutgoingRowWidth);
        this.setOutgoingRowWidth(newOutgoingRowWidth);
        return true;
    }

    public int getOutputRowCount() {
        return this.outputRowCount;
    }

    public int getCurrentOutgoingMaxRowCount() {
        return this.currentOutgoingMaxRowCount;
    }

    public void setOutputRowCount(int targetBatchSize, int rowWidth) {
        this.outputRowCount = RecordBatchMemoryManager.adjustOutputRowCount(RecordBatchSizer.safeDivide(targetBatchSize, rowWidth));
    }

    public void setOutputRowCount(int outputRowCount) {
        Preconditions.checkArgument(outputRowCount <= 65535);
        this.outputRowCount = outputRowCount;
    }

    public void setCurrentOutgoingMaxRowCount(int newTargetOutputCount) {
        this.currentOutgoingMaxRowCount = Math.min(65535, newTargetOutputCount);
    }

    public static int adjustOutputRowCount(int rowCount) {
        return Math.min(65535, Math.max(Integer.highestOneBit(rowCount) - 1, 1));
    }

    public static int computeOutputRowCount(int batchSize, int rowWidth) {
        return RecordBatchMemoryManager.adjustOutputRowCount(RecordBatchSizer.safeDivide(batchSize, rowWidth));
    }

    public void setOutgoingRowWidth(int outgoingRowWidth) {
        this.outgoingRowWidth = outgoingRowWidth;
    }

    public int getOutgoingRowWidth() {
        return this.outgoingRowWidth;
    }

    public void setRecordBatchSizer(int index, RecordBatchSizer sizer) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        this.sizer[index] = sizer;
        if (this.inputBatchStats[index] == null) {
            this.inputBatchStats[index] = new BatchStats();
        }
    }

    public void setRecordBatchSizer(RecordBatchSizer sizer) {
        this.setRecordBatchSizer(0, sizer);
    }

    public RecordBatchSizer getRecordBatchSizer(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.sizer[index];
    }

    public RecordBatchSizer getRecordBatchSizer() {
        return this.sizer[0];
    }

    public RecordBatchSizer.ColumnSize getColumnSize(int index, String name) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        return this.sizer[index].getColumn(name);
    }

    public RecordBatchSizer.ColumnSize getColumnSize(String name) {
        for (int index = 0; index < this.numInputs; ++index) {
            if (this.sizer[index] == null || this.sizer[index].getColumn(name) == null) continue;
            return this.sizer[index].getColumn(name);
        }
        return null;
    }

    public void updateIncomingStats(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.numInputs);
        Preconditions.checkArgument(this.inputBatchStats[index] != null);
        this.inputBatchStats[index].incNumBatches();
        this.inputBatchStats[index].incSumBatchSizes(this.sizer[index].getNetBatchSize());
        this.inputBatchStats[index].incTotalRecords(this.sizer[index].rowCount());
    }

    public void updateIncomingStats() {
        this.inputBatchStats[0].incNumBatches();
        this.inputBatchStats[0].incSumBatchSizes(this.sizer[0].getNetBatchSize());
        this.inputBatchStats[0].incTotalRecords(this.sizer[0].rowCount());
    }

    public void updateOutgoingStats(int outputRecords) {
        this.outputBatchStats.incNumBatches();
        this.outputBatchStats.incTotalRecords(outputRecords);
        this.outputBatchStats.incSumBatchSizes(this.outgoingRowWidth * outputRecords);
    }

    public int getOutputBatchSize() {
        return this.outputBatchSize;
    }

    public int getOffsetVectorWidth() {
        return 4;
    }

    public void allocateVectors(VectorContainer container, int recordCount) {
        for (VectorWrapper<?> w : container) {
            RecordBatchSizer.ColumnSize colSize = this.getColumnSize(w.getField().getName());
            colSize.allocateVector((ValueVector)w.getValueVector(), recordCount);
        }
        container.setRecordCount(0);
    }

    public void allocateVectors(List<ValueVector> valueVectors, int recordCount) {
        for (ValueVector v : valueVectors) {
            RecordBatchSizer.ColumnSize colSize = this.getColumnSize(v.getField().getName());
            colSize.allocateVector(v, recordCount);
        }
    }

    public void allocateVectors(VectorContainer container) {
        this.allocateVectors(container, this.outputRowCount);
    }

    public void allocateVectors(List<ValueVector> valueVectors) {
        this.allocateVectors(valueVectors, this.outputRowCount);
    }

    private class BatchStats {
        private long numBatches;
        private long sumBatchSizes;
        private long totalRecords;

        private BatchStats() {
        }

        public long getNumBatches() {
            return this.numBatches;
        }

        public long getTotalRecords() {
            return this.totalRecords;
        }

        public long getAvgBatchSize() {
            return RecordBatchSizer.safeDivide(this.sumBatchSizes, this.numBatches);
        }

        public long getAvgRowWidth() {
            return RecordBatchSizer.safeDivide(this.sumBatchSizes, this.totalRecords);
        }

        public void incNumBatches() {
            ++this.numBatches;
        }

        public void incSumBatchSizes(long batchSize) {
            this.sumBatchSizes += batchSize;
        }

        public void incTotalRecords(long numRecords) {
            this.totalRecords += numRecords;
        }
    }
}

