/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import oadd.org.apache.drill.exec.physical.impl.scan.convert.StandardConversions;
import oadd.org.apache.drill.exec.record.ColumnConverter;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.DictWriter;
import oadd.org.apache.drill.exec.vector.accessor.ObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.TupleWriter;
import oadd.org.apache.drill.exec.vector.accessor.ValueWriter;

public class ColumnConverterFactory {
    private final StandardConversions standardConversions;

    public ColumnConverterFactory(TupleMetadata providedSchema) {
        this.standardConversions = providedSchema == null ? null : StandardConversions.builder().withSchema(providedSchema).build();
    }

    public ColumnConverter getRootConverter(TupleMetadata providedSchema, TupleMetadata readerSchema, TupleWriter tupleWriter) {
        return this.getMapConverter(providedSchema, readerSchema, tupleWriter);
    }

    public ColumnConverter getConverter(TupleMetadata providedSchema, ColumnMetadata readerSchema, ObjectWriter writer) {
        if (!writer.isProjected()) {
            return ColumnConverter.DummyColumnConverter.INSTANCE;
        }
        if (readerSchema.isArray()) {
            return this.getArrayConverter(providedSchema, readerSchema, writer.array());
        }
        if (readerSchema.isMap()) {
            return this.getMapConverter(this.providedChildSchema(providedSchema, readerSchema), readerSchema.tupleSchema(), writer.tuple());
        }
        if (readerSchema.isDict()) {
            return this.getDictConverter(this.providedChildSchema(providedSchema, readerSchema), readerSchema.tupleSchema(), writer.dict());
        }
        return this.getScalarConverter(readerSchema, writer.scalar());
    }

    private TupleMetadata providedChildSchema(TupleMetadata providedSchema, ColumnMetadata readerSchema) {
        return Optional.ofNullable(providedSchema).map(schema -> providedSchema.metadata(readerSchema.name())).map(ColumnMetadata::tupleSchema).orElse(null);
    }

    private ColumnConverter getArrayConverter(TupleMetadata providedSchema, ColumnMetadata readerSchema, ArrayWriter arrayWriter) {
        ObjectWriter valueWriter = arrayWriter.entry();
        ColumnConverter valueConverter = readerSchema.isMap() ? this.getMapConverter(providedSchema, readerSchema.tupleSchema(), valueWriter.tuple()) : (readerSchema.isDict() ? this.getDictConverter(providedSchema, readerSchema.tupleSchema(), valueWriter.dict()) : (readerSchema.isMultiList() ? this.getConverter(null, readerSchema.childSchema(), valueWriter) : this.getScalarConverter(readerSchema, valueWriter.scalar())));
        return new ColumnConverter.ArrayColumnConverter(arrayWriter, valueConverter);
    }

    protected ColumnConverter getMapConverter(TupleMetadata providedSchema, TupleMetadata readerSchema, TupleWriter tupleWriter) {
        Map<String, ColumnConverter> converters = StreamSupport.stream(readerSchema.spliterator(), false).collect(Collectors.toMap(ColumnMetadata::name, columnMetadata -> this.getConverter(providedSchema, (ColumnMetadata)columnMetadata, tupleWriter.column(columnMetadata.name()))));
        return new ColumnConverter.MapColumnConverter(this, providedSchema, tupleWriter, converters);
    }

    private ColumnConverter getDictConverter(TupleMetadata providedSchema, TupleMetadata readerSchema, DictWriter dictWriter) {
        ColumnConverter keyConverter = this.getScalarConverter(readerSchema.metadata("key"), dictWriter.keyWriter());
        ColumnConverter valueConverter = this.getConverter(providedSchema, readerSchema.metadata("value"), dictWriter.valueWriter());
        return new ColumnConverter.DictColumnConverter(dictWriter, keyConverter, valueConverter);
    }

    private ColumnConverter getScalarConverter(ColumnMetadata readerSchema, ScalarWriter scalarWriter) {
        ValueWriter valueWriter = this.standardConversions == null ? scalarWriter : this.standardConversions.converterFor(scalarWriter, readerSchema);
        return this.buildScalar(readerSchema, valueWriter);
    }

    public ColumnConverter.ScalarColumnConverter buildScalar(ColumnMetadata readerSchema, ValueWriter writer) {
        return new ColumnConverter.ScalarColumnConverter(writer::setValue);
    }
}

