/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ops;

import oadd.com.carrotsearch.hppc.IntDoubleHashMap;
import oadd.com.carrotsearch.hppc.IntLongHashMap;
import oadd.com.carrotsearch.hppc.cursors.IntDoubleCursor;
import oadd.com.carrotsearch.hppc.cursors.IntLongCursor;
import oadd.com.carrotsearch.hppc.procedures.IntDoubleProcedure;
import oadd.com.carrotsearch.hppc.procedures.IntLongProcedure;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.ops.MetricDef;
import oadd.org.apache.drill.exec.ops.OpProfileDef;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.server.rest.profile.CoreOperatorType;

public class OperatorStats {
    protected final int operatorId;
    protected final String operatorType;
    private final BufferAllocator allocator;
    private final IntLongHashMap longMetrics = new IntLongHashMap();
    private final IntDoubleHashMap doubleMetrics = new IntDoubleHashMap();
    public long[] recordsReceivedByInput;
    public long[] batchesReceivedByInput;
    private final long[] schemaCountByInput;
    private boolean inProcessing;
    private boolean inSetup;
    private boolean inWait;
    protected long processingNanos;
    protected long setupNanos;
    protected long waitNanos;
    private long processingMark;
    private long setupMark;
    private long waitMark;
    private final int inputCount;

    public OperatorStats(OpProfileDef def, BufferAllocator allocator) {
        this(def.getOperatorId(), def.getOperatorType(), def.getIncomingCount(), allocator);
    }

    public OperatorStats(OperatorStats original, boolean isClean) {
        this(original.operatorId, original.operatorType, original.inputCount, original.allocator);
        if (!isClean) {
            this.inProcessing = original.inProcessing;
            this.inSetup = original.inSetup;
            this.inWait = original.inWait;
            this.processingMark = original.processingMark;
            this.setupMark = original.setupMark;
            this.waitMark = original.waitMark;
        }
    }

    @VisibleForTesting
    public OperatorStats(int operatorId, String operatorType, int inputCount, BufferAllocator allocator) {
        this.allocator = allocator;
        this.operatorId = operatorId;
        this.operatorType = operatorType;
        this.inputCount = inputCount;
        this.recordsReceivedByInput = new long[inputCount];
        this.batchesReceivedByInput = new long[inputCount];
        this.schemaCountByInput = new long[inputCount];
    }

    private String assertionError(String msg) {
        return String.format("Failure while %s for operator id %d. Currently have states of processing:%s, setup:%s, waiting:%s.", msg, this.operatorId, this.inProcessing, this.inSetup, this.inWait);
    }

    public OperatorStats mergeMetrics(OperatorStats from) {
        IntLongHashMap fromMetrics = from.longMetrics;
        for (IntLongCursor next : fromMetrics) {
            this.longMetrics.putOrAdd(next.key, next.value, next.value);
        }
        IntDoubleHashMap fromDMetrics = from.doubleMetrics;
        for (IntDoubleCursor next : fromDMetrics) {
            this.doubleMetrics.putOrAdd(next.key, next.value, next.value);
        }
        return this;
    }

    public synchronized void clear() {
        this.processingNanos = 0L;
        this.setupNanos = 0L;
        this.waitNanos = 0L;
        this.longMetrics.clear();
        this.doubleMetrics.clear();
    }

    public synchronized void startSetup() {
        assert (!this.inSetup) : this.assertionError("starting setup");
        this.stopProcessing();
        this.inSetup = true;
        this.setupMark = System.nanoTime();
    }

    public synchronized void stopSetup() {
        assert (this.inSetup) : this.assertionError("stopping setup");
        this.startProcessing();
        this.setupNanos += System.nanoTime() - this.setupMark;
        this.inSetup = false;
    }

    public synchronized void startProcessing() {
        assert (!this.inProcessing) : this.assertionError("starting processing");
        this.processingMark = System.nanoTime();
        this.inProcessing = true;
    }

    public synchronized void stopProcessing() {
        assert (this.inProcessing) : this.assertionError("stopping processing");
        this.processingNanos += System.nanoTime() - this.processingMark;
        this.inProcessing = false;
    }

    public synchronized void startWait() {
        assert (!this.inWait) : this.assertionError("starting waiting");
        this.stopProcessing();
        this.inWait = true;
        this.waitMark = System.nanoTime();
    }

    public synchronized void stopWait() {
        assert (this.inWait) : this.assertionError("stopping waiting");
        this.startProcessing();
        this.waitNanos += System.nanoTime() - this.waitMark;
        this.inWait = false;
    }

    public synchronized void batchReceived(int inputIndex, long records, boolean newSchema) {
        int n = inputIndex;
        this.recordsReceivedByInput[n] = this.recordsReceivedByInput[n] + records;
        int n2 = inputIndex;
        this.batchesReceivedByInput[n2] = this.batchesReceivedByInput[n2] + 1L;
        if (newSchema) {
            int n3 = inputIndex;
            this.schemaCountByInput[n3] = this.schemaCountByInput[n3] + 1L;
        }
    }

    public String getId() {
        return this.operatorId + ":" + "[" + this.operatorType + "]";
    }

    public UserBitShared.OperatorProfile getProfile() {
        UserBitShared.OperatorProfile.Builder b = UserBitShared.OperatorProfile.newBuilder().setOperatorTypeName(this.operatorType).setOperatorId(this.operatorId).setSetupNanos(this.setupNanos).setProcessNanos(this.processingNanos).setWaitNanos(this.waitNanos);
        CoreOperatorType coreOperatorType = CoreOperatorType.forName((String)this.operatorType);
        if (coreOperatorType != null) {
            b.setOperatorType(coreOperatorType.getId());
        }
        if (this.allocator != null) {
            b.setPeakLocalMemoryAllocated(this.allocator.getPeakMemoryAllocation());
        }
        this.addAllMetrics(b);
        return b.build();
    }

    public void addAllMetrics(UserBitShared.OperatorProfile.Builder builder) {
        this.addStreamProfile(builder);
        this.addLongMetrics(builder);
        this.addDoubleMetrics(builder);
    }

    public void addStreamProfile(UserBitShared.OperatorProfile.Builder builder) {
        for (int i = 0; i < this.recordsReceivedByInput.length; ++i) {
            builder.addInputProfile(UserBitShared.StreamProfile.newBuilder().setBatches(this.batchesReceivedByInput[i]).setRecords(this.recordsReceivedByInput[i]).setSchemas(this.schemaCountByInput[i]));
        }
    }

    public void addLongMetrics(UserBitShared.OperatorProfile.Builder builder) {
        if (this.longMetrics.size() > 0) {
            this.longMetrics.forEach(new LongProc(builder));
        }
    }

    public void addDoubleMetrics(UserBitShared.OperatorProfile.Builder builder) {
        if (this.doubleMetrics.size() > 0) {
            this.doubleMetrics.forEach(new DoubleProc(builder));
        }
    }

    public void addLongStat(MetricDef metric, long value) {
        this.longMetrics.putOrAdd(metric.metricId(), value, value);
    }

    @VisibleForTesting
    public long getLongStat(MetricDef metric) {
        return this.longMetrics.get(metric.metricId());
    }

    public void addDoubleStat(MetricDef metric, double value) {
        this.doubleMetrics.putOrAdd(metric.metricId(), value, value);
    }

    @VisibleForTesting
    public double getDoubleStat(MetricDef metric) {
        return this.doubleMetrics.get(metric.metricId());
    }

    public void setLongStat(MetricDef metric, long value) {
        this.longMetrics.put(metric.metricId(), value);
    }

    public void setDoubleStat(MetricDef metric, double value) {
        this.doubleMetrics.put(metric.metricId(), value);
    }

    public long getWaitNanos() {
        return this.waitNanos;
    }

    public void adjustWaitNanos(long waitNanosOffset) {
        this.waitNanos += waitNanosOffset;
    }

    public long getProcessingNanos() {
        return this.processingNanos;
    }

    private static class DoubleProc
    implements IntDoubleProcedure {
        private final UserBitShared.OperatorProfile.Builder builder;

        public DoubleProc(UserBitShared.OperatorProfile.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void apply(int key, double value) {
            this.builder.addMetric(UserBitShared.MetricValue.newBuilder().setMetricId(key).setDoubleValue(value));
        }
    }

    private static class LongProc
    implements IntLongProcedure {
        private final UserBitShared.OperatorProfile.Builder builder;

        public LongProc(UserBitShared.OperatorProfile.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void apply(int key, long value) {
            this.builder.addMetric(UserBitShared.MetricValue.newBuilder().setMetricId(key).setLongValue(value));
        }
    }
}

