/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.metastore.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oadd.com.google.common.collect.ArrayListMultimap;
import oadd.com.google.common.collect.Lists;
import oadd.com.google.common.collect.Multimap;
import oadd.com.google.common.collect.Streams;
import oadd.org.apache.calcite.plan.RelOptTable;
import oadd.org.apache.calcite.plan.RelTrait;
import oadd.org.apache.calcite.rel.core.TableScan;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.metastore.analyze.MetadataIdentifierUtils;
import oadd.org.apache.drill.exec.metastore.analyze.MetadataInfoCollector;
import oadd.org.apache.drill.exec.physical.base.GroupScan;
import oadd.org.apache.drill.exec.physical.base.SchemalessScan;
import oadd.org.apache.drill.exec.planner.FileSystemPartitionDescriptor;
import oadd.org.apache.drill.exec.planner.logical.DrillRel;
import oadd.org.apache.drill.exec.planner.logical.DrillScanRel;
import oadd.org.apache.drill.exec.planner.logical.DrillTable;
import oadd.org.apache.drill.exec.planner.physical.PlannerSettings;
import oadd.org.apache.drill.exec.store.ColumnExplorer;
import oadd.org.apache.drill.exec.store.dfs.DrillFileSystem;
import oadd.org.apache.drill.exec.store.dfs.FileSelection;
import oadd.org.apache.drill.exec.store.dfs.FormatSelection;
import oadd.org.apache.drill.exec.util.DrillFileSystemUtil;
import oadd.org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.BasicTablesRequests;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class FileMetadataInfoCollector
implements MetadataInfoCollector {
    private final List<MetadataInfo> metadataToRemove;
    private final BasicTablesRequests basicRequests;
    private final TableInfo tableInfo;
    private final MetadataType metadataLevel;
    private List<MetadataInfo> allMetaToHandle;
    private List<MetadataInfo> rowGroupsInfo = Collections.emptyList();
    private List<MetadataInfo> filesInfo = Collections.emptyList();
    private Multimap<Integer, MetadataInfo> segmentsInfo = ArrayListMultimap.create();
    private TableScan tableScan;
    private boolean outdated = true;

    public FileMetadataInfoCollector(BasicTablesRequests basicRequests, TableInfo tableInfo, FormatSelection selection, PlannerSettings settings, Supplier<TableScan> tableScanSupplier, List<SchemaPath> interestingColumns, MetadataType metadataLevel, int segmentColumnsCount) throws IOException {
        this.basicRequests = basicRequests;
        this.tableInfo = tableInfo;
        this.metadataLevel = metadataLevel;
        this.metadataToRemove = new ArrayList<MetadataInfo>();
        this.init(selection, settings, tableScanSupplier, interestingColumns, segmentColumnsCount);
    }

    @Override
    public List<MetadataInfo> getRowGroupsInfo() {
        return this.rowGroupsInfo;
    }

    @Override
    public List<MetadataInfo> getFilesInfo() {
        return this.filesInfo;
    }

    @Override
    public Multimap<Integer, MetadataInfo> getSegmentsInfo() {
        return this.segmentsInfo;
    }

    @Override
    public List<MetadataInfo> getAllMetaToHandle() {
        return this.allMetaToHandle;
    }

    @Override
    public List<MetadataInfo> getMetadataToRemove() {
        return this.metadataToRemove;
    }

    @Override
    public TableScan getPrunedScan() {
        return this.tableScan;
    }

    @Override
    public boolean isOutdated() {
        return this.outdated;
    }

    private void init(FormatSelection selection, PlannerSettings settings, Supplier<TableScan> tableScanSupplier, List<SchemaPath> interestingColumns, int segmentColumnsCount) throws IOException {
        List metastoreInterestingColumns = Optional.ofNullable(this.basicRequests.interestingColumnsAndPartitionKeys(this.tableInfo).interestingColumns()).map(metastoreInterestingColumnNames -> metastoreInterestingColumnNames.stream().map(SchemaPath::parseFromString).collect(Collectors.toList())).orElse(null);
        Map filesNamesLastModifiedTime = this.basicRequests.filesLastModifiedTime(this.tableInfo, null, null);
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<String> updatedFiles = new ArrayList<String>();
        ArrayList<String> removedFiles = new ArrayList<String>(filesNamesLastModifiedTime.keySet());
        ArrayList<String> allFiles = new ArrayList<String>();
        for (FileStatus fileStatus : this.getFileStatuses(selection)) {
            String path = Path.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath()).toUri().getPath();
            Long lastModificationTime = (Long)filesNamesLastModifiedTime.get(path);
            if (lastModificationTime == null) {
                newFiles.add(path);
            } else if (lastModificationTime < fileStatus.getModificationTime()) {
                updatedFiles.add(path);
            }
            removedFiles.remove(path);
            allFiles.add(path);
        }
        String selectionRoot = selection.getSelection().getSelectionRoot().toUri().getPath();
        if (!Objects.equals(metastoreInterestingColumns, interestingColumns) && metastoreInterestingColumns != null && (interestingColumns == null || !metastoreInterestingColumns.containsAll(interestingColumns)) || ((MetadataType)TableStatisticsKind.ANALYZE_METADATA_LEVEL.getValue((Metadata)this.basicRequests.tableMetadata(this.tableInfo))).compareTo((Enum)this.metadataLevel) != 0) {
            this.tableScan = tableScanSupplier.get();
            this.metadataToRemove.addAll(this.getMetadataInfoList(selectionRoot, removedFiles, MetadataType.SEGMENT, 0));
            return;
        }
        if (!(newFiles.isEmpty() && updatedFiles.isEmpty() && removedFiles.isEmpty())) {
            ArrayList<String> scanFiles = new ArrayList<String>(newFiles);
            scanFiles.addAll(updatedFiles);
            this.tableScan = this.getTableScan(settings, tableScanSupplier.get(), scanFiles);
            int lastSegmentIndex = segmentColumnsCount - 1;
            ArrayList<String> scanAndRemovedFiles = new ArrayList<String>(scanFiles);
            scanAndRemovedFiles.addAll(removedFiles);
            List<MetadataInfo> allFilesInfo = this.getMetadataInfoList(selectionRoot, allFiles, MetadataType.FILE, 0);
            List<MetadataInfo> leafSegments = this.getMetadataInfoList(selectionRoot, scanAndRemovedFiles, MetadataType.SEGMENT, lastSegmentIndex);
            List<MetadataInfo> removedFilesMetadata = this.getMetadataInfoList(selectionRoot, removedFiles, MetadataType.FILE, 0);
            List<MetadataInfo> scanFilesInfo = this.getMetadataInfoList(selectionRoot, scanAndRemovedFiles, MetadataType.FILE, 0);
            this.filesInfo = leafSegments.stream().filter(parent -> scanFilesInfo.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).flatMap(parent -> allFilesInfo.stream().filter(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList());
            Multimap<Integer, MetadataInfo> allSegments = this.populateSegments(removedFiles, allFiles, selectionRoot, lastSegmentIndex, leafSegments, removedFilesMetadata);
            List<MetadataInfo> allRowGroupsInfo = this.getAllRowGroupsMetadataInfos(allFiles);
            this.rowGroupsInfo = allRowGroupsInfo.stream().filter(child -> this.filesInfo.stream().map(MetadataInfo::identifier).anyMatch(parent -> MetadataIdentifierUtils.isMetadataKeyParent(parent, child.identifier()))).collect(Collectors.toList());
            List<MetadataInfo> segmentsToUpdate = this.getMetadataInfoList(selectionRoot, scanAndRemovedFiles, MetadataType.SEGMENT, 0);
            this.allMetaToHandle = Streams.concat(allSegments.values().stream(), allFilesInfo.stream(), allRowGroupsInfo.stream()).filter(child -> segmentsToUpdate.stream().anyMatch(parent -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).filter(parent -> removedFilesMetadata.stream().noneMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier())) || this.filesInfo.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList());
            List removedTopSegments = this.getMetadataInfoList(selectionRoot, removedFiles, MetadataType.SEGMENT, 0).stream().filter(parent -> removedFilesMetadata.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier())) && allFilesInfo.stream().noneMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList());
            this.metadataToRemove.addAll(removedTopSegments);
            segmentsToUpdate.stream().filter(segment -> !removedTopSegments.contains(segment)).forEach(this.allMetaToHandle::add);
        } else {
            this.outdated = false;
        }
    }

    private Multimap<Integer, MetadataInfo> populateSegments(List<String> removedFiles, List<String> allFiles, String selectionRoot, int lastSegmentIndex, List<MetadataInfo> leafSegments, List<MetadataInfo> removedFilesMetadata) {
        ArrayList<String> presentAndRemovedFiles = new ArrayList<String>(allFiles);
        presentAndRemovedFiles.addAll(removedFiles);
        ArrayListMultimap<Integer, MetadataInfo> allSegments = ArrayListMultimap.create();
        if (lastSegmentIndex > 0) {
            allSegments.putAll(lastSegmentIndex, this.getMetadataInfoList(selectionRoot, presentAndRemovedFiles, MetadataType.SEGMENT, lastSegmentIndex));
        }
        for (int i = lastSegmentIndex - 1; i >= 0; --i) {
            List<MetadataInfo> currentChildSegments = leafSegments;
            List<MetadataInfo> allParentSegments = this.getMetadataInfoList(selectionRoot, presentAndRemovedFiles, MetadataType.SEGMENT, i);
            allSegments.putAll(i, allParentSegments);
            List parentSegments = allParentSegments.stream().filter(parent -> currentChildSegments.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList());
            List childSegments = allSegments.get(i + 1).stream().filter(child -> parentSegments.stream().anyMatch(parent -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).filter(parent -> removedFilesMetadata.stream().noneMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier())) || this.filesInfo.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList());
            this.segmentsInfo.putAll(i + 1, childSegments);
            leafSegments = childSegments;
        }
        this.segmentsInfo.putAll(0, this.getMetadataInfoList(selectionRoot, presentAndRemovedFiles, MetadataType.SEGMENT, 0).stream().filter(parent -> removedFilesMetadata.stream().noneMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier())) || this.filesInfo.stream().anyMatch(child -> MetadataIdentifierUtils.isMetadataKeyParent(parent.identifier(), child.identifier()))).collect(Collectors.toList()));
        return allSegments;
    }

    private List<MetadataInfo> getAllRowGroupsMetadataInfos(List<String> allFiles) {
        List metadataKeys = this.filesInfo.stream().map(MetadataInfo::key).distinct().collect(Collectors.toList());
        BasicTablesRequests.RequestMetadata requestMetadata = BasicTablesRequests.RequestMetadata.builder().tableInfo(this.tableInfo).metadataKeys(metadataKeys).paths(allFiles).metadataType(MetadataType.ROW_GROUP).requestColumns(Arrays.asList(MetastoreColumn.METADATA_KEY, MetastoreColumn.METADATA_IDENTIFIER, MetastoreColumn.METADATA_TYPE)).build();
        return this.basicRequests.request(requestMetadata).stream().map(unit -> MetadataInfo.builder().metadataUnit(unit).build()).collect(Collectors.toList());
    }

    private List<FileStatus> getFileStatuses(FormatSelection selection) throws IOException {
        FileSelection fileSelection = selection.getSelection();
        FileSystem rawFs = fileSelection.getSelectionRoot().getFileSystem(new Configuration());
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), rawFs.getConf());
        return FileMetadataInfoCollector.getFileStatuses(fileSelection, fs);
    }

    private TableScan getTableScan(PlannerSettings settings, TableScan scanRel, List<String> scanFiles) {
        FileSystemPartitionDescriptor descriptor = new FileSystemPartitionDescriptor(settings, scanRel);
        List newPartitions = Lists.newArrayList(descriptor.iterator()).stream().flatMap(Collection::stream).flatMap(p -> p.getPartitionLocationRecursive().stream()).filter(p -> scanFiles.contains(p.getEntirePartitionLocation().toUri().getPath())).collect(Collectors.toList());
        try {
            if (!newPartitions.isEmpty()) {
                return descriptor.createTableScan(newPartitions, false);
            }
            DrillTable drillTable = descriptor.getTable();
            SchemalessScan scan = new SchemalessScan(drillTable.getUserName(), ((FormatSelection)descriptor.getTable().getSelection()).getSelection().getSelectionRoot());
            return new DrillScanRel(scanRel.getCluster(), scanRel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), scanRel.getTable(), (GroupScan)scan, scanRel.getRowType(), DrillScanRel.getProjectedColumns((RelOptTable)scanRel.getTable(), (boolean)true), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error happened during recreation of pruned scan", e);
        }
    }

    private List<MetadataInfo> getMetadataInfoList(String parent, List<String> locations, MetadataType metadataType, int level) {
        return locations.stream().map(location -> this.getMetadataInfo(parent, (String)location, metadataType, level)).distinct().collect(Collectors.toList());
    }

    private MetadataInfo getMetadataInfo(String parent, String location, MetadataType metadataType, int level) {
        List values = ColumnExplorer.listPartitionValues((Path)new Path(location), (Path)new Path(parent), (boolean)true);
        switch (metadataType) {
            case ROW_GROUP: {
                throw new UnsupportedOperationException("MetadataInfo cannot be obtained for row group using file location only");
            }
            case FILE: {
                String key = values.size() > 1 ? (String)values.iterator().next() : "DEFAULT_SEGMENT";
                return MetadataInfo.builder().type(metadataType).key(key).identifier(MetadataIdentifierUtils.getMetadataIdentifierKey(values)).build();
            }
            case SEGMENT: {
                String key = values.size() > 1 ? (String)values.iterator().next() : "DEFAULT_SEGMENT";
                return MetadataInfo.builder().type(metadataType).key(key).identifier(values.size() > 1 ? MetadataIdentifierUtils.getMetadataIdentifierKey(values.subList(0, level + 1)) : "DEFAULT_SEGMENT").build();
            }
            case TABLE: {
                return MetadataInfo.builder().type(metadataType).key("GENERAL_INFO").build();
            }
        }
        throw new UnsupportedOperationException(metadataType.name());
    }

    public static List<FileStatus> getFileStatuses(FileSelection fileSelection, DrillFileSystem fs) throws IOException {
        if (!fileSelection.isExpandedFully()) {
            fileSelection = FileMetadataInfoCollector.getExpandedFileSelection(fileSelection, (FileSystem)fs);
        }
        return fileSelection.getStatuses(fs);
    }

    public static FileSelection getExpandedFileSelection(FileSelection fileSelection) throws IOException {
        FileSystem rawFs = fileSelection.getSelectionRoot().getFileSystem(new Configuration());
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), rawFs.getConf());
        return FileMetadataInfoCollector.getExpandedFileSelection(fileSelection, (FileSystem)fs);
    }

    private static FileSelection getExpandedFileSelection(FileSelection fileSelection, FileSystem fs) throws IOException {
        List<FileStatus> fileStatuses = DrillFileSystemUtil.listFiles(fs, fileSelection.getSelectionRoot(), true, new PathFilter[0]);
        fileSelection = FileSelection.create(fileStatuses, null, (Path)fileSelection.getSelectionRoot());
        return fileSelection;
    }
}

