/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec;

import java.util.Arrays;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import oadd.org.apache.drill.exec.server.options.OptionValidator;
import oadd.org.apache.drill.exec.server.options.TypeValidators;
import oadd.org.apache.drill.exec.store.parquet.ParquetFormatPlugin;
import oadd.org.apache.drill.exec.testing.ExecutionControls;

public final class ExecConstants {
    public static final String ZK_RETRY_TIMES = "drill.exec.zk.retry.count";
    public static final String ZK_RETRY_DELAY = "drill.exec.zk.retry.delay";
    public static final String ZK_CONNECTION = "drill.exec.zk.connect";
    public static final String ZK_TIMEOUT = "drill.exec.zk.timeout";
    public static final String ZK_ROOT = "drill.exec.zk.root";
    public static final String ZK_REFRESH = "drill.exec.zk.refresh";
    public static final String ZK_ACL_PROVIDER = "drill.exec.zk.acl_provider";
    public static final String ZK_APPLY_SECURE_ACL = "drill.exec.zk.apply_secure_acl";
    public static final String BIT_RETRY_TIMES = "drill.exec.rpc.bit.server.retry.count";
    public static final String BIT_RETRY_DELAY = "drill.exec.rpc.bit.server.retry.delay";
    public static final String BIT_TIMEOUT = "drill.exec.bit.timeout";
    public static final String SERVICE_NAME = "drill.exec.cluster-id";
    public static final String RPC_BIND_ADDR = "drill.exec.rpc.bind_addr";
    public static final String INITIAL_BIT_PORT = "drill.exec.rpc.bit.server.port";
    public static final String INITIAL_DATA_PORT = "drill.exec.rpc.bit.server.dataport";
    public static final String BIT_RPC_TIMEOUT = "drill.exec.rpc.bit.timeout";
    public static final String INITIAL_USER_PORT = "drill.exec.rpc.user.server.port";
    public static final String USER_RPC_TIMEOUT = "drill.exec.rpc.user.timeout";
    public static final String METRICS_CONTEXT_NAME = "drill.exec.metrics.context";
    public static final String USE_IP_ADDRESS = "drill.exec.rpc.use.ip";
    public static final String CLIENT_RPC_THREADS = "drill.exec.rpc.user.client.threads";
    public static final String BIT_SERVER_RPC_THREADS = "drill.exec.rpc.bit.server.threads";
    public static final String USER_SERVER_RPC_THREADS = "drill.exec.rpc.user.server.threads";
    public static final String FRAG_RUNNER_RPC_TIMEOUT = "drill.exec.rpc.fragrunner.timeout";
    public static final TypeValidators.PositiveLongValidator FRAG_RUNNER_RPC_TIMEOUT_VALIDATOR = new TypeValidators.PositiveLongValidator("drill.exec.rpc.fragrunner.timeout", Long.MAX_VALUE, null);
    public static final String TRACE_DUMP_DIRECTORY = "drill.exec.trace.directory";
    public static final String TRACE_DUMP_FILESYSTEM = "drill.exec.trace.filesystem";
    public static final String TEMP_DIRECTORIES = "drill.exec.tmp.directories";
    public static final String TEMP_FILESYSTEM = "drill.exec.tmp.filesystem";
    public static final String INCOMING_BUFFER_IMPL = "drill.exec.buffer.impl";
    public static final String INCOMING_BUFFER_SIZE = "drill.exec.buffer.size";
    public static final String SPOOLING_BUFFER_DELETE = "drill.exec.buffer.spooling.delete";
    public static final String SPOOLING_BUFFER_MEMORY = "drill.exec.buffer.spooling.size";
    public static final String UNLIMITED_BUFFER_MAX_MEMORY_SIZE = "drill.exec.buffer.unlimited_receiver.max_size";
    public static final String BATCH_PURGE_THRESHOLD = "drill.exec.sort.purge.threshold";
    public static final String SPILL_FILESYSTEM = "drill.exec.spill.fs";
    public static final String SPILL_DIRS = "drill.exec.spill.directories";
    public static final String OUTPUT_BATCH_SIZE = "drill.exec.memory.operator.output_batch_size";
    public static final TypeValidators.LongValidator OUTPUT_BATCH_SIZE_VALIDATOR = new TypeValidators.RangeLongValidator("drill.exec.memory.operator.output_batch_size", 128L, 0x20000000L, new OptionValidator.OptionDescription("Available as of Drill 1.13. Limits the amount of memory that the Flatten, Merge Join, and External Sort operators allocate to outgoing batches."));
    public static final String OUTPUT_BATCH_SIZE_AVAIL_MEM_FACTOR = "drill.exec.memory.operator.output_batch_size_avail_mem_factor";
    public static final TypeValidators.DoubleValidator OUTPUT_BATCH_SIZE_AVAIL_MEM_FACTOR_VALIDATOR = new TypeValidators.RangeDoubleValidator("drill.exec.memory.operator.output_batch_size_avail_mem_factor", 0.01, 1.0, new OptionValidator.OptionDescription("Based on the available system memory, adjusts the output batch size for buffered operators by the factor set."));
    public static final String EXTERNAL_SORT_TARGET_SPILL_BATCH_SIZE = "drill.exec.sort.external.spill.batch.size";
    public static final String EXTERNAL_SORT_SPILL_GROUP_SIZE = "drill.exec.sort.external.spill.group.size";
    public static final String EXTERNAL_SORT_SPILL_THRESHOLD = "drill.exec.sort.external.spill.threshold";
    public static final String EXTERNAL_SORT_SPILL_DIRS = "drill.exec.sort.external.spill.directories";
    public static final String EXTERNAL_SORT_SPILL_FILESYSTEM = "drill.exec.sort.external.spill.fs";
    public static final String EXTERNAL_SORT_SPILL_FILE_SIZE = "drill.exec.sort.external.spill.file_size";
    public static final String EXTERNAL_SORT_MSORT_MAX_BATCHSIZE = "drill.exec.sort.external.msort.batch.maxsize";
    public static final String EXTERNAL_SORT_MERGE_LIMIT = "drill.exec.sort.external.merge_limit";
    public static final String EXTERNAL_SORT_SPILL_BATCH_SIZE = "drill.exec.sort.external.spill.spill_batch_size";
    public static final String EXTERNAL_SORT_MERGE_BATCH_SIZE = "drill.exec.sort.external.spill.merge_batch_size";
    public static final String EXTERNAL_SORT_MAX_MEMORY = "drill.exec.sort.external.mem_limit";
    public static final String EXTERNAL_SORT_BATCH_LIMIT = "drill.exec.sort.external.batch_limit";
    @Deprecated
    public static final String EXTERNAL_SORT_DISABLE_MANAGED = "drill.exec.sort.external.disable_managed";
    @Deprecated
    public static final TypeValidators.BooleanValidator EXTERNAL_SORT_DISABLE_MANAGED_OPTION = new TypeValidators.BooleanValidator("exec.sort.disable_managed", null);
    public static final String HASHJOIN_HASHTABLE_CALC_TYPE_KEY = "exec.hashjoin.hash_table_calc_type";
    public static final TypeValidators.EnumeratedStringValidator HASHJOIN_HASHTABLE_CALC_TYPE = new TypeValidators.EnumeratedStringValidator("exec.hashjoin.hash_table_calc_type", new OptionValidator.OptionDescription("Sets the Hash Join Memory Calculator type. Default is LEAN. This option also accepts CONSERVATIVE as a value."), "LEAN", "CONSERVATIVE");
    public static final String HASHJOIN_SAFETY_FACTOR_KEY = "exec.hashjoin.safety_factor";
    public static final TypeValidators.DoubleValidator HASHJOIN_SAFETY_FACTOR = new TypeValidators.RangeDoubleValidator("exec.hashjoin.safety_factor", 1.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("Sets the Hash Join Memory Calculation Safety; multiplies the internal size estimate. Default is 1.0"));
    public static final String HASHJOIN_HASH_DOUBLE_FACTOR_KEY = "exec.hashjoin.hash_double_factor";
    public static final TypeValidators.DoubleValidator HASHJOIN_HASH_DOUBLE_FACTOR = new TypeValidators.RangeDoubleValidator("exec.hashjoin.hash_double_factor", 1.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("Sets the Hash Join Memory Calculation; doubling factor for the Hash-Table. Default is 2.0"));
    public static final String HASHJOIN_FRAGMENTATION_FACTOR_KEY = "exec.hashjoin.fragmentation_factor";
    public static final TypeValidators.DoubleValidator HASHJOIN_FRAGMENTATION_FACTOR = new TypeValidators.RangeDoubleValidator("exec.hashjoin.fragmentation_factor", 1.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("Sets the Hash Join Memory Calculations; multiplies the internal estimates to account for fragmentation. Default is 1.33"));
    public static final String HASHJOIN_NUM_ROWS_IN_BATCH_KEY = "exec.hashjoin.num_rows_in_batch";
    public static final TypeValidators.LongValidator HASHJOIN_NUM_ROWS_IN_BATCH_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashjoin.num_rows_in_batch", 1L, 65536L, new OptionValidator.OptionDescription("Sets the number of rows in the internal batches for Hash Join operations. Default is 1024"));
    public static final String HASHJOIN_MAX_BATCHES_IN_MEMORY_KEY = "exec.hashjoin.max_batches_in_memory";
    public static final TypeValidators.LongValidator HASHJOIN_MAX_BATCHES_IN_MEMORY_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashjoin.max_batches_in_memory", 0L, 65536L, new OptionValidator.OptionDescription("Sets the maximum number of batches allowed in memory before spilling is enforced for Hash Join operations; used for testing purposes."));
    public static final String HASHJOIN_NUM_PARTITIONS_KEY = "exec.hashjoin.num_partitions";
    public static final TypeValidators.LongValidator HASHJOIN_NUM_PARTITIONS_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashjoin.num_partitions", 1L, 128L, new OptionValidator.OptionDescription("Sets the initial number of internal partitions for Hash Join operations. Default is 32. May reduce when memory is too small. Disables spilling if set to 1."));
    public static final String HASHJOIN_MAX_MEMORY_KEY = "drill.exec.hashjoin.mem_limit";
    public static final TypeValidators.LongValidator HASHJOIN_MAX_MEMORY_VALIDATOR = new TypeValidators.RangeLongValidator("drill.exec.hashjoin.mem_limit", 0L, Long.MAX_VALUE, new OptionValidator.OptionDescription("Enforces the maximum memory limit for the Hash Join operator (if non-zero); used for testing purposes. Default is 0 (disabled)."));
    public static final String HASHJOIN_SPILL_DIRS = "drill.exec.hashjoin.spill.directories";
    public static final String HASHJOIN_SPILL_FILESYSTEM = "drill.exec.hashjoin.spill.fs";
    public static final String HASHJOIN_FALLBACK_ENABLED_KEY = "drill.exec.hashjoin.fallback.enabled";
    public static final TypeValidators.BooleanValidator HASHJOIN_FALLBACK_ENABLED_VALIDATOR = new TypeValidators.BooleanValidator("drill.exec.hashjoin.fallback.enabled", new OptionValidator.OptionDescription("Hash Joins ignore memory limits when this option is enabled (true). When disabled (false), Hash Joins fail when memory is set too low."));
    public static final String HASHJOIN_ENABLE_RUNTIME_FILTER_KEY = "exec.hashjoin.enable.runtime_filter";
    public static final TypeValidators.BooleanValidator HASHJOIN_ENABLE_RUNTIME_FILTER = new TypeValidators.BooleanValidator("exec.hashjoin.enable.runtime_filter", null);
    public static final String HASHJOIN_BLOOM_FILTER_MAX_SIZE_KEY = "exec.hashjoin.bloom_filter.max.size";
    public static final TypeValidators.IntegerValidator HASHJOIN_BLOOM_FILTER_MAX_SIZE = new TypeValidators.IntegerValidator("exec.hashjoin.bloom_filter.max.size", null);
    public static final String HASHJOIN_BLOOM_FILTER_FPP_KEY = "exec.hashjoin.bloom_filter.fpp";
    public static final TypeValidators.DoubleValidator HASHJOIN_BLOOM_FILTER_FPP_VALIDATOR = new TypeValidators.RangeDoubleValidator("exec.hashjoin.bloom_filter.fpp", Double.MIN_VALUE, 1.0, null);
    public static final String HASHJOIN_RUNTIME_FILTER_WAITING_ENABLE_KEY = "exec.hashjoin.runtime_filter.waiting.enable";
    public static final TypeValidators.BooleanValidator HASHJOIN_ENABLE_RUNTIME_FILTER_WAITING = new TypeValidators.BooleanValidator("exec.hashjoin.runtime_filter.waiting.enable", null);
    public static final String HASHJOIN_RUNTIME_FILTER_MAX_WAITING_TIME_KEY = "exec.hashjoin.runtime_filter.max.waiting.time";
    public static final TypeValidators.PositiveLongValidator HASHJOIN_RUNTIME_FILTER_MAX_WAITING_TIME = new TypeValidators.PositiveLongValidator("exec.hashjoin.runtime_filter.max.waiting.time", 65535L, null);
    public static final String HASHAGG_NUM_PARTITIONS_KEY = "exec.hashagg.num_partitions";
    public static final TypeValidators.LongValidator HASHAGG_NUM_PARTITIONS_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashagg.num_partitions", 1L, 128L, new OptionValidator.OptionDescription("Sets the initial number of internal partitions for Hash Aggregates. Default is 32. May reduce when memory is too small. Disables spilling if set to 1."));
    public static final String HASHAGG_MAX_MEMORY_KEY = "exec.hashagg.mem_limit";
    public static final TypeValidators.LongValidator HASHAGG_MAX_MEMORY_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashagg.mem_limit", 0L, Integer.MAX_VALUE, new OptionValidator.OptionDescription("Enforces the value set as the maximum memory for the Hash Aggregates. Default is 0 (disabled)."));
    public static final String HASHAGG_MIN_BATCHES_PER_PARTITION_KEY = "exec.hashagg.min_batches_per_partition";
    public static final TypeValidators.LongValidator HASHAGG_MIN_BATCHES_PER_PARTITION_VALIDATOR = new TypeValidators.RangeLongValidator("exec.hashagg.min_batches_per_partition", 1L, 5L, new OptionValidator.OptionDescription("Sets the safety assumption for the minimum number of batches needed for each partition when performing hash aggregation. Default is 2. Low value may OOM if incoming rows become very wide. See Spill-to-disk for Hash Aggregate operator for more information."));
    public static final String HASHAGG_USE_MEMORY_PREDICTION_KEY = "exec.hashagg.use_memory_prediction";
    public static final TypeValidators.BooleanValidator HASHAGG_USE_MEMORY_PREDICTION_VALIDATOR = new TypeValidators.BooleanValidator("exec.hashagg.use_memory_prediction", new OptionValidator.OptionDescription("Enables Hash Aggregates to use memory predictions to proactively spill early. Default is true."));
    public static final String HASHAGG_SPILL_DIRS = "drill.exec.hashagg.spill.directories";
    public static final String HASHAGG_SPILL_FILESYSTEM = "drill.exec.hashagg.spill.fs";
    public static final String HASHAGG_FALLBACK_ENABLED_KEY = "drill.exec.hashagg.fallback.enabled";
    public static final TypeValidators.BooleanValidator HASHAGG_FALLBACK_ENABLED_VALIDATOR = new TypeValidators.BooleanValidator("drill.exec.hashagg.fallback.enabled", new OptionValidator.OptionDescription("Hash Aggregates ignore memory limits when enabled (true). When disabled (false), Hash Aggregates fail when memory is set too low."));
    public static final String IMPLICIT_CAST_FOR_JOINS_ENABLED = "drill.exec.implicit_casts.joins.enabled";
    public static final TypeValidators.BooleanValidator IMPLICIT_CAST_FOR_JOINS_ENABLED_VALIDATOR = new TypeValidators.BooleanValidator("drill.exec.implicit_casts.joins.enabled", new OptionValidator.OptionDescription("When true, this option enables implicit casts for joins.  This is an experimental feature in Drill 1.21.1"));
    public static final String PARTITIONER_MEMORY_REDUCTION_THRESHOLD_KEY = "exec.partition.mem_throttle";
    public static final TypeValidators.LongValidator PARTITIONER_MEMORY_REDUCTION_THRESHOLD_VALIDATOR = new TypeValidators.RangeLongValidator("exec.partition.mem_throttle", 0L, Integer.MAX_VALUE, new OptionValidator.OptionDescription("Linearly reduces partition sender buffer row count after this number of receivers. Default is 0 (disabled). (Since Drill 1.18)"));
    public static final String SSL_PROVIDER = "drill.exec.ssl.provider";
    public static final String SSL_PROTOCOL = "drill.exec.ssl.protocol";
    public static final String SSL_KEYSTORE_TYPE = "drill.exec.ssl.keyStoreType";
    public static final String SSL_KEYSTORE_PATH = "drill.exec.ssl.keyStorePath";
    public static final String SSL_KEYSTORE_PASSWORD = "drill.exec.ssl.keyStorePassword";
    public static final String SSL_KEY_PASSWORD = "drill.exec.ssl.keyPassword";
    public static final String SSL_TRUSTSTORE_TYPE = "drill.exec.ssl.trustStoreType";
    public static final String SSL_TRUSTSTORE_PATH = "drill.exec.ssl.trustStorePath";
    public static final String SSL_TRUSTSTORE_PASSWORD = "drill.exec.ssl.trustStorePassword";
    public static final String SSL_USE_HADOOP_CONF = "drill.exec.ssl.useHadoopConfig";
    public static final String SSL_USE_MAPR_CONFIG = "drill.exec.ssl.useMapRSSLConfig";
    public static final String SSL_HANDSHAKE_TIMEOUT = "drill.exec.security.user.encryption.ssl.handshakeTimeout";
    public static final String TEXT_LINE_READER_BATCH_SIZE = "drill.exec.storage.file.text.batch.size";
    public static final String TEXT_LINE_READER_BUFFER_SIZE = "drill.exec.storage.file.text.buffer.size";
    public static final String FILE_PLUGIN_MOUNT_COMMANDS = "drill.exec.storage.file.enable_mount_commands";
    public static final String HAZELCAST_SUBNETS = "drill.exec.cache.hazel.subnets";
    public static final String HTTP_ENABLE = "drill.exec.http.enabled";
    public static final String HTTP_MAX_PROFILES = "drill.exec.http.max_profiles";
    public static final String HTTP_PROFILES_PER_PAGE = "drill.exec.http.profiles_per_page";
    public static final String HTTP_BIND_ADDR = "drill.exec.http.bind_addr";
    public static final String HTTP_PORT = "drill.exec.http.port";
    public static final String HTTP_PORT_HUNT = "drill.exec.http.porthunt";
    public static final String HTTP_JETTY_SERVER_DUMP_AFTER_START = "drill.exec.http.jetty.server.dumpAfterStart";
    public static final String HTTP_JETTY_SERVER_ACCEPTORS = "drill.exec.http.jetty.server.acceptors";
    public static final String HTTP_JETTY_SERVER_SELECTORS = "drill.exec.http.jetty.server.selectors";
    public static final String HTTP_JETTY_SERVER_HANDLERS = "drill.exec.http.jetty.server.handlers";
    public static final String HTTP_JETTY_SERVER_RESPONSE_HEADERS = "drill.exec.http.jetty.server.response.headers";
    public static final String HTTP_JETTY_SSL_CONTEXT_FACTORY_OPTIONS_PREFIX = "drill.exec.http.jetty.server.sslContextFactory";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_CERT_ALIAS = "drill.exec.http.jetty.server.sslContextFactory.certAlias";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_CRL_PATH = "drill.exec.http.jetty.server.sslContextFactory.crlPath";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_ENABLE_CRLDP = "drill.exec.http.jetty.server.sslContextFactory.enableCRLDP";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_ENABLE_OCSP = "drill.exec.http.jetty.server.sslContextFactory.enableOCSP";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_ENDPOINT_IDENTIFICATION_ALGORITHM = "drill.exec.http.jetty.server.sslContextFactory.endpointIdentificationAlgorithm";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_EXCLUDE_CIPHER_SUITES = "drill.exec.http.jetty.server.sslContextFactory.excludeCipherSuites";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_EXCLUDE_PROTOCOLS = "drill.exec.http.jetty.server.sslContextFactory.excludeProtocols";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_INCLUDE_CIPHER_SUITES = "drill.exec.http.jetty.server.sslContextFactory.includeCipherSuites";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_INCLUDE_PROTOCOLS = "drill.exec.http.jetty.server.sslContextFactory.includeProtocols";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_KEY_MANAGER_FACTORY_ALGORITHM = "drill.exec.http.jetty.server.sslContextFactory.keyManagerFactoryAlgorithm";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_KEYSTORE_PROVIDER = "drill.exec.http.jetty.server.sslContextFactory.keyStoreProvider";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_KEYSTORE_TYPE = "drill.exec.http.jetty.server.sslContextFactory.keyStoreType";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_MAX_CERT_PATH_LENGTH = "drill.exec.http.jetty.server.sslContextFactory.maxCertPathLength";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_NEED_CLIENT_AUTH = "drill.exec.http.jetty.server.sslContextFactory.needClientAuth";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_OCSP_RESPONDER_URL = "drill.exec.http.jetty.server.sslContextFactory.ocspResponderURL";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_PROVIDER = "drill.exec.http.jetty.server.sslContextFactory.provider";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_RENEGOTIATION_ALLOWED = "drill.exec.http.jetty.server.sslContextFactory.renegotiationAllowed";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_RENEGOTIATION_LIMIT = "drill.exec.http.jetty.server.sslContextFactory.renegotiationLimit";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_SECURE_RANDOM_ALGORITHM = "drill.exec.http.jetty.server.sslContextFactory.secureRandomAlgorithm";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_SESSION_CACHING_ENABLED = "drill.exec.http.jetty.server.sslContextFactory.sessionCachingEnabled";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_SSL_SESSION_CACHE_SIZE = "drill.exec.http.jetty.server.sslContextFactory.sslSessionCacheSize";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_SSL_SESSION_TIMEOUT = "drill.exec.http.jetty.server.sslContextFactory.sslSessionTimeout";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_TRUSTMANAGERFACTORY_ALGORITHM = "drill.exec.http.jetty.server.sslContextFactory.trustManagerFactoryAlgorithm";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_TRUSTSTORE_PROVIDER = "drill.exec.http.jetty.server.sslContextFactory.trustStoreProvider";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_TRUSTSTORE_TYPE = "drill.exec.http.jetty.server.sslContextFactory.trustStoreType";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_USE_CIPHER_SUITE_ORDER = "drill.exec.http.jetty.server.sslContextFactory.useCipherSuiteOrder";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_VALIDATE_CERTS = "drill.exec.http.jetty.server.sslContextFactory.validateCerts";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_VALIDATE_PEER_CERTS = "drill.exec.http.jetty.server.sslContextFactory.validatePeerCerts";
    public static final String HTTP_JETTY_SERVER_SSL_CONTEXT_FACTORY_WANT_CLIENT_AUTH = "drill.exec.http.jetty.server.sslContextFactory.wantClientAuth";
    public static final String HTTP_ENABLE_SSL = "drill.exec.http.ssl_enabled";
    public static final String HTTP_CLIENT_TIMEOUT = "drill.exec.http.client.timeout";
    public static final String HTTP_CORS_ENABLED = "drill.exec.http.cors.enabled";
    public static final String HTTP_CORS_ALLOWED_ORIGINS = "drill.exec.http.cors.allowedOrigins";
    public static final String HTTP_CORS_ALLOWED_METHODS = "drill.exec.http.cors.allowedMethods";
    public static final String HTTP_CORS_ALLOWED_HEADERS = "drill.exec.http.cors.allowedHeaders";
    public static final String HTTP_CORS_CREDENTIALS = "drill.exec.http.cors.credentials";
    public static final String HTTP_SESSION_MEMORY_RESERVATION = "drill.exec.http.session.memory.reservation";
    public static final String HTTP_SESSION_MEMORY_MAXIMUM = "drill.exec.http.session.memory.maximum";
    public static final String HTTP_SESSION_MAX_IDLE_SECS = "drill.exec.http.session_max_idle_secs";
    public static final String HTTP_KEYSTORE_PATH = "drill.exec.ssl.keyStorePath";
    public static final String HTTP_KEYSTORE_PASSWORD = "drill.exec.ssl.keyStorePassword";
    public static final String HTTP_TRUSTSTORE_PATH = "drill.exec.ssl.trustStorePath";
    public static final String HTTP_TRUSTSTORE_PASSWORD = "drill.exec.ssl.trustStorePassword";
    public static final String HTTP_AUTHENTICATION_MECHANISMS = "drill.exec.http.auth.mechanisms";
    public static final String HTTP_SPNEGO_PRINCIPAL = "drill.exec.http.auth.spnego.principal";
    public static final String HTTP_SPNEGO_KEYTAB = "drill.exec.http.auth.spnego.keytab";
    public static final String HTTP_WEB_CLIENT_RESULTSET_AUTOLIMIT_CHECKED = "drill.exec.http.web.client.resultset.autolimit.checked";
    public static final String HTTP_WEB_CLIENT_RESULTSET_AUTOLIMIT_ROWS = "drill.exec.http.web.client.resultset.autolimit.rows";
    public static final String HTTP_WEB_CLIENT_RESULTSET_ROWS_PER_PAGE_VALUES = "drill.exec.http.web.client.resultset.rowsPerPageValues";
    @Deprecated
    public static final String HTTP_MEMORY_HEAP_FAILURE_THRESHOLD = "drill.exec.http.memory.heap.failure.threshold";
    public static final String HTTP_WEB_OPTIONS_FILTERS = "drill.exec.http.web.options.filters";
    public static final String SYS_STORE_PROVIDER_CLASS = "drill.exec.sys.store.provider.class";
    public static final String SYS_STORE_PROVIDER_LOCAL_PATH = "drill.exec.sys.store.provider.local.path";
    public static final String SYS_STORE_PROVIDER_LOCAL_ENABLE_WRITE = "drill.exec.sys.store.provider.local.write";
    public static final String PROFILES_STORE_INMEMORY = "drill.exec.profiles.store.inmemory";
    public static final String PROFILES_STORE_CAPACITY = "drill.exec.profiles.store.capacity";
    public static final String IMPERSONATION_ENABLED = "drill.exec.impersonation.enabled";
    public static final String IMPERSONATION_MAX_CHAINED_USER_HOPS = "drill.exec.impersonation.max_chained_user_hops";
    public static final String AUTHENTICATION_MECHANISMS = "drill.exec.security.auth.mechanisms";
    public static final String USER_AUTHENTICATION_ENABLED = "drill.exec.security.user.auth.enabled";
    public static final String USER_AUTHENTICATOR_IMPL = "drill.exec.security.user.auth.impl";
    public static final String HTPASSWD_AUTHENTICATOR_PATH = "drill.exec.security.user.auth.htpasswd.path";
    public static final String PAM_AUTHENTICATOR_PROFILES = "drill.exec.security.user.auth.pam_profiles";
    public static final String BIT_AUTHENTICATION_ENABLED = "drill.exec.security.bit.auth.enabled";
    public static final String BIT_AUTHENTICATION_MECHANISM = "drill.exec.security.bit.auth.mechanism";
    public static final String USE_LOGIN_PRINCIPAL = "drill.exec.security.bit.auth.use_login_principal";
    public static final String USER_ENCRYPTION_SASL_ENABLED = "drill.exec.security.user.encryption.sasl.enabled";
    public static final String USER_ENCRYPTION_SASL_MAX_WRAPPED_SIZE = "drill.exec.security.user.encryption.sasl.max_wrapped_size";
    private static final String SERVICE_LOGIN_PREFIX = "drill.exec.security.auth";
    public static final String SERVICE_PRINCIPAL = "drill.exec.security.auth.principal";
    public static final String SERVICE_KEYTAB_LOCATION = "drill.exec.security.auth.keytab";
    public static final String KERBEROS_NAME_MAPPING = "drill.exec.security.auth.auth_to_local";
    public static final String USER_SSL_ENABLED = "drill.exec.security.user.encryption.ssl.enabled";
    public static final String BIT_ENCRYPTION_SASL_ENABLED = "drill.exec.security.bit.encryption.sasl.enabled";
    public static final String BIT_ENCRYPTION_SASL_MAX_WRAPPED_SIZE = "drill.exec.security.bit.encryption.sasl.max_wrapped_size";
    public static final String JDBC_BATCH_QUEUE_THROTTLING_THRESHOLD = "drill.jdbc.batch_queue_throttling_threshold";
    public static final String JDBC_QUERY_TIMEOUT = "drill.jdbc.query_timeout";
    public static final String SCAN_THREADPOOL_SIZE = "drill.exec.scan.threadpool_size";
    public static final String SCAN_DECODE_THREADPOOL_SIZE = "drill.exec.scan.decode_threadpool_size";
    public static final String RETURN_ERROR_FOR_FAILURE_IN_CANCELLED_FRAGMENTS = "drill.exec.debug.return_error_for_failure_in_cancelled_fragments";
    public static final String CLIENT_SUPPORT_COMPLEX_TYPES = "drill.client.supports-complex-types";
    public static final String UDF_RETRY_ATTEMPTS = "drill.exec.udf.retry-attempts";
    public static final String UDF_DIRECTORY_LOCAL = "drill.exec.udf.directory.local";
    public static final String UDF_DIRECTORY_FS = "drill.exec.udf.directory.fs";
    public static final String UDF_DIRECTORY_ROOT = "drill.exec.udf.directory.root";
    public static final String UDF_DIRECTORY_STAGING = "drill.exec.udf.directory.staging";
    public static final String UDF_DIRECTORY_REGISTRY = "drill.exec.udf.directory.registry";
    public static final String UDF_DIRECTORY_TMP = "drill.exec.udf.directory.tmp";
    public static final String UDF_DISABLE_DYNAMIC = "drill.exec.udf.disable_dynamic";
    public static final String DRILL_TMP_DIR = "drill.tmp-dir";
    public static final String DEFAULT_TEMPORARY_WORKSPACE = "drill.exec.default_temporary_workspace";
    public static final String OUTPUT_FORMAT_OPTION = "store.format";
    public static final OptionValidator OUTPUT_FORMAT_VALIDATOR = new TypeValidators.StringValidator("store.format", new OptionValidator.OptionDescription("Output format for data written to tables with the CREATE TABLE AS (CTAS) command. Allowed values are parquet, json, psv, csv, or tsv."));
    public static final String PARQUET_WRITER_USE_SINGLE_FS_BLOCK = "store.parquet.writer.use_single_fs_block";
    public static final OptionValidator PARQUET_WRITER_USE_SINGLE_FS_BLOCK_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.writer.use_single_fs_block", new OptionValidator.OptionDescription("Instructs the Parquet writer to create files with the configured block size (instead of the default filesystem block size)."));
    public static final String PARQUET_BLOCK_SIZE = "store.parquet.block-size";
    public static final OptionValidator PARQUET_BLOCK_SIZE_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.block-size", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Sets the row group size (in bytes) for output Parquet files to a number that is less than or equal to the block size in MFS, HDFS, or the file system."));
    public static final String PARQUET_PAGE_SIZE = "store.parquet.page-size";
    public static final OptionValidator PARQUET_PAGE_SIZE_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.page-size", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Sets the page size for output Parquet files."));
    public static final String PARQUET_DICT_PAGE_SIZE = "store.parquet.dictionary.page-size";
    public static final OptionValidator PARQUET_DICT_PAGE_SIZE_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.dictionary.page-size", Integer.MAX_VALUE, new OptionValidator.OptionDescription("For internal use. Do not change."));
    public static final String PARQUET_WRITER_COMPRESSION_TYPE = "store.parquet.compression";
    public static final OptionValidator PARQUET_WRITER_COMPRESSION_TYPE_VALIDATOR = new TypeValidators.EnumeratedStringValidator("store.parquet.compression", new OptionValidator.OptionDescription("Compression type for storing Parquet output. Allowed values: none, brotli, gzip, lz4, lzo, snappy, zstd"), "none", "brotli", "gzip", "lz4", "lzo", "snappy", "zstd");
    public static final String PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING = "store.parquet.enable_dictionary_encoding";
    public static final OptionValidator PARQUET_WRITER_ENABLE_DICTIONARY_ENCODING_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.enable_dictionary_encoding", new OptionValidator.OptionDescription("For internal use. Do not change."));
    public static final String PARQUET_WRITER_USE_PRIMITIVE_TYPES_FOR_DECIMALS = "store.parquet.writer.use_primitive_types_for_decimals";
    public static final OptionValidator PARQUET_WRITER_USE_PRIMITIVE_TYPES_FOR_DECIMALS_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.writer.use_primitive_types_for_decimals", new OptionValidator.OptionDescription("Instructs the Parquet writer to convert decimal to primitive types whenever possible."));
    public static final String PARQUET_WRITER_LOGICAL_TYPE_FOR_DECIMALS = "store.parquet.writer.logical_type_for_decimals";
    public static final OptionValidator PARQUET_WRITER_LOGICAL_TYPE_FOR_DECIMALS_VALIDATOR = new TypeValidators.EnumeratedStringValidator("store.parquet.writer.logical_type_for_decimals", new OptionValidator.OptionDescription("Parquet writer logical type for decimal; supported types 'fixed_len_byte_array' and 'binary'"), "fixed_len_byte_array", "binary");
    public static final String PARQUET_WRITER_FORMAT_VERSION = "store.parquet.writer.format_version";
    public static final OptionValidator PARQUET_WRITER_FORMAT_VERSION_VALIDATOR = new TypeValidators.EnumeratedStringValidator("store.parquet.writer.format_version", new OptionValidator.OptionDescription("Parquet format version used for storing Parquet output.  Allowed values:" + Arrays.toString(ParquetFormatPlugin.PARQUET_FORMAT_VERSIONS)), ParquetFormatPlugin.PARQUET_FORMAT_VERSIONS);
    @Deprecated
    public static final String PARQUET_VECTOR_FILL_THRESHOLD = "store.parquet.vector_fill_threshold";
    @Deprecated
    public static final OptionValidator PARQUET_VECTOR_FILL_THRESHOLD_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.vector_fill_threshold", 99L, new OptionValidator.OptionDescription("Deprecated."));
    @Deprecated
    public static final String PARQUET_VECTOR_FILL_CHECK_THRESHOLD = "store.parquet.vector_fill_check_threshold";
    @Deprecated
    public static final OptionValidator PARQUET_VECTOR_FILL_CHECK_THRESHOLD_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.vector_fill_check_threshold", 100L, new OptionValidator.OptionDescription("Deprecated."));
    public static final String PARQUET_NEW_RECORD_READER = "store.parquet.use_new_reader";
    public static final OptionValidator PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.use_new_reader", new OptionValidator.OptionDescription("Not supported in this release."));
    public static final String PARQUET_READER_INT96_AS_TIMESTAMP = "store.parquet.reader.int96_as_timestamp";
    public static final OptionValidator PARQUET_READER_INT96_AS_TIMESTAMP_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.int96_as_timestamp", new OptionValidator.OptionDescription("Enables Drill to implicitly interpret the INT96 timestamp data type in Parquet files."));
    public static final String PARQUET_READER_STRINGS_SIGNED_MIN_MAX = "store.parquet.reader.strings_signed_min_max";
    public static final TypeValidators.StringValidator PARQUET_READER_STRINGS_SIGNED_MIN_MAX_VALIDATOR = new TypeValidators.EnumeratedStringValidator("store.parquet.reader.strings_signed_min_max", new OptionValidator.OptionDescription("Allows binary statistics usage for files created prior to 1.9.1 parquet library version where statistics was incorrectly calculated for UTF-8 data. For cases when user exactly knows that data in binary columns is in ASCII (not UTF-8), turning this property to 'true' enables statistics usage for varchar and decimal data types. Default is unset, i.e. empty string. Allowed values: 'true', 'false', '' (empty string)."), "true", "false", "");
    public static final String PARQUET_PAGEREADER_ASYNC = "store.parquet.reader.pagereader.async";
    public static final OptionValidator PARQUET_PAGEREADER_ASYNC_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.pagereader.async", new OptionValidator.OptionDescription("Enable the asynchronous page reader. This pipelines the reading of data from disk for high performance."));
    public static final String PARQUET_PAGEREADER_QUEUE_SIZE = "store.parquet.reader.pagereader.queuesize";
    public static final OptionValidator PARQUET_PAGEREADER_QUEUE_SIZE_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.reader.pagereader.queuesize", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Sets the number of pages that the Parquet reader prefetches per column."));
    public static final String PARQUET_PAGEREADER_ENFORCETOTALSIZE = "store.parquet.reader.pagereader.enforceTotalSize";
    public static final OptionValidator PARQUET_PAGEREADER_ENFORCETOTALSIZE_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.pagereader.enforceTotalSize", new OptionValidator.OptionDescription("Instructs the Parquet reader to read no more than the advertised page size."));
    public static final String PARQUET_COLUMNREADER_ASYNC = "store.parquet.reader.columnreader.async";
    public static final OptionValidator PARQUET_COLUMNREADER_ASYNC_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.columnreader.async", new OptionValidator.OptionDescription("Turn on parallel decoding of column data from Parquet to the in memory format. This increases CPU usage and is most useful for compressed fixed width data. With increasing concurrency, this option may cause queries to run slower and should be turned on only for performance critical queries."));
    public static final String PARQUET_PAGEREADER_USE_BUFFERED_READ = "store.parquet.reader.pagereader.bufferedread";
    public static final OptionValidator PARQUET_PAGEREADER_USE_BUFFERED_READ_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.pagereader.bufferedread", new OptionValidator.OptionDescription("Enable buffered page reading. Can improve disk scan speeds by buffering data, but increases memory usage. This option is less useful when the number of columns increases."));
    public static final String PARQUET_PAGEREADER_BUFFER_SIZE = "store.parquet.reader.pagereader.buffersize";
    public static final OptionValidator PARQUET_PAGEREADER_BUFFER_SIZE_VALIDATOR = new TypeValidators.LongValidator("store.parquet.reader.pagereader.buffersize", new OptionValidator.OptionDescription("The size of the buffer (in bytes) to use if bufferedread is true. Has no effect otherwise."));
    public static final String PARQUET_PAGEREADER_USE_FADVISE = "store.parquet.reader.pagereader.usefadvise";
    public static final OptionValidator PARQUET_PAGEREADER_USE_FADVISE_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.pagereader.usefadvise", new OptionValidator.OptionDescription("If the file system supports it, the Parquet file reader issues an fadvise call to enable file server side sequential reading and caching. Since many HDFS implementations do not support this and because this may have no effect in conditions of high concurrency, the option is set to false. Useful for benchmarks and for performance critical queries."));
    public static final String SCALAR_REPLACEMENT_OPTION = "oadd.org.apache.drill.exec.compile.ClassTransformer.scalar_replacement";
    public static final TypeValidators.EnumeratedStringValidator SCALAR_REPLACEMENT_VALIDATOR = new TypeValidators.EnumeratedStringValidator("oadd.org.apache.drill.exec.compile.ClassTransformer.scalar_replacement", new OptionValidator.OptionDescription("Enables Drill to attempt scalar replacement. If an error occurs during the attempt, Drill falls back to the previous behavior. Default is 'try'. Accepted values are 'try', 'on', and 'off'. (Drill 0.8+)"), "try", "on", "off");
    public static final String PARQUET_FLAT_READER_BULK = "store.parquet.flat.reader.bulk";
    public static final OptionValidator PARQUET_FLAT_READER_BULK_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.flat.reader.bulk", new OptionValidator.OptionDescription("Parquet Reader which uses bulk processing (default)."));
    public static final String PARQUET_FLAT_BATCH_NUM_RECORDS = "store.parquet.flat.batch.num_records";
    public static final OptionValidator PARQUET_FLAT_BATCH_NUM_RECORDS_VALIDATOR = new TypeValidators.RangeLongValidator("store.parquet.flat.batch.num_records", 1L, 65535L, new OptionValidator.OptionDescription("Parquet Reader maximum number of records per batch."));
    public static final String PARQUET_FLAT_BATCH_MEMORY_SIZE = "store.parquet.flat.batch.memory_size";
    public static final OptionValidator PARQUET_FLAT_BATCH_MEMORY_SIZE_VALIDATOR = new TypeValidators.RangeLongValidator("store.parquet.flat.batch.memory_size", 0L, Integer.MAX_VALUE, new OptionValidator.OptionDescription("Flat Parquet Reader maximum memory size per batch."));
    public static final String PARQUET_COMPLEX_BATCH_NUM_RECORDS = "store.parquet.complex.batch.num_records";
    public static final OptionValidator PARQUET_COMPLEX_BATCH_NUM_RECORDS_VALIDATOR = new TypeValidators.RangeLongValidator("store.parquet.complex.batch.num_records", 1L, 65535L, new OptionValidator.OptionDescription("Complex Parquet Reader maximum number of records per batch."));
    public static final String ENABLE_V2_JSON_READER_KEY = "store.json.enable_v2_reader";
    public static final TypeValidators.BooleanValidator ENABLE_V2_JSON_READER_VALIDATOR = new TypeValidators.BooleanValidator("store.json.enable_v2_reader", new OptionValidator.OptionDescription("Enable the experimental \"version 2\" JSON reader."));
    public static final String JSON_ALL_TEXT_MODE = "store.json.all_text_mode";
    public static final TypeValidators.BooleanValidator JSON_READER_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.json.all_text_mode", new OptionValidator.OptionDescription("Drill reads all data from the JSON files as VARCHAR. Prevents schema change errors."));
    public static final String JSON_EXTENDED_TYPES_KEY = "store.json.extended_types";
    public static final TypeValidators.BooleanValidator JSON_EXTENDED_TYPES = new TypeValidators.BooleanValidator("store.json.extended_types", new OptionValidator.OptionDescription("Turns on special JSON structures that Drill serializes for storing more type information than the four basic JSON types."));
    public static final String JSON_WRITER_UGLIFY_KEY = "store.json.writer.uglify";
    public static final TypeValidators.BooleanValidator JSON_WRITER_UGLIFY = new TypeValidators.BooleanValidator("store.json.writer.uglify", new OptionValidator.OptionDescription("Enables Drill to return compact JSON output files; Drill does not separate records. Default is false. (Drill 1.4+)"));
    public static final String JSON_WRITER_SKIP_NULL_FIELDS_KEY = "store.json.writer.skip_null_fields";
    public static final TypeValidators.BooleanValidator JSON_WRITER_SKIPNULLFIELDS = new TypeValidators.BooleanValidator("store.json.writer.skip_null_fields", new OptionValidator.OptionDescription("Enables Drill to skip extraneous NULL fields in JSON output files when executing the CTAS statement. Default is true. (Drill 1.6+)"));
    public static final String JSON_READER_SKIP_INVALID_RECORDS_FLAG = "store.json.reader.skip_invalid_records";
    public static final TypeValidators.BooleanValidator JSON_SKIP_MALFORMED_RECORDS_VALIDATOR = new TypeValidators.BooleanValidator("store.json.reader.skip_invalid_records", new OptionValidator.OptionDescription("Allows queries to progress when the JSON record reader skips bad records in JSON files. Default is false. (Drill 1.9+)"));
    public static final String JSON_READER_PRINT_INVALID_RECORDS_LINE_NOS_FLAG = "store.json.reader.print_skipped_invalid_record_number";
    public static final TypeValidators.BooleanValidator JSON_READER_PRINT_INVALID_RECORDS_LINE_NOS_FLAG_VALIDATOR = new TypeValidators.BooleanValidator("store.json.reader.print_skipped_invalid_record_number", new OptionValidator.OptionDescription("Enables Drill to log the bad records that the JSON record reader skips when reading JSON files. Default is false. (Drill 1.9+)"));
    public static final String TEXT_ESTIMATED_ROW_SIZE_KEY = "store.text.estimated_row_size_bytes";
    public static final TypeValidators.DoubleValidator TEXT_ESTIMATED_ROW_SIZE = new TypeValidators.RangeDoubleValidator("store.text.estimated_row_size_bytes", 1.0, 9.223372036854776E18, new OptionValidator.OptionDescription("Estimate of the row size in a delimited text file, such as csv. The closer to actual, the better the query plan. Used for all csv files in the system/session where the value is set. Impacts the decision to plan a broadcast join or not."));
    public static final String TEXT_WRITER_ADD_HEADER = "store.text.writer.add_header";
    public static final TypeValidators.BooleanValidator TEXT_WRITER_ADD_HEADER_VALIDATOR = new TypeValidators.BooleanValidator("store.text.writer.add_header", new OptionValidator.OptionDescription("Enables the TEXT writer to write header in newly created file. Default is true. (Drill 1.17+)"));
    public static final String TEXT_WRITER_FORCE_QUOTES = "store.text.writer.force_quotes";
    public static final TypeValidators.BooleanValidator TEXT_WRITER_FORCE_QUOTES_VALIDATOR = new TypeValidators.BooleanValidator("store.text.writer.force_quotes", new OptionValidator.OptionDescription("Enables the TEXT writer to enclose in quotes all fields. Default is false. (Drill 1.17+)"));
    public static final String JSON_WRITER_NAN_INF_NUMBERS = "store.json.writer.allow_nan_inf";
    public static final TypeValidators.BooleanValidator JSON_WRITER_NAN_INF_NUMBERS_VALIDATOR = new TypeValidators.BooleanValidator("store.json.writer.allow_nan_inf", new OptionValidator.OptionDescription("Enables the JSON writer in Drill to write `NaN` and `Infinity` tokens as numbers (not enclosed with double quotes) to a JSON file. Default is true. (Drill 1.13+)"));
    public static final String JSON_READER_NAN_INF_NUMBERS = "store.json.reader.allow_nan_inf";
    public static final TypeValidators.BooleanValidator JSON_READER_NAN_INF_NUMBERS_VALIDATOR = new TypeValidators.BooleanValidator("store.json.reader.allow_nan_inf", new OptionValidator.OptionDescription("Enables the JSON record reader in Drill to read `NaN` and `Infinity` tokens in JSON data as numbers. Default is true. (Drill 1.13+)"));
    public static final String JSON_READER_ESCAPE_ANY_CHAR = "store.json.reader.allow_escape_any_char";
    public static final TypeValidators.BooleanValidator JSON_READER_ESCAPE_ANY_CHAR_VALIDATOR = new TypeValidators.BooleanValidator("store.json.reader.allow_escape_any_char", new OptionValidator.OptionDescription("Enables the JSON record reader in Drill to escape any character. Default is false. (Drill 1.16+)"));
    public static final String STORE_TABLE_USE_SCHEMA_FILE = "store.table.use_schema_file";
    public static final TypeValidators.BooleanValidator STORE_TABLE_USE_SCHEMA_FILE_VALIDATOR = new TypeValidators.BooleanValidator("store.table.use_schema_file", new OptionValidator.OptionDescription("Controls if schema file stored in table root directory will be used during query execution. (Drill 1.16+)"));
    public static final String FILESYSTEM_PARTITION_COLUMN_LABEL = "drill.exec.storage.file.partition.column.label";
    public static final TypeValidators.StringValidator FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.file.partition.column.label", new OptionValidator.OptionDescription("The column label for directory levels in results of queries of files in a directory. Accepts a string input."));
    public static final String IMPLICIT_FILENAME_COLUMN_LABEL = "drill.exec.storage.implicit.filename.column.label";
    public static final OptionValidator IMPLICIT_FILENAME_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.filename.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.10. Sets the implicit column name for the filename column."));
    public static final String IMPLICIT_SUFFIX_COLUMN_LABEL = "drill.exec.storage.implicit.suffix.column.label";
    public static final OptionValidator IMPLICIT_SUFFIX_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.suffix.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.10. Sets the implicit column name for the suffix column."));
    public static final String IMPLICIT_FQN_COLUMN_LABEL = "drill.exec.storage.implicit.fqn.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_FQN_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.fqn.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.10. Sets the implicit column name for the fqn column."));
    public static final String IMPLICIT_FILEPATH_COLUMN_LABEL = "drill.exec.storage.implicit.filepath.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_FILEPATH_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.filepath.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.10. Sets the implicit column name for the filepath column."));
    public static final String IMPLICIT_ROW_GROUP_INDEX_COLUMN_LABEL = "drill.exec.storage.implicit.row_group_index.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_ROW_GROUP_INDEX_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.row_group_index.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.17. Sets the implicit column name for the row group index (rgi) column. For internal usage when producing Metastore analyze."));
    public static final String IMPLICIT_ROW_GROUP_START_COLUMN_LABEL = "drill.exec.storage.implicit.row_group_start.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_ROW_GROUP_START_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.row_group_start.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.17. Sets the implicit column name for the row group start (rgs) column. For internal usage when producing Metastore analyze."));
    public static final String IMPLICIT_ROW_GROUP_LENGTH_COLUMN_LABEL = "drill.exec.storage.implicit.row_group_length.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_ROW_GROUP_LENGTH_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.row_group_length.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.17. Sets the implicit column name for the row group length (rgl) column. For internal usage when producing Metastore analyze."));
    public static final String IMPLICIT_LAST_MODIFIED_TIME_COLUMN_LABEL = "drill.exec.storage.implicit.last_modified_time.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_LAST_MODIFIED_TIME_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.last_modified_time.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.17. Sets the implicit column name for the lastModifiedTime column. For internal usage when producing Metastore analyze."));
    public static final String IMPLICIT_PROJECT_METADATA_COLUMN_LABEL = "drill.exec.storage.implicit.project_metadata.column.label";
    public static final TypeValidators.StringValidator IMPLICIT_PROJECT_METADATA_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.implicit.project_metadata.column.label", new OptionValidator.OptionDescription("Available as of Drill 1.18. Sets the implicit column name for the $project_metadata$ column. For internal usage when producing Metastore analyze."));
    public static final String JSON_READ_NUMBERS_AS_DOUBLE = "store.json.read_numbers_as_double";
    public static final TypeValidators.BooleanValidator JSON_READ_NUMBERS_AS_DOUBLE_VALIDATOR = new TypeValidators.BooleanValidator("store.json.read_numbers_as_double", new OptionValidator.OptionDescription("Reads numbers with or without a decimal point as DOUBLE. Prevents schema change errors."));
    public static final String MONGO_ALL_TEXT_MODE = "store.mongo.all_text_mode";
    public static final OptionValidator MONGO_READER_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.mongo.all_text_mode", new OptionValidator.OptionDescription("Similar to store.json.all_text_mode for MongoDB."));
    public static final String MONGO_READER_READ_NUMBERS_AS_DOUBLE = "store.mongo.read_numbers_as_double";
    public static final OptionValidator MONGO_READER_READ_NUMBERS_AS_DOUBLE_VALIDATOR = new TypeValidators.BooleanValidator("store.mongo.read_numbers_as_double", new OptionValidator.OptionDescription("Similar to store.json.read_numbers_as_double."));
    public static final String MONGO_BSON_RECORD_READER = "store.mongo.bson.record.reader";
    public static final OptionValidator MONGO_BSON_RECORD_READER_VALIDATOR = new TypeValidators.BooleanValidator("store.mongo.bson.record.reader", null);
    public static final String ENABLE_UNION_TYPE_KEY = "exec.enable_union_type";
    public static final TypeValidators.BooleanValidator ENABLE_UNION_TYPE = new TypeValidators.BooleanValidator("exec.enable_union_type", new OptionValidator.OptionDescription("Enable support for Avro union type."));
    public static final String EXCEPT_ADD_AGG_BELOW_KEY = "exec.except_add_agg_below";
    public static final TypeValidators.BooleanValidator EXCEPT_ADD_AGG_BELOW = new TypeValidators.BooleanValidator("exec.except_add_agg_below", new OptionValidator.OptionDescription("Add agg below setop for left input when doing except, otherwise above setop"));
    public static final String KAFKA_ALL_TEXT_MODE = "store.kafka.all_text_mode";
    public static final OptionValidator KAFKA_READER_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.kafka.all_text_mode", new OptionValidator.OptionDescription("Similar to store.json.all_text_mode for Kafka."));
    public static final String KAFKA_READER_READ_NUMBERS_AS_DOUBLE = "store.kafka.read_numbers_as_double";
    public static final OptionValidator KAFKA_READER_READ_NUMBERS_AS_DOUBLE_VALIDATOR = new TypeValidators.BooleanValidator("store.kafka.read_numbers_as_double", new OptionValidator.OptionDescription("Similar to store.json.read_numbers_as_double."));
    public static final String KAFKA_RECORD_READER = "store.kafka.record.reader";
    public static final OptionValidator KAFKA_RECORD_READER_VALIDATOR = new TypeValidators.StringValidator("store.kafka.record.reader", new OptionValidator.OptionDescription("The Kafka record reader configured to read incoming messages from Kafka."));
    public static final String KAFKA_POLL_TIMEOUT = "store.kafka.poll.timeout";
    public static final TypeValidators.PositiveLongValidator KAFKA_POLL_TIMEOUT_VALIDATOR = new TypeValidators.PositiveLongValidator("store.kafka.poll.timeout", Long.MAX_VALUE, new OptionValidator.OptionDescription("Amount of time in milliseconds allotted to the Kafka client to fetch messages from the Kafka cluster; default value is 200."));
    public static final String KAFKA_READER_SKIP_INVALID_RECORDS = "store.kafka.reader.skip_invalid_records";
    public static final TypeValidators.BooleanValidator KAFKA_SKIP_MALFORMED_RECORDS_VALIDATOR = new TypeValidators.BooleanValidator("store.kafka.reader.skip_invalid_records", new OptionValidator.OptionDescription("Allows queries to progress when the JSON record reader skips bad records in JSON files. Default is false. (Drill 1.17+)"));
    public static final String KAFKA_READER_NAN_INF_NUMBERS = "store.kafka.reader.allow_nan_inf";
    public static final TypeValidators.BooleanValidator KAFKA_READER_NAN_INF_NUMBERS_VALIDATOR = new TypeValidators.BooleanValidator("store.kafka.reader.allow_nan_inf", new OptionValidator.OptionDescription("Enables the Kafka JSON record reader in Drill to read `NaN` and `Infinity` tokens in JSON data as numbers. Default is true. (Drill 1.17+)"));
    public static final String KAFKA_READER_ESCAPE_ANY_CHAR = "store.kafka.reader.allow_escape_any_char";
    public static final TypeValidators.BooleanValidator KAFKA_READER_ESCAPE_ANY_CHAR_VALIDATOR = new TypeValidators.BooleanValidator("store.kafka.reader.allow_escape_any_char", new OptionValidator.OptionDescription("Enables the Kafka JSON record reader in Drill to escape any character. Default is false. (Drill 1.17+)"));
    @Deprecated
    public static final String HIVE_OPTIMIZE_SCAN_WITH_NATIVE_READERS = "store.hive.optimize_scan_with_native_readers";
    @Deprecated
    public static final OptionValidator HIVE_OPTIMIZE_SCAN_WITH_NATIVE_READERS_VALIDATOR = new TypeValidators.BooleanValidator("store.hive.optimize_scan_with_native_readers", new OptionValidator.OptionDescription("Deprecated as of Drill 1.14. Use the store.hive.parquet.optimize_scan_with_native_reader option instead. Enables Drill to use the Drill native reader (instead of the Hive Serde interface) to optimize reads of Parquet-backed tables from Hive. Default is false."));
    public static final String HIVE_OPTIMIZE_PARQUET_SCAN_WITH_NATIVE_READER = "store.hive.parquet.optimize_scan_with_native_reader";
    public static final OptionValidator HIVE_OPTIMIZE_PARQUET_SCAN_WITH_NATIVE_READER_VALIDATOR = new TypeValidators.BooleanValidator("store.hive.parquet.optimize_scan_with_native_reader", new OptionValidator.OptionDescription("Optimize reads of Parquet-backed external tables from Hive by using Drill native readers instead of the Hive Serde interface. (Drill 1.2+)"));
    public static final String HIVE_OPTIMIZE_MAPRDB_JSON_SCAN_WITH_NATIVE_READER = "store.hive.maprdb_json.optimize_scan_with_native_reader";
    public static final OptionValidator HIVE_OPTIMIZE_MAPRDB_JSON_SCAN_WITH_NATIVE_READER_VALIDATOR = new TypeValidators.BooleanValidator("store.hive.maprdb_json.optimize_scan_with_native_reader", new OptionValidator.OptionDescription("Enables Drill to use the Drill native reader (instead of the Hive Serde interface) to optimize reads of MapR Database JSON tables from Hive. Default is false. (Drill 1.14+)"));
    public static final String HIVE_READ_MAPRDB_JSON_TIMESTAMP_WITH_TIMEZONE_OFFSET = "store.hive.maprdb_json.read_timestamp_with_timezone_offset";
    public static final OptionValidator HIVE_READ_MAPRDB_JSON_TIMESTAMP_WITH_TIMEZONE_OFFSET_VALIDATOR = new TypeValidators.BooleanValidator("store.hive.maprdb_json.read_timestamp_with_timezone_offset", new OptionValidator.OptionDescription("Enables Drill to read timestamp values with timezone offset when Hive plugin is used and Drill native MaprDB JSON reader usage is enabled. (Drill 1.16+)"));
    public static final String HIVE_MAPRDB_JSON_ALL_TEXT_MODE = "store.hive.maprdb_json.all_text_mode";
    public static final OptionValidator HIVE_MAPRDB_JSON_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.hive.maprdb_json.all_text_mode", new OptionValidator.OptionDescription("Drill reads all data from the maprDB Json tables as VARCHAR when hive plugin is used and Drill native MaprDB JSON reader usage is enabled. Prevents schema change errors. (Drill 1.17+)"));
    public static final String HIVE_CONF_PROPERTIES = "store.hive.conf.properties";
    public static final OptionValidator HIVE_CONF_PROPERTIES_VALIDATOR = new TypeValidators.StringValidator("store.hive.conf.properties", new OptionValidator.OptionDescription("Enables the user to specify Hive properties at the session level. Do not set the property values in quotes. Separate the property name and value by =. Separate each property with a new line (\\n). Example: set `store.hive.conf.properties` = 'hive.mapred.supports.subdirectories=true\\nmapred.input.dir.recursive=true'. (Drill 1.14+)"));
    public static final String SLICE_TARGET = "planner.slice_target";
    public static final long SLICE_TARGET_DEFAULT = 100000L;
    public static final TypeValidators.PositiveLongValidator SLICE_TARGET_OPTION = new TypeValidators.PositiveLongValidator("planner.slice_target", Long.MAX_VALUE, new OptionValidator.OptionDescription("The number of records manipulated within a fragment before Drill parallelizes operations."));
    public static final String CAST_EMPTY_STRING_TO_NULL = "drill.exec.functions.cast_empty_string_to_null";
    public static final TypeValidators.BooleanValidator CAST_EMPTY_STRING_TO_NULL_OPTION = new TypeValidators.BooleanValidator("drill.exec.functions.cast_empty_string_to_null", new OptionValidator.OptionDescription("In a text file, treat empty fields as NULL values instead of empty string."));
    public static final String MIN_HASH_TABLE_SIZE_KEY = "exec.min_hash_table_size";
    public static final TypeValidators.PositiveLongValidator MIN_HASH_TABLE_SIZE = new TypeValidators.PositiveLongValidator("exec.min_hash_table_size", 0x40000000L, new OptionValidator.OptionDescription("Starting size in bucketsfor hash tables. Increase according to available memory to improve performance. Increasing for very large aggregations or joins when you have large amounts of memory for Drill to use. Range: 0 - 1073741824."));
    public static final String MAX_HASH_TABLE_SIZE_KEY = "exec.max_hash_table_size";
    public static final TypeValidators.PositiveLongValidator MAX_HASH_TABLE_SIZE = new TypeValidators.PositiveLongValidator("exec.max_hash_table_size", 0x40000000L, new OptionValidator.OptionDescription("Ending size in buckets for hash tables. Range: 0 - 1073741824."));
    public static final String CPU_LOAD_AVERAGE_KEY = "planner.cpu_load_average";
    public static final TypeValidators.DoubleValidator CPU_LOAD_AVERAGE = new TypeValidators.DoubleValidator("planner.cpu_load_average", new OptionValidator.OptionDescription("Limits the maximum level of parallelization to this factor time the number of Drillbits"));
    public static final String MAX_WIDTH_PER_NODE_KEY = "planner.width.max_per_node";
    public static final TypeValidators.MaxWidthValidator MAX_WIDTH_PER_NODE = new TypeValidators.MaxWidthValidator("planner.width.max_per_node", new OptionValidator.OptionDescription("Maximum number of threads that can run in parallel for a query on a node. A slice is an individual thread. This number indicates the maximum number of slices per query for the query's major fragment on a node.", "Max number of threads that can run in parallel for a query on a node."));
    public static final String MAX_WIDTH_GLOBAL_KEY = "planner.width.max_per_query";
    public static final OptionValidator MAX_WIDTH_GLOBAL = new TypeValidators.PositiveLongValidator("planner.width.max_per_query", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Same as max per node but applies to the query as executed by the entire cluster. For example, this value might be the number of active Drillbits, or a higher number to return results faster."));
    public static final String AFFINITY_FACTOR_KEY = "planner.affinity_factor";
    public static final OptionValidator AFFINITY_FACTOR = new TypeValidators.DoubleValidator("planner.affinity_factor", new OptionValidator.OptionDescription("Factor by which a node with endpoint affinity will be favored while creating assignment"));
    public static final String EARLY_LIMIT0_OPT_KEY = "planner.enable_limit0_optimization";
    public static final TypeValidators.BooleanValidator EARLY_LIMIT0_OPT = new TypeValidators.BooleanValidator("planner.enable_limit0_optimization", new OptionValidator.OptionDescription("Enables the query planner to determine data types returned by a query during the planning phase before scanning data. Default is true. (Drill 1.9+)"));
    public static final String LATE_LIMIT0_OPT_KEY = "planner.enable_limit0_on_scan";
    public static final TypeValidators.BooleanValidator LATE_LIMIT0_OPT = new TypeValidators.BooleanValidator("planner.enable_limit0_on_scan", new OptionValidator.OptionDescription("Enables Drill to determine data types as Drill scans data. This optimization is used when the query planner cannot infer types of columns during validation (prior to scanning). Drill exits and terminates the query immediately after resolving the types. When this optimization is applied, the query plan contains a LIMIT (0) above every SCAN, with an optional PROJECT in between. Default is true. (Drill 1.14+)"));
    public static final String FILE_LISTING_LIMIT0_OPT_KEY = "planner.enable_file_listing_limit0_optimization";
    public static final TypeValidators.BooleanValidator FILE_LISTING_LIMIT0_OPT = new TypeValidators.BooleanValidator("planner.enable_file_listing_limit0_optimization", new OptionValidator.OptionDescription("For internal use. Do not change."));
    public static final String ENABLE_MEMORY_ESTIMATION_KEY = "planner.memory.enable_memory_estimation";
    public static final OptionValidator ENABLE_MEMORY_ESTIMATION = new TypeValidators.BooleanValidator("planner.memory.enable_memory_estimation", new OptionValidator.OptionDescription("Toggles the state of memory estimation and re-planning of the query. When enabled, Drill conservatively estimates memory requirements and typically excludes these operators from the plan and negatively impacts performance."));
    public static final String MAX_QUERY_MEMORY_PER_NODE_KEY = "planner.memory.max_query_memory_per_node";
    public static final TypeValidators.LongValidator MAX_QUERY_MEMORY_PER_NODE = new TypeValidators.RangeLongValidator("planner.memory.max_query_memory_per_node", 0x100000L, DrillConfig.getMaxDirectMemory(), new OptionValidator.OptionDescription("Sets the maximum amount of direct memory allocated to the Sort and Hash Aggregate operators during each query on a node. This memory is split between operators. If a query plan contains multiple Sort and/or Hash Aggregate operators, the memory is divided between them. The default limit should be increased for queries on large data sets."));
    public static String PERCENT_MEMORY_PER_QUERY_KEY = "planner.memory.percent_per_query";
    public static TypeValidators.DoubleValidator PERCENT_MEMORY_PER_QUERY = new TypeValidators.RangeDoubleValidator(PERCENT_MEMORY_PER_QUERY_KEY, 0.0, 1.0, new OptionValidator.OptionDescription("Sets the memory as a percentage of the total direct memory."));
    public static final String MIN_MEMORY_PER_BUFFERED_OP_KEY = "planner.memory.min_memory_per_buffered_op";
    public static final TypeValidators.LongValidator MIN_MEMORY_PER_BUFFERED_OP = new TypeValidators.RangeLongValidator("planner.memory.min_memory_per_buffered_op", 0x100000L, Long.MAX_VALUE, new OptionValidator.OptionDescription("Minimum memory allocated to each buffered operator instance"));
    public static final String NON_BLOCKING_OPERATORS_MEMORY_KEY = "planner.memory.non_blocking_operators_memory";
    public static final OptionValidator NON_BLOCKING_OPERATORS_MEMORY = new TypeValidators.PowerOfTwoLongValidator("planner.memory.non_blocking_operators_memory", 2048L, new OptionValidator.OptionDescription("Extra query memory per node for non-blocking operators. This option is currently used only for memory estimation. Range: 0-2048 MB"));
    public static final String HASH_JOIN_TABLE_FACTOR_KEY = "planner.memory.hash_join_table_factor";
    public static final OptionValidator HASH_JOIN_TABLE_FACTOR = new TypeValidators.DoubleValidator("planner.memory.hash_join_table_factor", new OptionValidator.OptionDescription("A heuristic value for influencing the size of the hash aggregation table."));
    public static final String HASH_AGG_TABLE_FACTOR_KEY = "planner.memory.hash_agg_table_factor";
    public static final OptionValidator HASH_AGG_TABLE_FACTOR = new TypeValidators.DoubleValidator("planner.memory.hash_agg_table_factor", new OptionValidator.OptionDescription("A heuristic value for influencing the size of the hash aggregation table."));
    public static final String AVERAGE_FIELD_WIDTH_KEY = "planner.memory.average_field_width";
    public static final OptionValidator AVERAGE_FIELD_WIDTH = new TypeValidators.PositiveLongValidator("planner.memory.average_field_width", Long.MAX_VALUE, new OptionValidator.OptionDescription("Used in estimating memory requirements."));
    public static final String ORDERED_MUX_EXCHANGE = "planner.enable_ordered_mux_exchange";
    public static final String RM_ENABLED = "drill.exec.rm.enabled";
    public static final String MAX_MEMORY_PER_NODE = "drill.exec.rm.memory_per_node";
    public static final String MAX_CPUS_PER_NODE = "drill.exec.rm.cpus_per_node";
    public static final TypeValidators.BooleanValidator ENABLE_QUEUE = new TypeValidators.BooleanValidator("exec.queue.enable", new OptionValidator.OptionDescription("Changes the state of query queues. False allows unlimited concurrent queries."));
    public static final TypeValidators.LongValidator LARGE_QUEUE_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.large", 10000L, new OptionValidator.OptionDescription("Sets the number of large queries that can run concurrently in the cluster. Range: 0-1000"));
    public static final TypeValidators.LongValidator SMALL_QUEUE_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.small", 100000L, new OptionValidator.OptionDescription("Sets the number of small queries that can run concurrently in the cluster. Range: 0-1001"));
    public static final TypeValidators.LongValidator QUEUE_THRESHOLD_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.threshold", Long.MAX_VALUE, new OptionValidator.OptionDescription("Sets the cost threshold, which depends on the complexity of the queries in queue, for determining whether query is large or small. Complex queries have higher thresholds. Range: 0-9223372036854775807"));
    public static final TypeValidators.LongValidator QUEUE_TIMEOUT = new TypeValidators.PositiveLongValidator("exec.queue.timeout_millis", Long.MAX_VALUE, new OptionValidator.OptionDescription("Indicates how long a query can wait in queue before the query fails. Range: 0-9223372036854775807"));
    public static final String RM_QUERY_TAGS_KEY = "exec.rm.queryTags";
    public static final TypeValidators.StringValidator RM_QUERY_TAGS_VALIDATOR = new TypeValidators.StringValidator("exec.rm.queryTags", new OptionValidator.OptionDescription("Allows user to set coma separated list of tags for all the queries submitted over a session"));
    public static final String RM_QUEUES_WAIT_FOR_PREFERRED_NODES_KEY = "exec.rm.queues.wait_for_preferred_nodes";
    public static final TypeValidators.BooleanValidator RM_QUEUES_WAIT_FOR_PREFERRED_NODES_VALIDATOR = new TypeValidators.BooleanValidator("exec.rm.queues.wait_for_preferred_nodes", new OptionValidator.OptionDescription("Allows user to enable/disable wait_for_preferred_nodes configuration across rm queues for all the queries submitted over a session"));
    public static final TypeValidators.DoubleValidator QUEUE_MEMORY_RATIO = new TypeValidators.RangeDoubleValidator("exec.queue.memory_ratio", 1.0, 1000.0, null);
    public static final TypeValidators.DoubleValidator QUEUE_MEMORY_RESERVE = new TypeValidators.RangeDoubleValidator("exec.queue.memory_reserve_ratio", 0.0, 1.0, null);
    public static final String ENABLE_VERBOSE_ERRORS_KEY = "exec.errors.verbose";
    public static final OptionValidator ENABLE_VERBOSE_ERRORS = new TypeValidators.BooleanValidator("exec.errors.verbose", new OptionValidator.OptionDescription("Toggles verbose output of executable error messages"));
    @Deprecated
    public static final String ENABLE_NEW_TEXT_READER_KEY = "exec.storage.enable_new_text_reader";
    @Deprecated
    public static final OptionValidator ENABLE_NEW_TEXT_READER = new TypeValidators.BooleanValidator("exec.storage.enable_new_text_reader", new OptionValidator.OptionDescription("Deprecated. Drill's text reader complies with the RFC 4180 standard for text/csv files."));
    @Deprecated
    public static final String ENABLE_V3_TEXT_READER_KEY = "exec.storage.enable_v3_text_reader";
    @Deprecated
    public static final OptionValidator ENABLE_V3_TEXT_READER = new TypeValidators.BooleanValidator("exec.storage.enable_v3_text_reader", new OptionValidator.OptionDescription("Deprecated. The \"V3\" text reader is always used."));
    public static final String MIN_READER_WIDTH_KEY = "exec.storage.min_width";
    public static final OptionValidator MIN_READER_WIDTH = new TypeValidators.LongValidator("exec.storage.min_width", new OptionValidator.OptionDescription("Min width for text readers, mostly for testing."));
    public static final String SKIP_RUNTIME_ROWGROUP_PRUNING_KEY = "exec.storage.skip_runtime_rowgroup_pruning";
    public static final OptionValidator SKIP_RUNTIME_ROWGROUP_PRUNING = new TypeValidators.BooleanValidator("exec.storage.skip_runtime_rowgroup_pruning", new OptionValidator.OptionDescription("Enables skipping the runtime pruning of the rowgroups"));
    public static final String DRILL_SYS_FILE_SUFFIX = ".sys.drill";
    public static final String ENABLE_WINDOW_FUNCTIONS = "window.enable";
    public static final OptionValidator ENABLE_WINDOW_FUNCTIONS_VALIDATOR = new TypeValidators.BooleanValidator("window.enable", new OptionValidator.OptionDescription("Enable or disable window functions in Drill 1.1+"));
    public static final String DRILLBIT_CONTROL_INJECTIONS = "drill.exec.testing.controls";
    public static final OptionValidator DRILLBIT_CONTROLS_VALIDATOR = new ExecutionControls.ControlsOptionValidator("drill.exec.testing.controls", 1, null);
    public static final String NEW_VIEW_DEFAULT_PERMS_KEY = "new_view_default_permissions";
    public static final OptionValidator NEW_VIEW_DEFAULT_PERMS_VALIDATOR = new TypeValidators.StringValidator("new_view_default_permissions", new OptionValidator.OptionDescription("Sets view permissions using an octal code in the Unix tradition."));
    public static final String CTAS_PARTITIONING_HASH_DISTRIBUTE = "store.partition.hash_distribute";
    public static final TypeValidators.BooleanValidator CTAS_PARTITIONING_HASH_DISTRIBUTE_VALIDATOR = new TypeValidators.BooleanValidator("store.partition.hash_distribute", new OptionValidator.OptionDescription("Uses a hash algorithm to distribute data on partition keys in a CTAS partitioning operation. An alpha option--for experimental use at this stage. Do not use in production systems."));
    @Deprecated
    public static final String ENABLE_BULK_LOAD_TABLE_LIST_KEY = "exec.enable_bulk_load_table_list";
    @Deprecated
    public static final TypeValidators.BooleanValidator ENABLE_BULK_LOAD_TABLE_LIST = new TypeValidators.BooleanValidator("exec.enable_bulk_load_table_list", new OptionValidator.OptionDescription("Deprecated after DRILL-7115 improvement."));
    @Deprecated
    public static final String BULK_LOAD_TABLE_LIST_BULK_SIZE_KEY = "exec.bulk_load_table_list.bulk_size";
    @Deprecated
    public static final TypeValidators.PositiveLongValidator BULK_LOAD_TABLE_LIST_BULK_SIZE = new TypeValidators.PositiveLongValidator("exec.bulk_load_table_list.bulk_size", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Deprecated after DRILL-7115 improvement."));
    public static final String ADMIN_USERS_KEY = "security.admin.users";
    public static final TypeValidators.AdminUsersValidator ADMIN_USERS_VALIDATOR = new TypeValidators.AdminUsersValidator("security.admin.users", new OptionValidator.OptionDescription("A comma-separated list of user names with administrator privileges."));
    public static final String ADMIN_USER_GROUPS_KEY = "security.admin.user_groups";
    public static final TypeValidators.AdminUserGroupsValidator ADMIN_USER_GROUPS_VALIDATOR = new TypeValidators.AdminUserGroupsValidator("security.admin.user_groups", new OptionValidator.OptionDescription("A comma-separated list of user groups with administrator privileges."));
    public static final String IMPERSONATION_POLICIES_KEY = "exec.impersonation.inbound_policies";
    public static final TypeValidators.StringValidator IMPERSONATION_POLICY_VALIDATOR = new InboundImpersonationManager.InboundImpersonationPolicyValidator("exec.impersonation.inbound_policies");
    public static final String WEB_LOGS_MAX_LINES = "web.logs.max_lines";
    public static final OptionValidator WEB_LOGS_MAX_LINES_VALIDATOR = new TypeValidators.PositiveLongValidator("web.logs.max_lines", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Provides the maximum number of log file lines that display on the Logs tab in the Drill Web UI. (Drill 1.7+)"));
    public static final String WEB_DISPLAY_FORMAT_TIMESTAMP = "web.display_format.timestamp";
    public static final OptionValidator WEB_DISPLAY_FORMAT_TIMESTAMP_VALIDATOR = new TypeValidators.DateTimeFormatValidator("web.display_format.timestamp", new OptionValidator.OptionDescription("Display format template for timestamp. It will be passed to java.time.format.DateTimeFormatter. See https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html for the details about acceptable patterns. If empty then the default formatting will be used. (Drill 1.15+)"));
    public static final String WEB_DISPLAY_FORMAT_DATE = "web.display_format.date";
    public static final OptionValidator WEB_DISPLAY_FORMAT_DATE_VALIDATOR = new TypeValidators.DateTimeFormatValidator("web.display_format.date", new OptionValidator.OptionDescription("Display format template for date. It will be passed to java.time.format.DateTimeFormatter. See https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html for the details about acceptable patterns. If empty then the default formatting will be used. (Drill 1.15+)"));
    public static final String WEB_DISPLAY_FORMAT_TIME = "web.display_format.time";
    public static final OptionValidator WEB_DISPLAY_FORMAT_TIME_VALIDATOR = new TypeValidators.DateTimeFormatValidator("web.display_format.time", new OptionValidator.OptionDescription("Display format template for time. It will be passed to java.time.format.DateTimeFormatter. See https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html for the details about acceptable patterns. If empty then the default formatting will be used. (Drill 1.15+)"));
    public static final String CODE_GEN_EXP_IN_METHOD_SIZE = "exec.java.compiler.exp_in_method_size";
    public static final TypeValidators.LongValidator CODE_GEN_EXP_IN_METHOD_SIZE_VALIDATOR = new TypeValidators.LongValidator("exec.java.compiler.exp_in_method_size", new OptionValidator.OptionDescription("Introduced in Drill 1.8. For queries with complex or multiple expressions in the query logic, this option limits the number of expressions allowed in each method to prevent Drill from generating code that exceeds the Java limit of 64K bytes. If a method approaches the 64K limit, the Java compiler returns a message stating that the code is too large to compile. If queries return such a message, reduce the value of this option at the session level. The default value for this option is 50. The value is the count of expressions allowed in a method. Expressions are added to a method until they hit the Java 64K limit, when a new inner method is created and called from the existing method. Note: This logic has not been implemented for all operators. If a query uses operators for which the logic is not implemented, reducing the setting for this option may not resolve the error. Setting this option at the system level impacts all queries and can degrade query performance."));
    public static final String CREATE_PREPARE_STATEMENT_TIMEOUT_MILLIS = "prepare.statement.create_timeout_ms";
    public static final OptionValidator CREATE_PREPARE_STATEMENT_TIMEOUT_MILLIS_VALIDATOR = new TypeValidators.PositiveLongValidator("prepare.statement.create_timeout_ms", Integer.MAX_VALUE, null);
    public static final String DYNAMIC_UDF_SUPPORT_ENABLED = "exec.udf.enable_dynamic_support";
    public static final TypeValidators.BooleanValidator DYNAMIC_UDF_SUPPORT_ENABLED_VALIDATOR = new TypeValidators.BooleanValidator("exec.udf.enable_dynamic_support", new OptionValidator.OptionDescription("Enables users to dynamically upload UDFs. Users must upload their UDF (source and binary) JAR files to a staging directory in the distributed file system before issuing the CREATE FUNCTION USING JAR command to register a UDF. Default is true. (Drill 1.9+)"));
    public static final String PROFILE_STATISTICS_ESTIMATED_ROWS_SHOW = "drill.exec.http.profile.statistics.estimated_rows.show";
    public static final String PROFILE_WARNING_PROGRESS_THRESHOLD = "drill.exec.http.profile.warning.progress.threshold";
    public static final String PROFILE_WARNING_TIME_SKEW_MIN = "drill.exec.http.profile.warning.time.skew.min";
    public static final String PROFILE_WARNING_TIME_SKEW_RATIO_PROCESS = "drill.exec.http.profile.warning.time.skew.ratio.process";
    public static final String PROFILE_WARNING_SCAN_WAIT_MIN = "drill.exec.http.profile.warning.scan.wait.min";
    public static final String PROFILE_WARNING_TIME_SKEW_RATIO_WAIT = "drill.exec.http.profile.warning.time.skew.ratio.wait";
    public static final String ENABLE_QUERY_PROFILE_OPTION = "exec.query_profile.save";
    public static final TypeValidators.BooleanValidator ENABLE_QUERY_PROFILE_VALIDATOR = new TypeValidators.BooleanValidator("exec.query_profile.save", new OptionValidator.OptionDescription("Save completed profiles to the persistent store"));
    public static final String SKIP_ALTER_SESSION_QUERY_PROFILE = "exec.query_profile.alter_session.skip";
    public static final TypeValidators.BooleanValidator SKIP_SESSION_QUERY_PROFILE_VALIDATOR = new TypeValidators.BooleanValidator("exec.query_profile.alter_session.skip", new OptionValidator.OptionDescription("Skip saving ALTER SESSION profiles"));
    public static final String QUERY_PROFILE_MASKING_RULES_CONFIG_PATH = "drill.exec.query_profile.masking_rules.config_path";
    public static final String QUERY_PROFILE_DEBUG_OPTION = "exec.query_profile.debug_mode";
    public static final TypeValidators.BooleanValidator QUERY_PROFILE_DEBUG_VALIDATOR = new TypeValidators.BooleanValidator("exec.query_profile.debug_mode", null);
    public static final String USE_DYNAMIC_UDFS_KEY = "exec.udf.use_dynamic";
    public static final TypeValidators.BooleanValidator USE_DYNAMIC_UDFS = new TypeValidators.BooleanValidator("exec.udf.use_dynamic", new OptionValidator.OptionDescription("Enables Drill to build an operator table for built-in static functions and then reuse the table across queries. Drill uses the operator table for all queries that do not need dynamic UDF support. The operator table does not include dynamic UDFs. Default is true. (Drill 1.10+)"));
    public static final String QUERY_TRANSIENT_STATE_UPDATE_KEY = "exec.query.progress.update";
    public static final TypeValidators.BooleanValidator QUERY_TRANSIENT_STATE_UPDATE = new TypeValidators.BooleanValidator("exec.query.progress.update", null);
    public static final String PERSISTENT_TABLE_UMASK = "exec.persistent_table.umask";
    public static final TypeValidators.StringValidator PERSISTENT_TABLE_UMASK_VALIDATOR = new TypeValidators.StringValidator("exec.persistent_table.umask", new OptionValidator.OptionDescription("Enables users to modify permissions on directories and files that result from running the CTAS command. The default is 002, which sets the default directory permissions to 775 and default file permissions to 664. (Drill 1.11+)"));
    public static final String ENABLE_ITERATOR_VALIDATION_OPTION = "debug.validate_iterators";
    public static final TypeValidators.BooleanValidator ENABLE_ITERATOR_VALIDATOR = new TypeValidators.BooleanValidator("debug.validate_iterators", null);
    public static final String ENABLE_ITERATOR_VALIDATION = "drill.exec.debug.validate_iterators";
    public static final String QUERY_ROWKEYJOIN_BATCHSIZE_KEY = "exec.query.rowkeyjoin_batchsize";
    public static final TypeValidators.PositiveLongValidator QUERY_ROWKEYJOIN_BATCHSIZE = new TypeValidators.PositiveLongValidator("exec.query.rowkeyjoin_batchsize", Long.MAX_VALUE, new OptionValidator.OptionDescription("Batch size (in terms of number of rows) for a 'bulk get' operation from the underlying data source during a RowKeyJoin."));
    public static final String ENABLE_VECTOR_VALIDATION_OPTION = "debug.validate_vectors";
    public static final TypeValidators.BooleanValidator ENABLE_VECTOR_VALIDATOR = new TypeValidators.BooleanValidator("debug.validate_vectors", null);
    public static final String ENABLE_VECTOR_VALIDATION = "drill.exec.debug.validate_vectors";
    public static final String OPTION_DEFAULTS_ROOT = "drill.exec.options.";
    public static final String GRACE_PERIOD = "drill.exec.grace_period_ms";
    public static final String DRILL_PORT_HUNT = "drill.exec.port_hunt";
    public static final String ALLOW_LOOPBACK_ADDRESS_BINDING = "drill.exec.allow_loopback_address_binding";
    public static final String STATS_LOGGING_BATCH_SIZE_OPTION = "drill.exec.stats.logging.batch_size";
    public static final TypeValidators.BooleanValidator STATS_LOGGING_BATCH_SIZE_VALIDATOR = new TypeValidators.BooleanValidator("drill.exec.stats.logging.batch_size", new OptionValidator.OptionDescription("Enables batch size statistics logging."));
    public static final String STATS_LOGGING_FG_BATCH_SIZE_OPTION = "drill.exec.stats.logging.fine_grained.batch_size";
    public static final TypeValidators.BooleanValidator STATS_LOGGING_BATCH_FG_SIZE_VALIDATOR = new TypeValidators.BooleanValidator("drill.exec.stats.logging.fine_grained.batch_size", new OptionValidator.OptionDescription("Enables fine-grained batch size statistics logging."));
    public static final String STATS_LOGGING_BATCH_OPERATOR_OPTION = "drill.exec.stats.logging.enabled_operators";
    public static final TypeValidators.StringValidator STATS_LOGGING_BATCH_OPERATOR_VALIDATOR = new TypeValidators.StringValidator("drill.exec.stats.logging.enabled_operators", new OptionValidator.OptionDescription("Controls the list of operators for which batch sizing statistics should be enabled."));
    public static final String LIST_FILES_RECURSIVELY = "storage.list_files_recursively";
    public static final TypeValidators.BooleanValidator LIST_FILES_RECURSIVELY_VALIDATOR = new TypeValidators.BooleanValidator("storage.list_files_recursively", new OptionValidator.OptionDescription("Enables recursive files listing when querying the `INFORMATION_SCHEMA.FILES` table or executing the SHOW FILES command. Default is false. (Drill 1.15+)"));
    public static final String STORAGE_PLUGIN_RETRY_ATTEMPTS = "storage.plugin_retry_attempts";
    public static final TypeValidators.LongValidator STORAGE_PLUGIN_RETRY_ATTEMPTS_VALIDATOR = new TypeValidators.NonNegativeLongValidator("storage.plugin_retry_attempts", 10L, new OptionValidator.OptionDescription("The maximum number of retries that will be attempted to request metadata for query planning from a storage plugin."));
    public static final String STORAGE_PLUGIN_RETRY_DELAY = "storage.plugin_retry_attempt_delay";
    public static final TypeValidators.LongValidator STORAGE_PLUGIN_RETRY_DELAY_VALIDATOR = new TypeValidators.NonNegativeLongValidator("storage.plugin_retry_attempt_delay", 5000L, new OptionValidator.OptionDescription(String.format("The delay in milliseconds between repeated attempts to request metadata for query planning from a storage plugin (see %s).", "storage.plugin_retry_attempts")));
    public static final String STORAGE_PLUGIN_AUTO_DISABLE = "storage.plugin_auto_disable";
    public static final TypeValidators.BooleanValidator STORAGE_PLUGIN_AUTO_DISABLE_VALIDATOR = new TypeValidators.BooleanValidator("storage.plugin_auto_disable", new OptionValidator.OptionDescription(String.format("Controls whether a storage plugin will automatically be disabled after the configured number of attempts to request metadata for query  planning from it have failed (see %s)", "storage.plugin_retry_attempts")));
    public static final String RETURN_RESULT_SET_FOR_DDL = "exec.query.return_result_set_for_ddl";
    public static final TypeValidators.BooleanValidator RETURN_RESULT_SET_FOR_DDL_VALIDATOR = new TypeValidators.BooleanValidator("exec.query.return_result_set_for_ddl", new OptionValidator.OptionDescription("Controls whether to return result set for CREATE TABLE / VIEW / FUNCTION, DROP TABLE / VIEW / FUNCTION, SET, USE, REFRESH METADATA TABLE queries. If set to false affected rows count will be returned instead and result set will be null. Affects JDBC connections only. Default is true. (Drill 1.15+)"));
    public static final String HLL_ACCURACY = "exec.statistics.ndv_accuracy";
    public static final TypeValidators.LongValidator HLL_ACCURACY_VALIDATOR = new TypeValidators.PositiveLongValidator("exec.statistics.ndv_accuracy", 30L, new OptionValidator.OptionDescription("Controls trade-off between NDV statistic computation memory cost and accuracy"));
    public static final String DETERMINISTIC_SAMPLING = "exec.statistics.deterministic_sampling";
    public static final TypeValidators.BooleanValidator DETERMINISTIC_SAMPLING_VALIDATOR = new TypeValidators.BooleanValidator("exec.statistics.deterministic_sampling", new OptionValidator.OptionDescription("Deterministic sampling"));
    public static final String NDV_BLOOM_FILTER_ELEMENTS = "exec.statistics.ndv_extrapolation_bf_elements";
    public static final TypeValidators.LongValidator NDV_BLOOM_FILTER_ELEMENTS_VALIDATOR = new TypeValidators.PositiveLongValidator("exec.statistics.ndv_extrapolation_bf_elements", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Controls trade-off between NDV statistic computation memory cost and sampling extrapolation accuracy"));
    public static final String NDV_BLOOM_FILTER_FPOS_PROB = "exec.statistics.ndv_extrapolation_bf_fpprobability";
    public static final TypeValidators.LongValidator NDV_BLOOM_FILTER_FPOS_PROB_VALIDATOR = new TypeValidators.PositiveLongValidator("exec.statistics.ndv_extrapolation_bf_fpprobability", 100L, new OptionValidator.OptionDescription("Controls trade-off between NDV statistic computation memory cost and sampling extrapolation accuracy"));
    public static final String TDIGEST_COMPRESSION = "exec.statistics.tdigest_compression";
    public static final TypeValidators.LongValidator TDIGEST_COMPRESSION_VALIDATOR = new TypeValidators.PositiveLongValidator("exec.statistics.tdigest_compression", 10000L, new OptionValidator.OptionDescription("Controls trade-off between t-digest quantile statistic storage cost and accuracy. Higher values use more groups (clusters) for the t-digest and improve accuracy at the expense of extra storage. "));
    public static final String QUERY_MAX_ROWS = "exec.query.max_rows";
    public static final TypeValidators.RangeLongValidator QUERY_MAX_ROWS_VALIDATOR = new TypeValidators.RangeLongValidator("exec.query.max_rows", 0L, Integer.MAX_VALUE, new OptionValidator.OptionDescription("The maximum number of rows that the query will return. This can be only set at a SYSTEM level by an admin. (Drill 1.16+)"));
    public static final String METASTORE_ENABLED = "metastore.enabled";
    public static final TypeValidators.BooleanValidator METASTORE_ENABLED_VALIDATOR = new TypeValidators.BooleanValidator("metastore.enabled", new OptionValidator.OptionDescription("Enables Drill Metastore usage to be able to store table metadata during ANALYZE TABLE commands execution and to be able to read table metadata during regular queries execution or when querying some INFORMATION_SCHEMA tables. Default is false. (Drill 1.17+)"));
    public static final String METASTORE_METADATA_STORE_DEPTH_LEVEL = "metastore.metadata.store.depth_level";
    public static final TypeValidators.EnumeratedStringValidator METASTORE_METADATA_STORE_DEPTH_LEVEL_VALIDATOR = new TypeValidators.EnumeratedStringValidator("metastore.metadata.store.depth_level", new OptionValidator.OptionDescription("Specifies maximum level depth for collecting metadata. Default is 'ALL'. (Drill 1.17+)"), "TABLE", "SEGMENT", "PARTITION", "FILE", "ROW_GROUP", "ALL");
    public static final String METASTORE_USE_SCHEMA_METADATA = "metastore.metadata.use_schema";
    public static final TypeValidators.BooleanValidator METASTORE_USE_SCHEMA_METADATA_VALIDATOR = new TypeValidators.BooleanValidator("metastore.metadata.use_schema", new OptionValidator.OptionDescription("Enables schema usage, stored to the Metastore. Default is true. (Drill 1.17+)"));
    public static final String METASTORE_USE_STATISTICS_METADATA = "metastore.metadata.use_statistics";
    public static final TypeValidators.BooleanValidator METASTORE_USE_STATISTICS_METADATA_VALIDATOR = new TypeValidators.BooleanValidator("metastore.metadata.use_statistics", new OptionValidator.OptionDescription("Enables statistics usage, stored in the Metastore, at the planning stage. Default is true. (Drill 1.17+)"));
    public static final String METASTORE_CTAS_AUTO_COLLECT_METADATA = "metastore.metadata.ctas.auto-collect";
    public static final TypeValidators.EnumeratedStringValidator METASTORE_CTAS_AUTO_COLLECT_METADATA_VALIDATOR = new TypeValidators.EnumeratedStringValidator("metastore.metadata.ctas.auto-collect", new OptionValidator.OptionDescription("Specifies whether schema and / or column statistics will be automatically collected for every table after CTAS and CTTAS. This option is not active for now. Default is 'NONE'. (Drill 1.17+)"), "NONE", "ALL", "SCHEMA");
    public static final String METASTORE_FALLBACK_TO_FILE_METADATA = "metastore.metadata.fallback_to_file_metadata";
    public static final TypeValidators.BooleanValidator METASTORE_FALLBACK_TO_FILE_METADATA_VALIDATOR = new TypeValidators.BooleanValidator("metastore.metadata.fallback_to_file_metadata", new OptionValidator.OptionDescription("Allows using file metadata cache for the case when required metadata is absent in the Metastore. Default is true. (Drill 1.17+)"));
    public static final String METASTORE_RETRIEVAL_RETRY_ATTEMPTS = "metastore.retrieval.retry_attempts";
    public static final TypeValidators.IntegerValidator METASTORE_RETRIEVAL_RETRY_ATTEMPTS_VALIDATOR = new TypeValidators.IntegerValidator("metastore.retrieval.retry_attempts", new OptionValidator.OptionDescription("Specifies the number of attempts for retrying query planning after detecting that query metadata is changed. If the number of retries was exceeded, query will be planned without metadata information from the Metastore. Default is 5. (Drill 1.17+)"));
    public static final String PARQUET_READER_ENABLE_MAP_SUPPORT = "store.parquet.reader.enable_map_support";
    public static final TypeValidators.BooleanValidator PARQUET_READER_ENABLE_MAP_SUPPORT_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.reader.enable_map_support", new OptionValidator.OptionDescription("Enables Drill Parquet reader to read Parquet MAP type correctly. (Drill 1.17+)"));
    public static final String BOOTSTRAP_STORAGE_PLUGINS_FILE = "drill.exec.storage.bootstrap.storage";
    public static final String BOOTSTRAP_FORMAT_PLUGINS_FILE = "drill.exec.storage.bootstrap.format";
    public static final String UPGRADE_STORAGE_PLUGINS_FILE = "drill.exec.storage.upgrade.storage";
    public static final String STORAGE_PLUGIN_REGISTRY_IMPL = "drill.exec.storage.registry";
    public static final String ACTION_ON_STORAGE_PLUGINS_OVERRIDE_FILE = "drill.exec.storage.action_on_plugins_override_file";
    public static final String PRIVATE_CONNECTORS = "drill.exec.storage.private_connectors";
    public static final String ENABLE_DYNAMIC_CREDIT_BASED_FC = "exec.enable_dynamic_fc";
    public static final TypeValidators.BooleanValidator ENABLE_DYNAMIC_CREDIT_BASED_FC_VALIDATOR = new TypeValidators.BooleanValidator("exec.enable_dynamic_fc", new OptionValidator.OptionDescription("Enable dynamic credit based flow control.This feature allows the sender to send out its data more rapidly, but you should know that it has a risk to OOM when the system is solving parallel large queries until we have a more accurate resource manager."));
    public static final String ENABLE_ALIASES = "exec.enable_aliases";
    public static final TypeValidators.BooleanValidator ENABLE_ALIASES_VALIDATOR = new TypeValidators.BooleanValidator("exec.enable_aliases", new OptionValidator.OptionDescription("Enable storage and tables aliases functionality. (Drill 1.20+)"));
    public static final String ENABLE_REST_VERBOSE_ERRORS_KEY = "drill.exec.http.rest.errors.verbose";
    public static final OptionValidator ENABLE_REST_VERBOSE_ERRORS = new TypeValidators.BooleanValidator("drill.exec.http.rest.errors.verbose", new OptionValidator.OptionDescription("Toggles verbose output of executable error messages in rest response"));
    public static final String NET_PROXY_BASE = "drill.exec.net_proxy";
    public static final String HTTP_PROXY_URL = "drill.exec.net_proxy.http_url";
    public static final String HTTP_PROXY_TYPE = "drill.exec.net_proxy.http.type";
    public static final String HTTP_PROXY_HOST = "drill.exec.net_proxy.http.host";
    public static final String HTTP_PROXY_PORT = "drill.exec.net_proxy.http.port";
    public static final String HTTP_PROXY_USER_NAME = "drill.exec.net_proxy.http.user_name";
    public static final String HTTP_PROXY_PASSWORD = "drill.exec.net_proxy.http.password";
    public static final String HTTPS_PROXY_URL = "drill.exec.net_proxy.https_url";
    public static final String HTTPS_PROXY_TYPE = "drill.exec.net_proxy.https.type";
    public static final String HTTPS_PROXY_HOST = "drill.exec.net_proxy.https.host";
    public static final String HTTPS_PROXY_PORT = "drill.exec.net_proxy.https.port";
    public static final String HTTPS_PROXY_USER_NAME = "drill.exec.net_proxy.https.user_name";
    public static final String HTTPS_PROXY_PASSWORD = "drill.exec.net_proxy.https.password";

    private ExecConstants() {
    }

    public static String bootDefaultFor(String name) {
        return OPTION_DEFAULTS_ROOT + name;
    }
}

