/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.commons.text.StringEscapeUtils;

public class DrillStringUtils {
    public static String readable(long bytes) {
        int unit = 1024;
        long absBytes = Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%s%.1f %ciB", bytes == absBytes ? "" : "-", (double)absBytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static String unescapeJava(String input) {
        return StringEscapeUtils.unescapeJava(input);
    }

    public static String escapeJava(String input) {
        return StringEscapeUtils.escapeJava(input);
    }

    public static String escapeNewLines(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean sawNewline = false;
        for (int i = 0; i < input.length(); ++i) {
            char curChar = input.charAt(i);
            if (curChar == '\r' || curChar == '\n') {
                if (sawNewline) continue;
                sawNewline = true;
                result.append("\\n");
                continue;
            }
            sawNewline = false;
            result.append(curChar);
        }
        return result.toString();
    }

    public static String escapeSql(String str) {
        return str == null ? null : StringUtils.replace(str, "'", "''");
    }

    public static String toBinaryString(ByteBuf buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DrillStringUtils.appendByte(result, buf.getByte(i));
        }
        return result.toString();
    }

    public static String toBinaryString(byte[] buf) {
        return DrillStringUtils.toBinaryString(buf, 0, buf.length);
    }

    public static String toBinaryString(byte[] buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DrillStringUtils.appendByte(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendByte(StringBuilder result, byte b) {
        int ch = b & 0xFF;
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
            result.append((char)ch);
        } else {
            result.append(String.format("\\x%02X", ch));
        }
    }

    public static int parseBinaryString(ByteBuf str, int strStart, int strEnd, ByteBuf out) {
        int dstEnd = 0;
        for (int i = strStart; i < strEnd; ++i) {
            byte b = str.getByte(i);
            if (b == 92 && strEnd > i + 3 && (str.getByte(i + 1) == 120 || str.getByte(i + 1) == 88)) {
                byte hd1 = str.getByte(i + 2);
                byte hd2 = str.getByte(i + 3);
                if (DrillStringUtils.isHexDigit(hd1) && DrillStringUtils.isHexDigit(hd2)) {
                    b = (byte)((DrillStringUtils.toBinaryFromHex(hd1) << 4) + DrillStringUtils.toBinaryFromHex(hd2));
                    i += 3;
                }
            }
            out.setByte(dstEnd++, b);
        }
        return dstEnd;
    }

    private static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        if (ch >= 97 && ch <= 102) {
            return (byte)(10 + (byte)(ch - 97));
        }
        return (byte)(ch - 48);
    }

    private static boolean isHexDigit(byte c) {
        return c >= 97 && c <= 102 || c >= 65 && c <= 70 || c >= 48 && c <= 57;
    }

    public static String sanitizeCSV(String csv) {
        String[] tokens = csv.split(",");
        return Arrays.stream(tokens).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
    }

    public static String removeLeadingSlash(String path) {
        return StringUtils.stripStart(path, "/");
    }
}

