/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.io;

import java.util.concurrent.atomic.AtomicReference;
import oadd.io.jsonwebtoken.impl.io.InstanceLocator;
import oadd.io.jsonwebtoken.io.Serializer;
import oadd.io.jsonwebtoken.lang.Assert;
import oadd.io.jsonwebtoken.lang.Classes;

public class RuntimeClasspathSerializerLocator
implements InstanceLocator<Serializer> {
    private static final AtomicReference<Serializer<Object>> SERIALIZER = new AtomicReference();

    @Override
    public Serializer<Object> getInstance() {
        Serializer<Object> serializer = SERIALIZER.get();
        if (serializer == null) {
            serializer = this.locate();
            Assert.state(serializer != null, "locate() cannot return null.");
            if (!this.compareAndSet(serializer)) {
                serializer = SERIALIZER.get();
            }
        }
        Assert.state(serializer != null, "serializer cannot be null.");
        return serializer;
    }

    protected Serializer<Object> locate() {
        if (this.isAvailable("oadd.io.jsonwebtoken.io.JacksonSerializer")) {
            return (Serializer)Classes.newInstance("oadd.io.jsonwebtoken.io.JacksonSerializer");
        }
        if (this.isAvailable("oadd.io.jsonwebtoken.io.OrgJsonSerializer")) {
            return (Serializer)Classes.newInstance("oadd.io.jsonwebtoken.io.OrgJsonSerializer");
        }
        throw new IllegalStateException("Unable to discover any JSON Serializer implementations on the classpath.");
    }

    protected boolean compareAndSet(Serializer<Object> s2) {
        return SERIALIZER.compareAndSet(null, s2);
    }

    protected boolean isAvailable(String fqcn) {
        return Classes.isAvailable(fqcn);
    }
}

