/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.PskIdentity;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;

public class OfferedPsks {
    protected Vector identities;
    protected Vector binders;

    public OfferedPsks(Vector identities, Vector binders) {
        if (null == identities || identities.isEmpty()) {
            throw new IllegalArgumentException("'identities' cannot be null or empty");
        }
        if (null == binders || identities.size() != binders.size()) {
            throw new IllegalArgumentException("'binders' must be non-null and the same length as 'identities'");
        }
        this.identities = identities;
        this.binders = binders;
    }

    public Vector getBinders() {
        return this.binders;
    }

    public Vector getIdentities() {
        return this.identities;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] binder;
        PskIdentity identity;
        int i;
        int totalLengthIdentities = 0;
        for (i = 0; i < this.identities.size(); ++i) {
            identity = (PskIdentity)this.identities.elementAt(i);
            totalLengthIdentities += 2 + identity.getIdentity().length + 4;
        }
        TlsUtils.checkUint16(totalLengthIdentities);
        TlsUtils.writeUint16(totalLengthIdentities, output);
        for (i = 0; i < this.identities.size(); ++i) {
            identity = (PskIdentity)this.identities.elementAt(i);
            identity.encode(output);
        }
        int totalLengthBinders = 0;
        for (i = 0; i < this.binders.size(); ++i) {
            binder = (byte[])this.binders.elementAt(i);
            totalLengthBinders += 1 + binder.length;
        }
        TlsUtils.checkUint16(totalLengthBinders);
        TlsUtils.writeUint16(totalLengthBinders, output);
        for (i = 0; i < this.binders.size(); ++i) {
            binder = (byte[])this.binders.elementAt(i);
            TlsUtils.writeOpaque8(binder, output);
        }
    }

    public static OfferedPsks parse(InputStream input) throws IOException {
        Vector<PskIdentity> identities = new Vector<PskIdentity>();
        int totalLengthIdentities = TlsUtils.readUint16(input);
        if (totalLengthIdentities < 7) {
            throw new TlsFatalAlert(50);
        }
        byte[] identitiesData = TlsUtils.readFully(totalLengthIdentities, input);
        ByteArrayInputStream buf = new ByteArrayInputStream(identitiesData);
        do {
            PskIdentity identity = PskIdentity.parse(buf);
            identities.add(identity);
        } while (buf.available() > 0);
        Vector<byte[]> binders = new Vector<byte[]>();
        int totalLengthBinders = TlsUtils.readUint16(input);
        if (totalLengthBinders < 33) {
            throw new TlsFatalAlert(50);
        }
        byte[] bindersData = TlsUtils.readFully(totalLengthBinders, input);
        ByteArrayInputStream buf2 = new ByteArrayInputStream(bindersData);
        do {
            byte[] binder = TlsUtils.readOpaque8(input, 32);
            binders.add(binder);
        } while (buf2.available() > 0);
        return new OfferedPsks(identities, binders);
    }
}

