/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import oadd.org.apache.zookeeper.common.FileChangeWatcher;
import oadd.org.apache.zookeeper.common.FileKeyStoreLoaderBuilderProvider;
import oadd.org.apache.zookeeper.common.KeyStoreFileType;
import oadd.org.apache.zookeeper.common.SSLContextAndOptions;
import oadd.org.apache.zookeeper.common.X509Exception;
import oadd.org.apache.zookeeper.common.ZKConfig;
import oadd.org.apache.zookeeper.common.ZKFipsLoader;
import oadd.org.apache.zookeeper.common.ZKTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class X509Util
implements Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);
    private static final String REJECT_CLIENT_RENEGOTIATION_PROPERTY = "jdk.tls.rejectClientInitiatedRenegotiation";
    static final String DEFAULT_PROTOCOL = "TLSv1.2";
    private static final String[] DEFAULT_CIPHERS_JAVA8;
    private static final String[] DEFAULT_CIPHERS_JAVA9;
    public static final int DEFAULT_HANDSHAKE_DETECTION_TIMEOUT_MILLIS = 5000;
    private String sslProtocolProperty = this.getConfigPrefix() + "protocol";
    private String sslEnabledProtocolsProperty = this.getConfigPrefix() + "enabledProtocols";
    private String cipherSuitesProperty = this.getConfigPrefix() + "ciphersuites";
    private String sslKeystoreLocationProperty = this.getConfigPrefix() + "keyStore.location";
    private String sslKeystorePasswdProperty = this.getConfigPrefix() + "keyStore.password";
    private String sslKeystoreTypeProperty = this.getConfigPrefix() + "keyStore.type";
    private String sslTruststoreLocationProperty = this.getConfigPrefix() + "trustStore.location";
    private String sslTruststorePasswdProperty = this.getConfigPrefix() + "trustStore.password";
    private String sslTruststoreTypeProperty = this.getConfigPrefix() + "trustStore.type";
    private String sslHostnameVerificationEnabledProperty = this.getConfigPrefix() + "hostnameVerification";
    private String sslCrlEnabledProperty = this.getConfigPrefix() + "crl";
    private String sslOcspEnabledProperty = this.getConfigPrefix() + "ocsp";
    private String sslClientAuthProperty = this.getConfigPrefix() + "clientAuth";
    private String sslHandshakeDetectionTimeoutMillisProperty = this.getConfigPrefix() + "handshakeDetectionTimeoutMillis";
    private ZKConfig zkConfig;
    private AtomicReference<SSLContextAndOptions> defaultSSLContextAndOptions = new AtomicReference<Object>(null);
    private FileChangeWatcher keyStoreFileWatcher;
    private FileChangeWatcher trustStoreFileWatcher;
    private static final String DEFAULT_INSTALL_LOCATION = "/opt/mapr";
    private static final String DEFAULT_CREDSTORE_PASSWORD = "none";

    private static String[] getGCMCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    }

    private static String[] getCBCCiphers() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"};
    }

    private static String[] concatArrays(String[] left, String[] right) {
        String[] result = new String[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public X509Util() {
        this(null);
    }

    public X509Util(ZKConfig zkConfig) {
        this.zkConfig = zkConfig;
        this.trustStoreFileWatcher = null;
        this.keyStoreFileWatcher = null;
    }

    protected abstract String getConfigPrefix();

    protected abstract boolean shouldVerifyClientHostname();

    public String getSslProtocolProperty() {
        return this.sslProtocolProperty;
    }

    public String getSslEnabledProtocolsProperty() {
        return this.sslEnabledProtocolsProperty;
    }

    public String getCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystoreLocationProperty() {
        return this.sslKeystoreLocationProperty;
    }

    public String getSslCipherSuitesProperty() {
        return this.cipherSuitesProperty;
    }

    public String getSslKeystorePasswdProperty() {
        return this.sslKeystorePasswdProperty;
    }

    public String getSslKeystoreTypeProperty() {
        return this.sslKeystoreTypeProperty;
    }

    public String getSslTruststoreLocationProperty() {
        return this.sslTruststoreLocationProperty;
    }

    public String getSslTruststorePasswdProperty() {
        return this.sslTruststorePasswdProperty;
    }

    public String getSslTruststoreTypeProperty() {
        return this.sslTruststoreTypeProperty;
    }

    public String getSslHostnameVerificationEnabledProperty() {
        return this.sslHostnameVerificationEnabledProperty;
    }

    public String getSslCrlEnabledProperty() {
        return this.sslCrlEnabledProperty;
    }

    public String getSslOcspEnabledProperty() {
        return this.sslOcspEnabledProperty;
    }

    public String getSslClientAuthProperty() {
        return this.sslClientAuthProperty;
    }

    public String getSslHandshakeDetectionTimeoutMillisProperty() {
        return this.sslHandshakeDetectionTimeoutMillisProperty;
    }

    public SSLContext getDefaultSSLContext() throws X509Exception.SSLContextException {
        return this.getDefaultSSLContextAndOptions().getSSLContext();
    }

    public SSLContext createSSLContext(ZKConfig config) throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(config).getSSLContext();
    }

    public SSLContextAndOptions getDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions result = this.defaultSSLContextAndOptions.get();
        if (result == null && !this.defaultSSLContextAndOptions.compareAndSet(null, result = this.createSSLContextAndOptions())) {
            result = this.defaultSSLContextAndOptions.get();
        }
        return result;
    }

    private void resetDefaultSSLContextAndOptions() throws X509Exception.SSLContextException {
        SSLContextAndOptions newContext = this.createSSLContextAndOptions();
        this.defaultSSLContextAndOptions.set(newContext);
    }

    private SSLContextAndOptions createSSLContextAndOptions() throws X509Exception.SSLContextException {
        return this.createSSLContextAndOptions(this.zkConfig == null ? new ZKConfig() : this.zkConfig);
    }

    public int getSslHandshakeTimeoutMillis() {
        try {
            SSLContextAndOptions ctx = this.getDefaultSSLContextAndOptions();
            return ctx.getHandshakeDetectionTimeoutMillis();
        }
        catch (X509Exception.SSLContextException e) {
            LOG.error("Error creating SSL context and options", e);
            return 5000;
        }
        catch (Exception e) {
            LOG.error("Error parsing config property " + this.getSslHandshakeDetectionTimeoutMillisProperty(), e);
            return 5000;
        }
    }

    public SSLContextAndOptions createSSLContextAndOptions(ZKConfig config) throws X509Exception.SSLContextException {
        boolean sslClientHostnameVerificationEnabled;
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        String keyStoreLocationProp = config.getProperty(this.sslKeystoreLocationProperty, "");
        String keyStorePasswordProp = config.getProperty(this.sslKeystorePasswdProperty, "");
        String keyStoreTypeProp = config.getProperty(this.sslKeystoreTypeProperty);
        KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(keyStoreTypeProp, keyStoreLocationProp);
        if (storeFileType == KeyStoreFileType.BCFKS) {
            ZKFipsLoader.loadZKFipsProviders();
        }
        if (keyStoreLocationProp.isEmpty()) {
            LOG.warn(this.getSslKeystoreLocationProperty() + " not specified");
        } else {
            try {
                if (keyStorePasswordProp == null || keyStorePasswordProp.isBlank() || keyStorePasswordProp.equals("__##CREDENTIALS_STORE##__")) {
                    char[] keyStorePasswordPropChars = X509Util.getPasswordFromCredStore(CredStore.CRED_KEYSTORE, "ssl.server.keystore.password", storeFileType == KeyStoreFileType.BCFKS ? "bcfks" : "jks");
                    keyStorePasswordProp = String.valueOf(keyStorePasswordPropChars);
                }
                keyManagers = new KeyManager[]{X509Util.createKeyManager(keyStoreLocationProp, keyStorePasswordProp, keyStoreTypeProp)};
            }
            catch (X509Exception.KeyManagerException keyManagerException) {
                throw new X509Exception.SSLContextException("Failed to create KeyManager", keyManagerException);
            }
            catch (IllegalArgumentException e) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslKeystoreTypeProperty + ": " + keyStoreTypeProp, e);
            }
        }
        String trustStoreLocationProp = config.getProperty(this.sslTruststoreLocationProperty, "");
        String trustStorePasswordProp = config.getProperty(this.sslTruststorePasswdProperty, "");
        String trustStoreTypeProp = config.getProperty(this.sslTruststoreTypeProperty);
        boolean sslCrlEnabled = config.getBoolean(this.sslCrlEnabledProperty);
        boolean sslOcspEnabled = config.getBoolean(this.sslOcspEnabledProperty);
        boolean sslServerHostnameVerificationEnabled = config.getBoolean(this.getSslHostnameVerificationEnabledProperty(), true);
        boolean bl = sslClientHostnameVerificationEnabled = sslServerHostnameVerificationEnabled && this.shouldVerifyClientHostname();
        if (trustStoreLocationProp.isEmpty()) {
            LOG.warn(this.getSslTruststoreLocationProperty() + " not specified");
        } else {
            try {
                if (trustStorePasswordProp == null || trustStorePasswordProp.isBlank() || trustStorePasswordProp.equals("__##CREDENTIALS_STORE##__")) {
                    char[] trustStorePasswordPropChars = X509Util.getPasswordFromCredStore(CredStore.CRED_TRUSTSTORE, "ssl.server.truststore.password", storeFileType == KeyStoreFileType.BCFKS ? "bcfks" : "jks");
                    trustStorePasswordProp = String.valueOf(trustStorePasswordPropChars);
                }
                trustManagers = new TrustManager[]{X509Util.createTrustManager(trustStoreLocationProp, trustStorePasswordProp, trustStoreTypeProp, sslCrlEnabled, sslOcspEnabled, sslServerHostnameVerificationEnabled, sslClientHostnameVerificationEnabled)};
            }
            catch (X509Exception.TrustManagerException trustManagerException) {
                throw new X509Exception.SSLContextException("Failed to create TrustManager", trustManagerException);
            }
            catch (IllegalArgumentException e) {
                throw new X509Exception.SSLContextException("Bad value for " + this.sslTruststoreTypeProperty + ": " + trustStoreTypeProp, e);
            }
        }
        String protocol = config.getProperty(this.sslProtocolProperty, DEFAULT_PROTOCOL);
        try {
            SSLContext sslContext = storeFileType == KeyStoreFileType.BCFKS ? ZKFipsLoader.getBCFKSSSLContext(protocol) : SSLContext.getInstance(protocol);
            sslContext.init(keyManagers, trustManagers, null);
            return new SSLContextAndOptions(this, config, sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException sslContextInitException) {
            throw new X509Exception.SSLContextException(sslContextInitException);
        }
    }

    private static char[] getPasswordFromCredStore(CredStore credStore, String alias, String storeType) throws IllegalArgumentException {
        char[] cArray;
        String storePassword;
        String credentialStoreType = storeType;
        if (storeType.equalsIgnoreCase("jks") || storeType.equalsIgnoreCase("jceks")) {
            credentialStoreType = "jceks";
        } else if (!storeType.equalsIgnoreCase("bcfks")) {
            throw new IllegalArgumentException("Credential store type must be either jks, jceks or bcfks");
        }
        String maprHomeDir = Objects.requireNonNullElse(System.getenv("MAPR_HOME"), DEFAULT_INSTALL_LOCATION);
        String maprConfDir = maprHomeDir + "/conf";
        String keyPassword = storePassword = Objects.requireNonNullElse(System.getenv("hadoopCredStorePass"), DEFAULT_CREDSTORE_PASSWORD);
        String credFilePrefix = credStore == CredStore.CRED_KEYSTORE ? "maprkeycreds." : "maprtrustcreds.";
        File credsFile = new File(maprConfDir, credFilePrefix + credentialStoreType);
        FileInputStream fis = new FileInputStream(credsFile);
        try {
            KeyStore ks = credentialStoreType.equals("jceks") ? KeyStore.getInstance(credentialStoreType) : KeyStore.getInstance("BCFKS", "BCFIPS");
            ks.load(fis, storePassword.toCharArray());
            SecretKey secretKey = (SecretKey)ks.getKey(alias, keyPassword.toCharArray());
            byte[] secretBytes = secretKey.getEncoded();
            String secretBytesStr = new String(secretBytes);
            cArray = secretBytesStr.toCharArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("Failed to get password from Hadoop Credential Store " + credsFile + " with error: " + e.getMessage());
                return null;
            }
        }
        fis.close();
        return cArray;
    }

    public static X509KeyManager createKeyManager(String keyStoreLocation, String keyStorePassword, String keyStoreTypeProp) throws X509Exception.KeyManagerException {
        if (keyStorePassword == null) {
            keyStorePassword = "";
        }
        try {
            KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(keyStoreTypeProp, keyStoreLocation);
            KeyStore ks = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setKeyStorePath(keyStoreLocation).setKeyStorePassword(keyStorePassword).build().loadKeyStore();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, keyStorePassword.toCharArray());
            for (KeyManager km4 : kmf.getKeyManagers()) {
                if (!(km4 instanceof X509KeyManager)) continue;
                return (X509KeyManager)km4;
            }
            throw new X509Exception.KeyManagerException("Couldn't find X509KeyManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new X509Exception.KeyManagerException(e);
        }
    }

    public static X509TrustManager createTrustManager(String trustStoreLocation, String trustStorePassword, String trustStoreTypeProp, boolean crlEnabled, boolean ocspEnabled, boolean serverHostnameVerificationEnabled, boolean clientHostnameVerificationEnabled) throws X509Exception.TrustManagerException {
        if (trustStorePassword == null) {
            trustStorePassword = "";
        }
        try {
            KeyStoreFileType storeFileType = KeyStoreFileType.fromPropertyValueOrFileName(trustStoreTypeProp, trustStoreLocation);
            KeyStore ts = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(storeFileType).setTrustStorePath(trustStoreLocation).setTrustStorePassword(trustStorePassword).build().loadTrustStore();
            PKIXBuilderParameters pbParams = new PKIXBuilderParameters(ts, (CertSelector)new X509CertSelector());
            if (crlEnabled || ocspEnabled) {
                pbParams.setRevocationEnabled(true);
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                System.setProperty("com.sun.security.enableCRLDP", "true");
                if (ocspEnabled) {
                    Security.setProperty("ocsp.enable", "true");
                }
            } else {
                pbParams.setRevocationEnabled(false);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(new CertPathTrustManagerParameters(pbParams));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                return new ZKTrustManager((X509ExtendedTrustManager)tm, serverHostnameVerificationEnabled, clientHostnameVerificationEnabled);
            }
            throw new X509Exception.TrustManagerException("Couldn't find X509TrustManager");
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new X509Exception.TrustManagerException(e);
        }
    }

    public SSLSocket createSSLSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket();
    }

    public SSLSocket createSSLSocket(Socket socket, byte[] pushbackBytes) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLSocket(socket, pushbackBytes);
    }

    public SSLServerSocket createSSLServerSocket() throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket();
    }

    public SSLServerSocket createSSLServerSocket(int port) throws X509Exception, IOException {
        return this.getDefaultSSLContextAndOptions().createSSLServerSocket(port);
    }

    static String[] getDefaultCipherSuites() {
        return X509Util.getDefaultCipherSuitesForJavaVersion(System.getProperty("java.specification.version"));
    }

    static String[] getDefaultCipherSuitesForJavaVersion(String javaVersion) {
        Objects.requireNonNull(javaVersion);
        if (javaVersion.matches("\\d+")) {
            LOG.debug("Using Java9+ optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA9;
        }
        if (javaVersion.startsWith("1.")) {
            LOG.debug("Using Java8 optimized cipher suites for Java version {}", (Object)javaVersion);
            return DEFAULT_CIPHERS_JAVA8;
        }
        LOG.debug("Could not parse java version {}, using Java8 optimized cipher suites", (Object)javaVersion);
        return DEFAULT_CIPHERS_JAVA8;
    }

    public static boolean isFipsMode() {
        try {
            return ZKFipsLoader.isFipsMode();
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private FileChangeWatcher newFileChangeWatcher(String fileLocation) throws IOException {
        if (fileLocation == null || fileLocation.isEmpty()) {
            return null;
        }
        Path filePath = Paths.get(fileLocation, new String[0]).toAbsolutePath();
        Path parentPath = filePath.getParent();
        if (parentPath == null) {
            throw new IOException("Key/trust store path does not have a parent: " + filePath);
        }
        return new FileChangeWatcher(parentPath, watchEvent -> this.handleWatchEvent(filePath, (WatchEvent<?>)watchEvent));
    }

    public void enableCertFileReloading() throws IOException {
        FileChangeWatcher newTrustStoreFileWatcher;
        LOG.info("enabling cert file reloading");
        ZKConfig config = this.zkConfig == null ? new ZKConfig() : this.zkConfig;
        FileChangeWatcher newKeyStoreFileWatcher = this.newFileChangeWatcher(config.getProperty(this.sslKeystoreLocationProperty));
        if (newKeyStoreFileWatcher != null) {
            if (this.keyStoreFileWatcher != null) {
                this.keyStoreFileWatcher.stop();
            }
            this.keyStoreFileWatcher = newKeyStoreFileWatcher;
            this.keyStoreFileWatcher.start();
        }
        if ((newTrustStoreFileWatcher = this.newFileChangeWatcher(config.getProperty(this.sslTruststoreLocationProperty))) != null) {
            if (this.trustStoreFileWatcher != null) {
                this.trustStoreFileWatcher.stop();
            }
            this.trustStoreFileWatcher = newTrustStoreFileWatcher;
            this.trustStoreFileWatcher.start();
        }
    }

    @Override
    public void close() {
        if (this.keyStoreFileWatcher != null) {
            this.keyStoreFileWatcher.stop();
            this.keyStoreFileWatcher = null;
        }
        if (this.trustStoreFileWatcher != null) {
            this.trustStoreFileWatcher.stop();
            this.trustStoreFileWatcher = null;
        }
    }

    private void handleWatchEvent(Path filePath, WatchEvent<?> event) {
        Path eventFilePath;
        boolean shouldResetContext = false;
        Path dirPath = filePath.getParent();
        if (event.kind().equals(StandardWatchEventKinds.OVERFLOW)) {
            shouldResetContext = true;
        } else if ((event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) || event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE)) && filePath.equals(eventFilePath = dirPath.resolve((Path)event.context()))) {
            shouldResetContext = true;
        }
        if (shouldResetContext) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to reset default SSL context after receiving watch event: " + event.kind() + " with context: " + event.context());
            }
            try {
                this.resetDefaultSSLContextAndOptions();
            }
            catch (X509Exception.SSLContextException e) {
                throw new RuntimeException(e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring watch event and keeping previous default SSL context. Event kind: " + event.kind() + " with context: " + event.context());
        }
    }

    static {
        if (System.getProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY) == null) {
            LOG.info("Setting -D {}=true to disable client-initiated TLS renegotiation", (Object)REJECT_CLIENT_RENEGOTIATION_PROPERTY);
            System.setProperty(REJECT_CLIENT_RENEGOTIATION_PROPERTY, Boolean.TRUE.toString());
        }
        DEFAULT_CIPHERS_JAVA8 = X509Util.concatArrays(X509Util.getCBCCiphers(), X509Util.getGCMCiphers());
        DEFAULT_CIPHERS_JAVA9 = X509Util.concatArrays(X509Util.getGCMCiphers(), X509Util.getCBCCiphers());
    }

    public static enum CredStore {
        CRED_KEYSTORE,
        CRED_TRUSTSTORE;

    }

    public static enum ClientAuth {
        NONE,
        WANT,
        NEED;


        public static ClientAuth fromPropertyValue(String prop) {
            if (prop == null || prop.length() == 0) {
                return NEED;
            }
            return ClientAuth.valueOf(prop.toUpperCase());
        }
    }
}

