/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.log4j.or.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import oadd.org.apache.log4j.helpers.LogLog;
import oadd.org.apache.log4j.or.ObjectRenderer;

public class MessageRenderer
implements ObjectRenderer {
    public String doRender(Object o) {
        if (o instanceof Message) {
            StringBuilder sbuf = new StringBuilder();
            Message m4 = (Message)o;
            try {
                sbuf.append("DeliveryMode=");
                switch (m4.getJMSDeliveryMode()) {
                    case 1: {
                        sbuf.append("NON_PERSISTENT");
                        break;
                    }
                    case 2: {
                        sbuf.append("PERSISTENT");
                        break;
                    }
                    default: {
                        sbuf.append("UNKNOWN");
                    }
                }
                sbuf.append(", CorrelationID=");
                sbuf.append(m4.getJMSCorrelationID());
                sbuf.append(", Destination=");
                sbuf.append(m4.getJMSDestination());
                sbuf.append(", Expiration=");
                sbuf.append(m4.getJMSExpiration());
                sbuf.append(", MessageID=");
                sbuf.append(m4.getJMSMessageID());
                sbuf.append(", Priority=");
                sbuf.append(m4.getJMSPriority());
                sbuf.append(", Redelivered=");
                sbuf.append(m4.getJMSRedelivered());
                sbuf.append(", ReplyTo=");
                sbuf.append(m4.getJMSReplyTo());
                sbuf.append(", Timestamp=");
                sbuf.append(m4.getJMSTimestamp());
                sbuf.append(", Type=");
                sbuf.append(m4.getJMSType());
            }
            catch (JMSException e) {
                LogLog.error("Could not parse Message.", e);
            }
            return sbuf.toString();
        }
        return o.toString();
    }
}

