/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.jute;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oadd.org.apache.jute.Index;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.Record;
import oadd.org.apache.jute.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlInputArchive
implements InputArchive {
    private ArrayList<Value> valList = new ArrayList();
    private int vLen;
    private int vIdx;

    private Value next() throws IOException {
        if (this.vIdx < this.vLen) {
            Value v = this.valList.get(this.vIdx);
            this.valList.set(this.vIdx, null);
            ++this.vIdx;
            return v;
        }
        throw new IOException("Error in deserialization.");
    }

    static XmlInputArchive getArchive(InputStream strm) throws ParserConfigurationException, SAXException, IOException {
        return new XmlInputArchive(strm);
    }

    public XmlInputArchive(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        XMLParser handler = new XMLParser(this.valList);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        this.vLen = this.valList.size();
        this.vIdx = 0;
    }

    @Override
    public byte readByte(String tag) throws IOException {
        Value v = this.next();
        if (!"ex:i1".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Byte.parseByte(v.getValue());
    }

    @Override
    public boolean readBool(String tag) throws IOException {
        Value v = this.next();
        if (!"boolean".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return "1".equals(v.getValue());
    }

    @Override
    public int readInt(String tag) throws IOException {
        Value v = this.next();
        if (!"i4".equals(v.getType()) && !"int".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Integer.parseInt(v.getValue());
    }

    @Override
    public long readLong(String tag) throws IOException {
        Value v = this.next();
        if (!"ex:i8".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Long.parseLong(v.getValue());
    }

    @Override
    public float readFloat(String tag) throws IOException {
        Value v = this.next();
        if (!"ex:float".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Float.parseFloat(v.getValue());
    }

    @Override
    public double readDouble(String tag) throws IOException {
        Value v = this.next();
        if (!"double".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Double.parseDouble(v.getValue());
    }

    @Override
    public String readString(String tag) throws IOException {
        Value v = this.next();
        if (!"string".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Utils.fromXMLString(v.getValue());
    }

    @Override
    public byte[] readBuffer(String tag) throws IOException {
        Value v = this.next();
        if (!"string".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return Utils.fromXMLBuffer(v.getValue());
    }

    @Override
    public void readRecord(Record r, String tag) throws IOException {
        r.deserialize(this, tag);
    }

    @Override
    public void startRecord(String tag) throws IOException {
        Value v = this.next();
        if (!"struct".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
    }

    @Override
    public void endRecord(String tag) throws IOException {
        Value v = this.next();
        if (!"/struct".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
    }

    @Override
    public Index startVector(String tag) throws IOException {
        Value v = this.next();
        if (!"array".equals(v.getType())) {
            throw new IOException("Error deserializing " + tag + ".");
        }
        return new XmlIndex();
    }

    @Override
    public void endVector(String tag) throws IOException {
    }

    @Override
    public Index startMap(String tag) throws IOException {
        return this.startVector(tag);
    }

    @Override
    public void endMap(String tag) throws IOException {
        this.endVector(tag);
    }

    private class XmlIndex
    implements Index {
        private XmlIndex() {
        }

        @Override
        public boolean done() {
            Value v = (Value)XmlInputArchive.this.valList.get(XmlInputArchive.this.vIdx);
            if ("/array".equals(v.getType())) {
                XmlInputArchive.this.valList.set(XmlInputArchive.this.vIdx, null);
                XmlInputArchive.this.vIdx++;
                return true;
            }
            return false;
        }

        @Override
        public void incr() {
        }
    }

    private static class XMLParser
    extends DefaultHandler {
        private boolean charsValid = false;
        private ArrayList<Value> valList;

        private XMLParser(ArrayList<Value> vlist) {
            this.valList = vlist;
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String ns, String sname, String qname, Attributes attrs) throws SAXException {
            this.charsValid = false;
            if ("boolean".equals(qname) || "i4".equals(qname) || "int".equals(qname) || "string".equals(qname) || "double".equals(qname) || "ex:i1".equals(qname) || "ex:i8".equals(qname) || "ex:float".equals(qname)) {
                this.charsValid = true;
                this.valList.add(new Value(qname));
            } else if ("struct".equals(qname) || "array".equals(qname)) {
                this.valList.add(new Value(qname));
            }
        }

        @Override
        public void endElement(String ns, String sname, String qname) throws SAXException {
            this.charsValid = false;
            if ("struct".equals(qname) || "array".equals(qname)) {
                this.valList.add(new Value("/" + qname));
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (this.charsValid) {
                Value v = this.valList.get(this.valList.size() - 1);
                v.addChars(buf, offset, len);
            }
        }
    }

    private static class Value {
        private String type;
        private StringBuffer sb;

        public Value(String t2) {
            this.type = t2;
            this.sb = new StringBuffer();
        }

        public void addChars(char[] buf, int offset, int len) {
            this.sb.append(buf, offset, len);
        }

        public String getValue() {
            return this.sb.toString();
        }

        public String getType() {
            return this.type;
        }
    }
}

