/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import oadd.org.apache.drill.exec.expr.holders.SmallIntHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableSmallIntVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableSmallIntWriterImpl
extends AbstractFieldWriter {
    private final NullableSmallIntVector.Mutator mutator;
    final NullableSmallIntVector vector;

    public NullableSmallIntWriterImpl(NullableSmallIntVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(SmallIntHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableSmallIntHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeSmallInt(short value) {
        this.mutator.setSafe(this.idx(), 1, value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

