/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.DictHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedValueHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.util.CallBack;
import oadd.org.apache.drill.exec.util.JsonStringHashMap;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.VectorWithOrdinal;
import oadd.org.apache.drill.exec.vector.complex.impl.SingleDictReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DictVector
extends AbstractRepeatedMapVector {
    public static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.DICT);
    public static final String FIELD_KEY_NAME = "key";
    public static final String FIELD_VALUE_NAME = "value";
    public static final List<String> fieldNames = Arrays.asList("key", "value");
    private static final Logger logger = LoggerFactory.getLogger(DictVector.class);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private final SingleDictReaderImpl reader = new SingleDictReaderImpl(this);
    private TypeProtos.MajorType keyType;
    private TypeProtos.MajorType valueType;
    private Boolean valueNullable;

    public DictVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field.clone(), allocator, callBack);
    }

    public DictVector(MaterializedField field, BufferAllocator allocator, CallBack callBack, TypeProtos.MajorType keyType, TypeProtos.MajorType valueType) {
        this(field, allocator, callBack);
        this.setKeyValueTypes(keyType, valueType);
    }

    @Override
    public SingleDictReaderImpl getReader() {
        return this.reader;
    }

    @Override
    protected Collection<String> getChildFieldNames() {
        return fieldNames;
    }

    public void transferTo(DictVector target) {
        this.makeTransferPair(target);
        target.setKeyValueTypes(this.keyType, this.valueType);
    }

    public TransferPair makeTransferPair(DictVector to) {
        return new DictTransferPair(to);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new DictTransferPair(this.getField().getName(), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new DictTransferPair((DictVector)to);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new DictTransferPair(ref, allocator);
    }

    @Override
    public void putChild(String name, ValueVector vector) {
        if (!fieldNames.contains(name)) {
            throw new DrillRuntimeException(String.format("Unexpected field '%s' added to DictVector: the vector can have '%s' and '%s' children only", name, FIELD_KEY_NAME, FIELD_VALUE_NAME));
        }
        TypeProtos.MajorType fieldType = vector.getField().getType();
        if (name.equals(FIELD_KEY_NAME)) {
            if (Types.isRepeated(fieldType) || Types.isComplex(fieldType)) {
                throw new DrillRuntimeException("DictVector supports primitive key type only. Found: " + fieldType);
            }
            this.checkTypes(this.keyType, fieldType, FIELD_KEY_NAME);
            this.keyType = fieldType;
        } else {
            this.checkTypes(this.valueType, fieldType, FIELD_VALUE_NAME);
            this.valueType = fieldType;
        }
        super.putChild(name, vector);
    }

    private void checkTypes(TypeProtos.MajorType type, TypeProtos.MajorType newType, String fieldName) {
        assert (type == null || newType.equals(type)) : String.format("Type mismatch for %s field in DICT: expected '%s' but found '%s'", fieldName, type, newType);
    }

    @Override
    public ValueVector getChild(String name) {
        assert (fieldNames.contains(name)) : String.format("DictVector has '%s' and '%s' ValueVectors only", "key", "value");
        return super.getChild(name);
    }

    @Override
    public void exchange(ValueVector other) {
        DictVector map = (DictVector)other;
        assert (this.keyType == null || this.keyType.equals(map.keyType)) : "Cannot exchange DictVector with different key types";
        assert (this.valueType == null || this.valueType.equals(map.valueType)) : "Cannot exchange DictVector with different value types";
        super.exchange(other);
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        assert (fieldNames.contains(name)) : String.format("DictVector has '%s' and '%s' children only", "key", "value");
        ValueVector vector = this.getChild(name);
        switch (name) {
            case "key": {
                return new VectorWithOrdinal(vector, 0);
            }
            case "value": {
                return new VectorWithOrdinal(vector, 1);
            }
        }
        logger.warn("Field with name '{}' is not present in map vector.", (Object)name);
        return null;
    }

    @Override
    TypeProtos.MajorType getLastPathType() {
        if (Types.isRepeated(this.valueType)) {
            return this.valueType;
        }
        return this.valueType.toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build();
    }

    @Override
    public <T extends ValueVector> T getChild(String name, Class<T> clazz) {
        assert (fieldNames.contains(name)) : "No such field in DictVector: " + name;
        return super.getChild(name, clazz);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public ValueVector getKeys() {
        return this.getChild(FIELD_KEY_NAME);
    }

    public ValueVector getValues() {
        return this.getChild(FIELD_VALUE_NAME);
    }

    public TypeProtos.MajorType getKeyType() {
        return this.keyType;
    }

    public TypeProtos.MajorType getValueType() {
        if (this.valueType == null) {
            this.valueType = this.getValues().getField().getType();
        }
        return this.valueType;
    }

    public boolean isValueNullable() {
        if (this.valueNullable == null) {
            this.valueNullable = Types.isNullable(this.getValueType());
        }
        return this.valueNullable;
    }

    @Override
    RepeatedValueHolder getValueHolder() {
        return new DictHolder();
    }

    private void setKeyValueTypes(TypeProtos.MajorType keyType, TypeProtos.MajorType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public class Mutator
    extends AbstractRepeatedMapVector.Mutator {
    }

    public class Accessor
    extends AbstractRepeatedMapVector.Accessor {
        @Override
        public Object getObject(int index) {
            int start = DictVector.this.offsets.getAccessor().get(index);
            int end = DictVector.this.offsets.getAccessor().get(index + 1);
            ValueVector keys = DictVector.this.getKeys();
            ValueVector values = DictVector.this.getValues();
            JsonStringHashMap<Object, Object> result = new JsonStringHashMap<Object, Object>();
            for (int i = start; i < end; ++i) {
                Object key = keys.getAccessor().getObject(i);
                Object value = values.getAccessor().getObject(i);
                result.put(key, value);
            }
            return result;
        }

        public void get(int index, DictHolder holder) {
            int valueCapacity = DictVector.this.getValueCapacity();
            assert (index < valueCapacity) : String.format("Attempted to access index %d when value capacity is %d", index, valueCapacity);
            holder.vector = DictVector.this;
            holder.reader = DictVector.this.reader;
            holder.start = DictVector.this.offsets.getAccessor().get(index);
            holder.end = DictVector.this.offsets.getAccessor().get(index + 1);
        }
    }

    private class DictTransferPair
    extends AbstractRepeatedMapVector.AbstractRepeatedMapTransferPair<DictVector> {
        DictTransferPair(String path, BufferAllocator allocator) {
            this(new DictVector(MaterializedField.create(path, TYPE), allocator, dictVector.callBack), false);
        }

        DictTransferPair(DictVector to) {
            this(to, true);
        }

        DictTransferPair(DictVector to, boolean allocate) {
            super((AbstractRepeatedMapVector)DictVector.this, (AbstractRepeatedMapVector)to, allocate);
            to.keyType = ((DictVector)this.from).keyType;
            to.valueType = ((DictVector)this.from).valueType;
        }
    }
}

