/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import oadd.org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.joda.time.Period;

public class ScalarArrayWriter
extends AbstractArrayWriter.BaseArrayWriter {
    private final ScalarWriter elementWriter;

    public ScalarArrayWriter(ColumnMetadata schema, RepeatedValueVector vector, BaseScalarWriter baseElementWriter) {
        super(schema, vector.getOffsetVector(), new AbstractScalarWriterImpl.ScalarObjectWriter(baseElementWriter));
        this.elementWriter = this.elementObjWriter.scalar();
    }

    public static AbstractArrayWriter.ArrayObjectWriter build(ColumnMetadata schema, RepeatedValueVector repeatedVector, BaseScalarWriter baseElementWriter) {
        return new AbstractArrayWriter.ArrayObjectWriter(new ScalarArrayWriter(schema, repeatedVector, baseElementWriter));
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.elementIndex = new ScalarElementWriterIndex();
        super.bindIndex(index);
        this.elementObjWriter.events().bindIndex(this.elementIndex);
    }

    @Override
    public void save() {
    }

    @Override
    public void setObject(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return;
        }
        String objClass = array.getClass().getName();
        if (!objClass.startsWith("[")) {
            throw new IllegalArgumentException(String.format("Argument must be an array. Column `%s`, value = %s", this.schema().name(), array.toString()));
        }
        char second = objClass.charAt(1);
        block0 : switch (second) {
            case '[': {
                char third = objClass.charAt(2);
                switch (third) {
                    case 'B': {
                        this.setBytesArray((byte[][])array);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown Java array type: %s, for column `%s`", objClass, this.schema().name()));
            }
            case 'B': {
                this.setByteArray((byte[])array);
                break;
            }
            case 'S': {
                this.setShortArray((short[])array);
                break;
            }
            case 'I': {
                this.setIntArray((int[])array);
                break;
            }
            case 'J': {
                this.setLongArray((long[])array);
                break;
            }
            case 'F': {
                this.setFloatArray((float[])array);
                break;
            }
            case 'D': {
                this.setDoubleArray((double[])array);
                break;
            }
            case 'Z': {
                this.setBooleanArray((boolean[])array);
                break;
            }
            case 'L': {
                int posn = objClass.indexOf(59);
                String memberClassName = objClass.substring(2, posn);
                if (memberClassName.equals(String.class.getName())) {
                    this.setStringArray((String[])array);
                    break;
                }
                if (memberClassName.equals(Period.class.getName())) {
                    this.setPeriodArray((Period[])array);
                    break;
                }
                if (memberClassName.equals(BigDecimal.class.getName())) {
                    this.setBigDecimalArray((BigDecimal[])array);
                    break;
                }
                if (memberClassName.equals(Integer.class.getName())) {
                    this.setIntObjectArray((Integer[])array);
                    break;
                }
                if (memberClassName.equals(Long.class.getName())) {
                    this.setLongObjectArray((Long[])array);
                    break;
                }
                if (memberClassName.equals(Double.class.getName())) {
                    this.setDoubleObjectArray((Double[])array);
                    break;
                }
                if (memberClassName.equals(Float.class.getName())) {
                    this.setFloatObjectArray((Float[])array);
                    break;
                }
                if (memberClassName.equals(Short.class.getName())) {
                    this.setShortObjectArray((Short[])array);
                    break;
                }
                if (memberClassName.equals(Byte.class.getName())) {
                    this.setByteObjectArray((Byte[])array);
                    break;
                }
                if (memberClassName.equals(Boolean.class.getName())) {
                    this.setBooleanObjectArray((Boolean[])array);
                    break;
                }
                throw new IllegalArgumentException("Unknown Java array type: " + memberClassName);
            }
            default: {
                throw new IllegalArgumentException("Unknown Java array type: " + objClass);
            }
        }
    }

    public void setObjectArray(Object[] value) {
        for (int i = 0; i < value.length; ++i) {
            Object element = value[i];
            if (element == null) continue;
            this.elementWriter.setObject(element);
        }
    }

    public void setBooleanArray(boolean[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i] ? 1 : 0);
        }
    }

    public void setBooleanObjectArray(Boolean[] value) {
        for (int i = 0; i < value.length; ++i) {
            Boolean element = value[i];
            if (element == null) continue;
            this.elementWriter.setBoolean(element);
        }
    }

    public void setBytesArray(byte[][] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setBytes(value[i], value[i].length);
        }
    }

    public void setByteArray(byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setByteObjectArray(Byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            Byte element = value[i];
            if (element == null) continue;
            this.elementWriter.setInt(element.byteValue());
        }
    }

    public void setShortArray(short[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setShortObjectArray(Short[] value) {
        for (int i = 0; i < value.length; ++i) {
            Short element = value[i];
            if (element == null) continue;
            this.elementWriter.setInt(element.shortValue());
        }
    }

    public void setIntArray(int[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setInt(value[i]);
        }
    }

    public void setIntObjectArray(Integer[] value) {
        for (int i = 0; i < value.length; ++i) {
            Integer element = value[i];
            if (element == null) continue;
            this.elementWriter.setInt(element);
        }
    }

    public void setLongArray(long[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setLong(value[i]);
        }
    }

    public void setLongObjectArray(Long[] value) {
        for (int i = 0; i < value.length; ++i) {
            Long element = value[i];
            if (element == null) continue;
            this.elementWriter.setLong(element);
        }
    }

    public void setFloatArray(float[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setDouble(value[i]);
        }
    }

    public void setFloatObjectArray(Float[] value) {
        for (int i = 0; i < value.length; ++i) {
            Float element = value[i];
            if (element == null) continue;
            this.elementWriter.setDouble(element.floatValue());
        }
    }

    public void setDoubleArray(double[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.elementWriter.setDouble(value[i]);
        }
    }

    public void setDoubleObjectArray(Double[] value) {
        for (int i = 0; i < value.length; ++i) {
            Double element = value[i];
            if (element == null) continue;
            this.elementWriter.setDouble(element);
        }
    }

    public void setStringArray(String[] value) {
        for (int i = 0; i < value.length; ++i) {
            String element = value[i];
            if (element == null) continue;
            this.elementWriter.setString(element);
        }
    }

    public void setPeriodArray(Period[] value) {
        for (int i = 0; i < value.length; ++i) {
            Period element = value[i];
            if (element == null) continue;
            this.elementWriter.setPeriod(element);
        }
    }

    public void setBigDecimalArray(BigDecimal[] value) {
        for (int i = 0; i < value.length; ++i) {
            BigDecimal element = value[i];
            if (element == null) continue;
            this.elementWriter.setDecimal(element);
        }
    }

    public class ScalarElementWriterIndex
    extends AbstractArrayWriter.ArrayElementWriterIndex {
        @Override
        public final void nextElement() {
            this.next();
        }

        @Override
        public final void prevElement() {
            this.prev();
        }
    }
}

